/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.AbstractAuthenticationAction;
import net.shibboleth.idp.authn.AuthenticationFlowDescriptor;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.idp.authn.MultiFactorAuthenticationTransition;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.MultiFactorAuthenticationContext;
import net.shibboleth.idp.profile.context.navigate.WebFlowCurrentEventLookupFunction;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.EventContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransitionMultiFactorAuthentication
extends AbstractAuthenticationAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(TransitionMultiFactorAuthentication.class);
    @Nonnull
    private Function<ProfileRequestContext, MultiFactorAuthenticationContext> multiFactorContextLookupStrategy = Functions.compose((Function)new ChildContextLookup(MultiFactorAuthenticationContext.class), (Function)new ChildContextLookup(AuthenticationContext.class));
    @Nonnull
    private Function<ProfileRequestContext, EventContext> eventContextLookupStrategy = new WebFlowCurrentEventLookupFunction();
    private boolean validateLoginTransitions = true;
    @Nullable
    private MultiFactorAuthenticationContext mfaContext;

    TransitionMultiFactorAuthentication() {
    }

    public void setMultiFactorContextLookupStrategy(@Nonnull Function<ProfileRequestContext, MultiFactorAuthenticationContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.multiFactorContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"MultiFactorAuthenticationContext lookup strategy cannot be null");
    }

    public void setEventContextLookupStrategy(@Nonnull Function<ProfileRequestContext, EventContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.eventContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"EventContext lookup strategy cannot be null");
    }

    public void setValidateLoginTransitions(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.validateLoginTransitions = flag;
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        if (!super.doPreExecute(profileRequestContext, authenticationContext)) {
            return false;
        }
        this.mfaContext = (MultiFactorAuthenticationContext)this.multiFactorContextLookupStrategy.apply((Object)profileRequestContext);
        if (this.mfaContext == null) {
            this.log.error("{} No MultiFactorAuthenticationContext found by lookup strategy", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        authenticationContext.setAttemptedFlow(this.mfaContext.getAuthenticationFlowDescriptor());
        EventContext eventCtx = (EventContext)this.eventContextLookupStrategy.apply((Object)profileRequestContext);
        String previousEvent = eventCtx != null && eventCtx.getEvent() != null ? eventCtx.getEvent().toString() : "proceed";
        AuthenticationResult result = authenticationContext.getAuthenticationResult();
        if (result != null) {
            if ("proceed".equals(previousEvent)) {
                this.log.debug("{} Preserving authentication result from '{}' flow", (Object)this.getLogPrefix(), (Object)result.getAuthenticationFlowId());
                this.mfaContext.getActiveResults().put(result.getAuthenticationFlowId(), result);
            } else {
                this.log.debug("{} Discarding incomplete authentication result from '{}' flow", (Object)this.getLogPrefix(), (Object)result.getAuthenticationFlowId());
            }
            authenticationContext.setAuthenticationResult(null);
        }
        String prevFlowId = this.mfaContext.getNextFlowId();
        this.mfaContext.setNextFlowId(null);
        if (prevFlowId == null) {
            this.log.debug("{} Applying MFA transition rule to determine initial state", (Object)this.getLogPrefix());
        } else {
            this.log.debug("{} Applying MFA transition rule to exit state '{}'", (Object)this.getLogPrefix(), (Object)prevFlowId);
        }
        String flowId = null;
        MultiFactorAuthenticationTransition transition = (MultiFactorAuthenticationTransition)this.mfaContext.getTransitionMap().get(prevFlowId);
        if (transition != null && (flowId = (String)transition.getNextFlowStrategy(previousEvent).apply((Object)profileRequestContext)) == null) {
            flowId = (String)transition.getNextFlowStrategy("*").apply((Object)profileRequestContext);
        }
        if (flowId != null) {
            this.log.debug("{} MFA flow transition after '{}' event to '{}' flow", new Object[]{this.getLogPrefix(), previousEvent, flowId});
            this.mfaContext.setNextFlowId(flowId);
            this.doTransition(profileRequestContext, authenticationContext, transition);
        } else {
            String event = this.mfaContext.getEvent() != null ? this.mfaContext.getEvent() : previousEvent;
            this.log.debug("{} MFA flow completing with event '{}'", (Object)this.getLogPrefix(), (Object)event);
            if ("proceed".equals(event)) {
                ActionSupport.buildProceedEvent((ProfileRequestContext)profileRequestContext);
            } else {
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)event);
            }
        }
    }

    private void doTransition(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext, @Nonnull MultiFactorAuthenticationTransition transition) {
        String flowId = this.mfaContext.getNextFlowId();
        if (!flowId.startsWith("authn/")) {
            ActionSupport.buildProceedEvent((ProfileRequestContext)profileRequestContext);
            return;
        }
        AuthenticationFlowDescriptor flow = (AuthenticationFlowDescriptor)authenticationContext.getAvailableFlows().get(flowId);
        if (flow == null) {
            this.log.error("{} Targeted login flow '{}' is not configured, check available flow descriptors", (Object)this.getLogPrefix(), (Object)flowId);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)(authenticationContext.isPassive() ? "NoPassive" : "NoPotentialFlow"));
            return;
        }
        AuthenticationResult activeResult = (AuthenticationResult)this.mfaContext.getActiveResults().get(flowId);
        if (activeResult != null) {
            if (flow.getReuseCondition().apply((Object)profileRequestContext)) {
                this.log.debug("{} Reusing active result for '{}' flow", (Object)this.getLogPrefix(), (Object)flowId);
                activeResult.setLastActivityInstantToNow();
                ActionSupport.buildProceedEvent((ProfileRequestContext)profileRequestContext);
                this.doExecute(profileRequestContext, authenticationContext);
                return;
            }
            this.log.debug("{} Condition blocked reuse of active result for '{}' flow", (Object)this.getLogPrefix(), (Object)flowId);
            this.mfaContext.getActiveResults().remove(flowId);
        }
        if (this.validateLoginTransitions) {
            if (authenticationContext.isPassive() && !flow.isPassiveAuthenticationSupported()) {
                this.log.error("{} Targeted login flow '{}' does not support passive authentication", (Object)this.getLogPrefix(), (Object)flowId);
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"NoPassive");
                return;
            }
            if ((authenticationContext.isForceAuthn() || authenticationContext.getMaxAge() > 0L) && !flow.isForcedAuthenticationSupported()) {
                this.log.error("{} Targeted login flow '{}' does not support forced re-authentication", (Object)this.getLogPrefix(), (Object)flowId);
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"RequestUnsupported");
                return;
            }
            if (!profileRequestContext.isBrowserProfile() && !flow.isNonBrowserSupported()) {
                this.log.error("{} Targeted login flow '{}' does not support non-browser authentication", (Object)this.getLogPrefix(), (Object)flowId);
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)(authenticationContext.isPassive() ? "NoPassive" : "RequestUnsupported"));
                return;
            }
        }
        authenticationContext.setAttemptedFlow(flow);
        ActionSupport.buildProceedEvent((ProfileRequestContext)profileRequestContext);
    }
}

