/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.principal.impl;

import com.google.common.base.Strings;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableBiMap;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.Principal;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonString;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.stream.JsonGenerator;
import net.shibboleth.idp.authn.principal.AbstractPrincipalSerializer;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.ThreadSafeAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafeAfterInit
public class GenericPrincipalSerializer
extends AbstractPrincipalSerializer<String> {
    @Nonnull
    @NotEmpty
    private static final String PRINCIPAL_TYPE_FIELD = "typ";
    @Nonnull
    @NotEmpty
    private static final String PRINCIPAL_NAME_FIELD = "nam";
    @Nonnull
    private static final Pattern JSON_PATTERN = Pattern.compile("^\\{\"typ\":.*,\"nam\":.*\\}$");
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(GenericPrincipalSerializer.class);
    @Nonnull
    @NonnullElements
    private BiMap<String, Integer> symbolics = ImmutableBiMap.of();
    @Nonnull
    @NonnullElements
    private final Set<Class<? extends Principal>> compatiblePrincipalTypes = Collections.synchronizedSet(new HashSet());

    public void setSymbolics(@Nonnull @NonnullElements Map<String, Integer> mappings) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.symbolics = HashBiMap.create((Map)((Map)Constraint.isNotNull(mappings, (String)"Mappings cannot be null")));
    }

    public boolean supports(@Nonnull Principal principal) {
        Class<?> principalType = principal.getClass();
        if (this.compatiblePrincipalTypes.contains(principalType)) {
            return true;
        }
        try {
            principalType.getConstructor(String.class);
            this.compatiblePrincipalTypes.add(principalType);
            return true;
        }
        catch (NoSuchMethodException | SecurityException e) {
            this.log.warn("Unsupported Principal type will be omitted: {}", (Object)principalType.getName());
            return false;
        }
    }

    @Nonnull
    @NotEmpty
    public String serialize(@Nonnull Principal principal) throws IOException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        StringWriter sink = new StringWriter(32);
        JsonGenerator gen = this.getJsonGenerator(sink);
        gen.writeStartObject();
        Integer symbol = (Integer)this.symbolics.get((Object)principal.getClass().getName());
        if (symbol != null) {
            gen.write(PRINCIPAL_TYPE_FIELD, symbol.intValue());
        } else {
            gen.write(PRINCIPAL_TYPE_FIELD, principal.getClass().getName());
        }
        symbol = (Integer)this.symbolics.get((Object)principal.getName());
        if (symbol != null) {
            gen.write(PRINCIPAL_NAME_FIELD, symbol.intValue());
        } else {
            gen.write(PRINCIPAL_NAME_FIELD, principal.getName());
        }
        gen.writeEnd();
        gen.close();
        return sink.toString();
    }

    public boolean supports(@Nonnull @NotEmpty String value) {
        return JSON_PATTERN.matcher(value).matches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Principal deserialize(@Nonnull @NotEmpty String value) throws IOException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        JsonStructure st = null;
        try (JsonReader reader = this.getJsonReader(new StringReader(value));){
            st = reader.read();
        }
        if (!(st instanceof JsonObject)) {
            throw new IOException("Found invalid data structure while parsing a generic principal");
        }
        JsonObject obj = (JsonObject)st;
        JsonValue typefield = (JsonValue)obj.get((Object)PRINCIPAL_TYPE_FIELD);
        JsonValue namefield = (JsonValue)obj.get((Object)PRINCIPAL_NAME_FIELD);
        if (typefield != null && namefield != null) {
            String type = this.desymbolize(typefield);
            String name = this.desymbolize(namefield);
            if (!Strings.isNullOrEmpty((String)type) && !Strings.isNullOrEmpty((String)name)) {
                try {
                    Class<Principal> pclass = Class.forName(type).asSubclass(Principal.class);
                    Constructor<Principal> ctor = pclass.getConstructor(String.class);
                    return ctor.newInstance(name);
                }
                catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    this.log.warn("Exception instantiating custom Principal type {} with name {}", new Object[]{type, name, e});
                }
            } else {
                this.log.warn("Unparseable Principal type or name in structure");
            }
        } else {
            this.log.warn("Missing Principal type or name in structure");
        }
        return null;
    }

    @Nullable
    protected String desymbolize(@Nonnull JsonValue field) {
        switch (field.getValueType()) {
            case STRING: {
                return ((JsonString)field).getString();
            }
            case NUMBER: {
                return (String)this.symbolics.inverse().get((Object)((JsonNumber)field).intValueExact());
            }
        }
        return null;
    }
}

