/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.principal.impl;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.security.Principal;
import java.util.Collection;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonBuilderFactory;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import javax.json.JsonString;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.stream.JsonGenerator;
import net.shibboleth.idp.authn.principal.AbstractPrincipalSerializer;
import net.shibboleth.idp.authn.principal.ProxyAuthenticationPrincipal;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class ProxyAuthenticationPrincipalSerializer
extends AbstractPrincipalSerializer<String> {
    @Nonnull
    @NotEmpty
    private static final String PROXY_AUTH_FIELD = "AA";
    private static final Pattern JSON_PATTERN = Pattern.compile("^\\{\"AA\":.*\\}$");
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ProxyAuthenticationPrincipalSerializer.class);
    @Nonnull
    private final JsonBuilderFactory objectBuilderFactory = Json.createBuilderFactory(null);

    public boolean supports(@Nonnull Principal principal) {
        return principal instanceof ProxyAuthenticationPrincipal;
    }

    @Nonnull
    @NotEmpty
    public String serialize(@Nonnull Principal principal) throws IOException {
        JsonArrayBuilder arrayBuilder = this.getJsonArrayBuilder();
        for (String aa : Collections2.filter((Collection)((ProxyAuthenticationPrincipal)principal).getAuthorities(), (Predicate)Predicates.notNull())) {
            arrayBuilder.add(aa);
        }
        StringWriter sink = new StringWriter(32);
        JsonGenerator gen = this.getJsonGenerator(sink);
        gen.writeStartObject().write(PROXY_AUTH_FIELD, (JsonValue)arrayBuilder.build()).writeEnd();
        gen.close();
        return sink.toString();
    }

    public boolean supports(@Nonnull @NotEmpty String value) {
        return JSON_PATTERN.matcher(value).matches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ProxyAuthenticationPrincipal deserialize(@Nonnull @NotEmpty String value) throws IOException {
        JsonStructure st = null;
        try (JsonReader reader = this.getJsonReader(new StringReader(value));){
            st = reader.read();
        }
        if (!(st instanceof JsonObject)) {
            throw new IOException("Found invalid data structure while parsing ProxyAuthenticationPrincipal");
        }
        JsonValue jsonValue = (JsonValue)((JsonObject)st).get((Object)PROXY_AUTH_FIELD);
        if (jsonValue != null && JsonValue.ValueType.ARRAY.equals((Object)jsonValue.getValueType())) {
            ProxyAuthenticationPrincipal ret = new ProxyAuthenticationPrincipal();
            for (JsonValue e : (JsonArray)jsonValue) {
                if (!JsonValue.ValueType.STRING.equals((Object)e.getValueType())) continue;
                ret.getAuthorities().add(((JsonString)e).getString());
            }
            return ret;
        }
        throw new IOException("Serialized ProxyAuthenticationPrincipal missing array field");
    }

    @Nonnull
    private synchronized JsonObjectBuilder getJsonObjectBuilder() {
        return this.objectBuilderFactory.createObjectBuilder();
    }

    @Nonnull
    private synchronized JsonArrayBuilder getJsonArrayBuilder() {
        return this.objectBuilderFactory.createArrayBuilder();
    }
}

