/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonReaderFactory;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonGeneratorFactory;
import javax.security.auth.Subject;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.idp.authn.principal.PrincipalSerializer;
import net.shibboleth.idp.authn.principal.impl.AuthenticationResultPrincipalSerializer;
import net.shibboleth.idp.authn.principal.impl.GenericPrincipalSerializer;
import net.shibboleth.idp.authn.principal.impl.UsernamePrincipalSerializer;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.AbstractInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import org.opensaml.storage.StorageSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAuthenticationResultSerializer
extends AbstractInitializableComponent
implements StorageSerializer<AuthenticationResult> {
    @Nonnull
    @NotEmpty
    private static final String FLOW_ID_FIELD = "id";
    @Nonnull
    @NotEmpty
    private static final String AUTHN_INSTANT_FIELD = "ts";
    @Nonnull
    @NotEmpty
    private static final String PRINCIPAL_ARRAY_FIELD = "princ";
    @Nonnull
    @NotEmpty
    private static final String PUB_CREDS_ARRAY_FIELD = "pub";
    @Nonnull
    @NotEmpty
    private static final String PRIV_CREDS_ARRAY_FIELD = "priv";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DefaultAuthenticationResultSerializer.class);
    @Nonnull
    private final JsonGeneratorFactory generatorFactory = Json.createGeneratorFactory(null);
    @Nonnull
    private final JsonReaderFactory readerFactory = Json.createReaderFactory(null);
    @Nonnull
    @NonnullElements
    private Collection<PrincipalSerializer<String>> principalSerializers = Collections.emptyList();
    @Nonnull
    private final AuthenticationResultPrincipalSerializer authnResultPrincipalSerializer = new AuthenticationResultPrincipalSerializer(this);
    @Nonnull
    private final GenericPrincipalSerializer genericSerializer = new GenericPrincipalSerializer();

    public void setPrincipalSerializers(@Nonnull @NonnullElements Collection<PrincipalSerializer<String>> serializers) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.principalSerializers = new ArrayList<PrincipalSerializer<String>>(Collections2.filter(serializers, (Predicate)Predicates.notNull()));
    }

    @Nonnull
    public GenericPrincipalSerializer getGenericPrincipalSerializer() {
        return this.genericSerializer;
    }

    public void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.genericSerializer.initialize();
        this.authnResultPrincipalSerializer.initialize();
        if (this.principalSerializers.isEmpty()) {
            UsernamePrincipalSerializer ups = new UsernamePrincipalSerializer();
            ups.initialize();
            this.principalSerializers = Arrays.asList(new PrincipalSerializer[]{ups, this.authnResultPrincipalSerializer});
        } else {
            this.principalSerializers.add((PrincipalSerializer<String>)this.authnResultPrincipalSerializer);
        }
    }

    @Nonnull
    @NotEmpty
    public String serialize(@Nonnull AuthenticationResult instance) throws IOException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        try {
            Set<Principal> privateCreds;
            StringWriter sink = new StringWriter(128);
            JsonGenerator gen = this.generatorFactory.createGenerator((Writer)sink);
            gen.writeStartObject().write(FLOW_ID_FIELD, instance.getAuthenticationFlowId()).write(AUTHN_INSTANT_FIELD, instance.getAuthenticationInstant()).writeStartArray(PRINCIPAL_ARRAY_FIELD);
            for (Principal p : instance.getSubject().getPrincipals()) {
                this.serializePrincipal(gen, p);
            }
            gen.writeEnd();
            Set<Principal> publicCreds = instance.getSubject().getPublicCredentials(Principal.class);
            if (publicCreds != null && !publicCreds.isEmpty()) {
                gen.writeStartArray(PUB_CREDS_ARRAY_FIELD);
                for (Principal p : publicCreds) {
                    this.serializePrincipal(gen, p);
                }
                gen.writeEnd();
            }
            if ((privateCreds = instance.getSubject().getPrivateCredentials(Principal.class)) != null && !privateCreds.isEmpty()) {
                gen.writeStartArray(PRIV_CREDS_ARRAY_FIELD);
                for (Principal p : privateCreds) {
                    this.serializePrincipal(gen, p);
                }
                gen.writeEnd();
            }
            gen.writeEnd().close();
            return sink.toString();
        }
        catch (JsonException e) {
            this.log.error("Exception while serializing AuthenticationResult", (Throwable)e);
            throw new IOException("Exception while serializing AuthenticationResult", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public AuthenticationResult deserialize(long version, @Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key, @Nonnull @NotEmpty String value, @Nullable Long expiration) throws IOException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        try {
            JsonArray privateCreds;
            JsonArray publicCreds;
            JsonStructure st = null;
            try (JsonReader reader = this.readerFactory.createReader((Reader)new StringReader(value));){
                st = reader.read();
            }
            if (!(st instanceof JsonObject)) {
                throw new IOException("Found invalid data structure while parsing AuthenticationResult");
            }
            JsonObject obj = (JsonObject)st;
            String flowId = obj.getString(FLOW_ID_FIELD);
            long authnInstant = obj.getJsonNumber(AUTHN_INSTANT_FIELD).longValueExact();
            AuthenticationResult result = new AuthenticationResult(flowId, new Subject());
            result.setAuthenticationInstant(authnInstant);
            result.setLastActivityInstant(expiration != null ? expiration : authnInstant);
            result.setPreviousResult(true);
            JsonArray principals = obj.getJsonArray(PRINCIPAL_ARRAY_FIELD);
            if (principals != null) {
                for (JsonValue val : principals) {
                    Principal principal = this.deserializePrincipal(val);
                    if (principal == null) continue;
                    result.getSubject().getPrincipals().add(principal);
                }
            }
            if ((publicCreds = obj.getJsonArray(PUB_CREDS_ARRAY_FIELD)) != null) {
                for (JsonValue val : publicCreds) {
                    Principal principal = this.deserializePrincipal(val);
                    if (principal == null) continue;
                    result.getSubject().getPublicCredentials().add(principal);
                }
            }
            if ((privateCreds = obj.getJsonArray(PRIV_CREDS_ARRAY_FIELD)) != null) {
                for (JsonValue val : privateCreds) {
                    Principal principal = this.deserializePrincipal(val);
                    if (principal == null) continue;
                    result.getSubject().getPrivateCredentials().add(principal);
                }
            }
            return result;
        }
        catch (ArithmeticException | ClassCastException | NullPointerException | JsonException e) {
            this.log.error("Exception while parsing AuthenticationResult", e);
            throw new IOException("Found invalid data structure while parsing AuthenticationResult", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serializePrincipal(@Nonnull JsonGenerator generator, @Nonnull Principal principal) throws IOException {
        boolean serialized = false;
        for (PrincipalSerializer<String> serializer : this.principalSerializers) {
            if (!serializer.supports(principal)) continue;
            try (JsonReader reader = this.readerFactory.createReader((Reader)new StringReader((String)serializer.serialize(principal)));){
                generator.write((JsonValue)reader.readObject());
            }
            serialized = true;
        }
        if (!serialized && this.genericSerializer.supports(principal)) {
            try (JsonReader reader = this.readerFactory.createReader((Reader)new StringReader(this.genericSerializer.serialize(principal)));){
                generator.write((JsonValue)reader.readObject());
            }
        }
    }

    @Nullable
    private Principal deserializePrincipal(@Nonnull JsonValue jsonValue) throws IOException {
        if (jsonValue instanceof JsonObject) {
            String json = ((JsonObject)jsonValue).toString();
            for (PrincipalSerializer<String> serializer : this.principalSerializers) {
                if (!serializer.supports((Object)json)) continue;
                return serializer.deserialize((Object)json);
            }
            if (this.genericSerializer.supports(json)) {
                return this.genericSerializer.deserialize(json);
            }
        }
        return null;
    }
}

