/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import com.google.common.base.Function;
import java.io.IOException;
import java.security.Principal;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.idp.authn.ExternalAuthentication;
import net.shibboleth.idp.authn.ExternalAuthenticationException;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.ExternalAuthenticationContext;
import net.shibboleth.idp.consent.context.ConsentManagementContext;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.joda.time.DateTime;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;

public class ExternalAuthenticationImpl
extends ExternalAuthentication {
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyContext> relyingPartyContextLookupStrategy;
    private final boolean extendedFlow;

    public ExternalAuthenticationImpl() {
        this(false);
    }

    public ExternalAuthenticationImpl(boolean extended) {
        this.extendedFlow = extended;
        this.relyingPartyContextLookupStrategy = new ChildContextLookup(RelyingPartyContext.class);
    }

    public void setRelyingPartyContextLookupStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyContext> strategy) {
        this.relyingPartyContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"RelyingPartyContext lookup strategy cannot be null");
    }

    protected void doStart(@Nonnull HttpServletRequest request, @Nonnull ProfileRequestContext profileRequestContext, @Nonnull ExternalAuthenticationContext externalAuthenticationContext) throws ExternalAuthenticationException {
        RelyingPartyContext rpCtx;
        super.doStart(request, profileRequestContext, externalAuthenticationContext);
        AuthenticationContext authnContext = (AuthenticationContext)profileRequestContext.getSubcontext(AuthenticationContext.class);
        if (authnContext == null) {
            throw new ExternalAuthenticationException("No AuthenticationContext found");
        }
        if (authnContext.getAttemptedFlow() == null) {
            throw new ExternalAuthenticationException("No attempted authentication flow set");
        }
        request.setAttribute("extended", (Object)this.extendedFlow);
        request.setAttribute("isPassive", (Object)authnContext.isPassive());
        request.setAttribute("forceAuthn", (Object)authnContext.isForceAuthn());
        Collection principals = authnContext.getAttemptedFlow().getSupportedPrincipals();
        if (!principals.isEmpty()) {
            request.setAttribute("authnMethod", (Object)((Principal)principals.iterator().next()).getName());
        }
        if ((rpCtx = (RelyingPartyContext)this.relyingPartyContextLookupStrategy.apply((Object)profileRequestContext)) != null) {
            request.setAttribute("relyingParty", (Object)rpCtx.getRelyingPartyId());
        }
    }

    protected void doFinish(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response, @Nonnull ProfileRequestContext profileRequestContext, @Nonnull ExternalAuthenticationContext extContext) throws ExternalAuthenticationException, IOException {
        if (extContext.getFlowExecutionUrl() == null) {
            throw new ExternalAuthenticationException("No flow execution URL found to return control");
        }
        Object attr = request.getAttribute("subject");
        if (attr != null && attr instanceof Subject) {
            extContext.setSubject((Subject)attr);
        } else {
            attr = request.getAttribute("principal");
            if (attr != null && attr instanceof Principal) {
                extContext.setPrincipal((Principal)attr);
            } else {
                attr = request.getAttribute("principal_name");
                if (attr != null && attr instanceof String) {
                    extContext.setPrincipalName((String)attr);
                }
            }
        }
        attr = request.getAttribute("authnInstant");
        if (attr != null && attr instanceof DateTime) {
            extContext.setAuthnInstant((DateTime)attr);
        }
        if ((attr = request.getAttribute("authnAuthorities")) != null && attr instanceof Collection) {
            extContext.getAuthenticatingAuthorities().addAll((Collection)attr);
        }
        if ((attr = request.getAttribute("authnError")) != null && attr instanceof String) {
            extContext.setAuthnError((String)attr);
        }
        if ((attr = request.getAttribute("authnException")) != null && attr instanceof Exception) {
            extContext.setAuthnException((Exception)attr);
        }
        if ((attr = request.getAttribute("doNotCache")) != null && attr instanceof Boolean) {
            extContext.setDoNotCache(((Boolean)attr).booleanValue());
        }
        if ((attr = request.getAttribute("previousResult")) != null && attr instanceof Boolean) {
            extContext.setPreviousResult(((Boolean)attr).booleanValue());
        }
        if ((attr = request.getAttribute("revokeConsent")) != null && attr instanceof Boolean && ((Boolean)attr).booleanValue()) {
            ConsentManagementContext consentCtx = (ConsentManagementContext)profileRequestContext.getSubcontext(ConsentManagementContext.class, true);
            consentCtx.setRevokeConsent(true);
        }
        response.sendRedirect(extContext.getFlowExecutionUrl());
    }
}

