/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.AbstractAuthenticationAction;
import net.shibboleth.idp.authn.AuthenticationFlowDescriptor;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.idp.authn.MultiFactorAuthenticationTransition;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.MultiFactorAuthenticationContext;
import net.shibboleth.idp.authn.principal.AuthenticationResultPrincipal;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.logic.FunctionSupport;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PopulateMultiFactorAuthenticationContext
extends AbstractAuthenticationAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(PopulateMultiFactorAuthenticationContext.class);
    @Nonnull
    private Function<ProfileRequestContext, Map<String, MultiFactorAuthenticationTransition>> transitionMapLookupStrategy = FunctionSupport.constant(null);
    @Nonnull
    private Function<ProfileRequestContext, MultiFactorAuthenticationContext> multiFactorContextCreationStrategy = Functions.compose((Function)new ChildContextLookup(MultiFactorAuthenticationContext.class, true), (Function)new ChildContextLookup(AuthenticationContext.class));
    @Nullable
    private Function<ProfileRequestContext, Collection<AuthenticationResult>> activeResultLookupStrategy = new DefaultResultLookupStrategy();

    PopulateMultiFactorAuthenticationContext() {
    }

    public void setTransitionMapLookupStrategy(@Nonnull Function<ProfileRequestContext, Map<String, MultiFactorAuthenticationTransition>> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.transitionMapLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Transition map lookup strategy cannot be null");
    }

    public void setMultiFactorContextCreationStrategy(@Nonnull Function<ProfileRequestContext, MultiFactorAuthenticationContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.multiFactorContextCreationStrategy = (Function)Constraint.isNotNull(strategy, (String)"MultiFactorAuthenticationContext creation strategy cannot be null");
    }

    public void setActiveResultLookupStrategy(@Nullable Function<ProfileRequestContext, Collection<AuthenticationResult>> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.activeResultLookupStrategy = strategy;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        Map transitionMap = (Map)this.transitionMapLookupStrategy.apply((Object)profileRequestContext);
        if (transitionMap == null) {
            this.log.info("No map of transition rules was returned");
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"ReselectFlow");
            return;
        }
        MultiFactorAuthenticationContext mfaCtx = (MultiFactorAuthenticationContext)this.multiFactorContextCreationStrategy.apply((Object)profileRequestContext);
        if (mfaCtx == null) {
            this.log.error("{} Unable to create/access MultiFactorAuthenticationContext", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return;
        }
        mfaCtx.setAuthenticationFlowDescriptor(authenticationContext.getAttemptedFlow());
        mfaCtx.setTransitionMap(transitionMap);
        mfaCtx.setNextFlowId(null);
        mfaCtx.getActiveResults().clear();
        if (this.activeResultLookupStrategy != null) {
            Collection results = (Collection)this.activeResultLookupStrategy.apply((Object)profileRequestContext);
            if (results != null) {
                for (AuthenticationResult result : results) {
                    mfaCtx.getActiveResults().put(result.getAuthenticationFlowId(), result);
                }
            }
            this.log.debug("{} {} active result(s) extracted for possible reuse", (Object)this.getLogPrefix(), (Object)(results != null ? results.size() : 0));
        } else {
            this.log.debug("{} No lookup strategy provided, no active results will be made available", (Object)this.getLogPrefix());
        }
    }

    private class DefaultResultLookupStrategy
    implements Function<ProfileRequestContext, Collection<AuthenticationResult>> {
        private DefaultResultLookupStrategy() {
        }

        @Nullable
        public Collection<AuthenticationResult> apply(@Nullable ProfileRequestContext input) {
            AuthenticationResult mfaResult;
            AuthenticationContext ac;
            if (input != null && (ac = (AuthenticationContext)input.getSubcontext(AuthenticationContext.class)) != null && ac.getAttemptedFlow() != null && (mfaResult = (AuthenticationResult)ac.getActiveResults().get(ac.getAttemptedFlow().getId())) != null) {
                if (ac.isForceAuthn()) {
                    PopulateMultiFactorAuthenticationContext.this.log.debug("{} Ignoring active result due to forced authentication requirement", (Object)PopulateMultiFactorAuthenticationContext.this.getLogPrefix());
                    return null;
                }
                Set<AuthenticationResultPrincipal> resultPrincipals = mfaResult.getSubject().getPrincipals(AuthenticationResultPrincipal.class);
                if (!resultPrincipals.isEmpty()) {
                    ArrayList<AuthenticationResult> results = new ArrayList<AuthenticationResult>(resultPrincipals.size());
                    for (AuthenticationResultPrincipal resultPrincipal : resultPrincipals) {
                        resultPrincipal.getAuthenticationResult().setLastActivityInstant(mfaResult.getLastActivityInstant());
                        this.processActiveResult(input, ac, results, resultPrincipal.getAuthenticationResult());
                    }
                    return results;
                }
            }
            return null;
        }

        void processActiveResult(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext, @Nonnull Collection<AuthenticationResult> results, @Nonnull AuthenticationResult candidate) {
            AuthenticationFlowDescriptor descriptor = (AuthenticationFlowDescriptor)authenticationContext.getAvailableFlows().get(candidate.getAuthenticationFlowId());
            if (descriptor != null) {
                if (descriptor.apply(profileRequestContext)) {
                    if (descriptor.isResultActive(candidate)) {
                        if (authenticationContext.getMaxAge() > 0L && candidate.getAuthenticationInstant() + authenticationContext.getMaxAge() < System.currentTimeMillis()) {
                            PopulateMultiFactorAuthenticationContext.this.log.debug("{} Ignoring active result from login flow {} due to maxAge on request", (Object)PopulateMultiFactorAuthenticationContext.this.getLogPrefix(), (Object)candidate.getAuthenticationFlowId());
                        } else {
                            results.add(candidate);
                        }
                    } else {
                        PopulateMultiFactorAuthenticationContext.this.log.debug("{} Result from login flow {} has expired", (Object)PopulateMultiFactorAuthenticationContext.this.getLogPrefix(), (Object)descriptor.getId());
                    }
                } else {
                    PopulateMultiFactorAuthenticationContext.this.log.debug("{} Ignoring active result from login flow {} due to activation condition", (Object)PopulateMultiFactorAuthenticationContext.this.getLogPrefix(), (Object)candidate.getAuthenticationFlowId());
                }
            } else {
                PopulateMultiFactorAuthenticationContext.this.log.warn("{} Ignoring active result from undefined login flow {}", (Object)PopulateMultiFactorAuthenticationContext.this.getLogPrefix(), (Object)candidate.getAuthenticationFlowId());
            }
        }
    }
}

