/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import net.shibboleth.idp.authn.AbstractSubjectCanonicalizationAction;
import net.shibboleth.idp.authn.SubjectCanonicalizationFlowDescriptor;
import net.shibboleth.idp.authn.context.SubjectCanonicalizationContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PopulateSubjectCanonicalizationContext
extends AbstractSubjectCanonicalizationAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(PopulateSubjectCanonicalizationContext.class);
    @Nonnull
    @NonnullElements
    private Collection<SubjectCanonicalizationFlowDescriptor> availableFlows = Collections.emptyList();

    PopulateSubjectCanonicalizationContext() {
    }

    public void setAvailableFlows(@Nonnull @NonnullElements Collection<SubjectCanonicalizationFlowDescriptor> flows) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        Constraint.isNotNull(flows, (String)"Flow collection cannot be null");
        this.availableFlows = new ArrayList<SubjectCanonicalizationFlowDescriptor>(Collections2.filter(flows, (Predicate)Predicates.notNull()));
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull SubjectCanonicalizationContext c14nContext) {
        this.log.debug("{} Installing {} canonicalization flows into SubjectCanonicalizationContext", (Object)this.getLogPrefix(), (Object)this.availableFlows.size());
        for (SubjectCanonicalizationFlowDescriptor desc : this.availableFlows) {
            c14nContext.getPotentialFlows().put(desc.getId(), desc);
        }
    }
}

