/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.Subject;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.idp.authn.AuthenticationFlowDescriptor;
import net.shibboleth.idp.authn.ExternalAuthentication;
import net.shibboleth.idp.authn.ExternalAuthenticationException;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.principal.UsernamePrincipal;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteUserAuthServlet
extends HttpServlet {
    private static final long serialVersionUID = -3162057736238514851L;
    @Nonnull
    @NotEmpty
    private static final String CHECK_REMOTE_USER_PARAM = "checkRemoteUser";
    @Nonnull
    @NotEmpty
    private static final String CHECK_ATTRIBUTES_PARAM = "checkAttributes";
    @Nonnull
    @NotEmpty
    private static final String CHECK_HEADERS_PARAM = "checkHeaders";
    @Nonnull
    @NotEmpty
    private static final String SUBJECT_ATTRIBUTE_PARAM = "subjectAttribute";
    @Nonnull
    @NotEmpty
    private static final String AUTHN_METHOD_HEADER_PARAM = "authnMethodHeader";
    @Nonnull
    @NotEmpty
    private static final String AUTHN_AUTHORITY_HEADER_PARAM = "authnAuthorityHeader";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(RemoteUserAuthServlet.class);
    private boolean checkRemoteUser = true;
    @Nonnull
    @NonnullElements
    private Collection<String> checkAttributes = Collections.emptyList();
    @Nonnull
    @NonnullElements
    private Collection<String> checkHeaders = Collections.emptyList();
    @Nullable
    @NotEmpty
    private String subjectAttribute;
    @Nullable
    @NotEmpty
    private String authnMethodHeader;
    @Nullable
    @NotEmpty
    private String authnAuthorityHeader;

    public void setCheckRemoteUser(boolean flag) {
        this.checkRemoteUser = flag;
    }

    public void setCheckAttributes(@Nonnull @NonnullElements Collection<String> attributes) {
        this.checkAttributes = new ArrayList<String>(Collections2.filter(attributes, (Predicate)Predicates.notNull()));
    }

    public void setCheckHeaders(@Nonnull @NonnullElements Collection<String> headers) {
        this.checkHeaders = new ArrayList<String>(Collections2.filter(headers, (Predicate)Predicates.notNull()));
    }

    public void setSubjectAttribute(@Nullable @NotEmpty String attribute) {
        this.subjectAttribute = StringSupport.trimOrNull((String)attribute);
    }

    public void setAuthnMethodHeader(@Nullable @NotEmpty String header) {
        this.authnMethodHeader = StringSupport.trimOrNull((String)header);
    }

    public void setAuthnAuthorityHeader(@Nullable @NotEmpty String header) {
        this.authnAuthorityHeader = StringSupport.trimOrNull((String)header);
    }

    public void init(ServletConfig config) throws ServletException {
        String[] headers;
        String[] attrs;
        super.init(config);
        String param = config.getInitParameter(CHECK_REMOTE_USER_PARAM);
        if (param != null) {
            this.checkRemoteUser = Boolean.parseBoolean(param);
        }
        if ((param = config.getInitParameter(CHECK_ATTRIBUTES_PARAM)) != null && (attrs = param.split(" ")) != null) {
            this.checkAttributes = StringSupport.normalizeStringCollection(Arrays.asList(attrs));
        }
        if ((param = config.getInitParameter(CHECK_HEADERS_PARAM)) != null && (headers = param.split(" ")) != null) {
            this.checkHeaders = StringSupport.normalizeStringCollection(Arrays.asList(headers));
        }
        if ((param = config.getInitParameter(SUBJECT_ATTRIBUTE_PARAM)) != null) {
            this.setSubjectAttribute(param);
        }
        if ((param = config.getInitParameter(AUTHN_METHOD_HEADER_PARAM)) != null) {
            this.setAuthnMethodHeader(param);
        }
        if ((param = config.getInitParameter(AUTHN_AUTHORITY_HEADER_PARAM)) != null) {
            this.setAuthnAuthorityHeader(param);
        }
        this.log.info("RemoteUserAuthServlet {} process REMOTE_USER, along with attributes {} and headers {}", new Object[]{this.checkRemoteUser ? "will" : "will not", this.checkAttributes, this.checkHeaders});
        if (this.subjectAttribute != null) {
            this.log.info("RemoteUserAuthServlet will check for a javax.security.auth.Subject in attribute: {}", (Object)this.subjectAttribute);
        }
        if (this.authnMethodHeader != null) {
            this.log.info("RemoteUserAuthServlet will check for authentication methods in header: {}", (Object)this.authnMethodHeader);
        }
        if (this.authnAuthorityHeader != null) {
            this.log.info("RemoteUserAuthServlet will check for authenticating authorities in header: {}", (Object)this.authnAuthorityHeader);
        }
    }

    protected void service(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws ServletException, IOException {
        try {
            Enumeration authorities;
            String key = ExternalAuthentication.startExternalAuthentication((HttpServletRequest)httpRequest);
            if (this.subjectAttribute != null) {
                Object subject = httpRequest.getAttribute(this.subjectAttribute);
                if (subject != null && subject instanceof Subject) {
                    this.log.debug("Java Subject extracted from attribute {}: {}", (Object)this.subjectAttribute, subject);
                    httpRequest.setAttribute("subject", subject);
                    ExternalAuthentication.finishExternalAuthentication((String)key, (HttpServletRequest)httpRequest, (HttpServletResponse)httpResponse);
                    return;
                }
                this.log.info("Java Subject not found in attribute {}", (Object)this.subjectAttribute);
            }
            String username = null;
            if (this.checkRemoteUser && (username = httpRequest.getRemoteUser()) != null && !username.isEmpty()) {
                this.log.debug("User identity extracted from REMOTE_USER: {}", (Object)username);
            }
            if (username == null) {
                for (String s : this.checkAttributes) {
                    Object attr = httpRequest.getAttribute(s);
                    if (attr == null || attr.toString().isEmpty()) continue;
                    username = attr.toString();
                    this.log.debug("User identity extracted from attribute {}: {}", (Object)s, (Object)username);
                    break;
                }
            }
            if (username == null) {
                for (String s : this.checkHeaders) {
                    username = httpRequest.getHeader(s);
                    if (username == null || username.isEmpty()) continue;
                    this.log.debug("User identity extracted from header {}: {}", (Object)s, (Object)username);
                    break;
                }
            }
            if (username == null) {
                this.log.info("User identity not found in request");
                ExternalAuthentication.finishExternalAuthentication((String)key, (HttpServletRequest)httpRequest, (HttpServletResponse)httpResponse);
                return;
            }
            if (this.authnAuthorityHeader != null && (authorities = httpRequest.getHeaders(this.authnAuthorityHeader)) != null && authorities.hasMoreElements()) {
                ArrayList<String> copied = new ArrayList<String>();
                while (authorities.hasMoreElements()) {
                    String authority = (String)authorities.nextElement();
                    if (Strings.isNullOrEmpty((String)authority)) continue;
                    copied.add(authority);
                }
                if (!copied.isEmpty()) {
                    httpRequest.setAttribute("authnAuthorities", copied);
                }
            }
            if (this.authnMethodHeader != null) {
                Enumeration methods = httpRequest.getHeaders(this.authnMethodHeader);
                if (methods != null && methods.hasMoreElements()) {
                    AuthenticationFlowDescriptor authnFlow = this.getAuthenticationFlowDescriptor(key, httpRequest);
                    if (authnFlow != null) {
                        Subject subject = new Subject();
                        subject.getPrincipals().add((Principal)new UsernamePrincipal(username));
                        while (methods.hasMoreElements()) {
                            String method = (String)methods.nextElement();
                            if (Strings.isNullOrEmpty((String)method)) continue;
                            Principal p = this.getPrincipal(authnFlow, method);
                            if (p != null) {
                                this.log.debug("Successfully processed authentication method from header {}: {}", (Object)this.authnMethodHeader, (Object)method);
                                subject.getPrincipals().add(p);
                                continue;
                            }
                            this.log.warn("Unable to locate a suitable Principal for authentication method from header {}: {}", (Object)this.authnMethodHeader, (Object)method);
                        }
                        httpRequest.setAttribute("subject", (Object)subject);
                        ExternalAuthentication.finishExternalAuthentication((String)key, (HttpServletRequest)httpRequest, (HttpServletResponse)httpResponse);
                        return;
                    }
                    this.log.error("Unable to locate AuthenticationFlowDescriptor, can't process authentication methods from header");
                }
                httpRequest.setAttribute("principal_name", (Object)username);
            } else {
                httpRequest.setAttribute("principal_name", (Object)username);
            }
            ExternalAuthentication.finishExternalAuthentication((String)key, (HttpServletRequest)httpRequest, (HttpServletResponse)httpResponse);
        }
        catch (ExternalAuthenticationException e) {
            throw new ServletException("Error in RemoteUserAuthServlet processing external authentication request", (Throwable)e);
        }
    }

    @Nullable
    public AuthenticationFlowDescriptor getAuthenticationFlowDescriptor(@Nonnull @NotEmpty String key, @Nonnull HttpServletRequest httpRequest) throws ExternalAuthenticationException {
        ProfileRequestContext prc = ExternalAuthentication.getProfileRequestContext((String)key, (HttpServletRequest)httpRequest);
        AuthenticationContext authnCtx = (AuthenticationContext)prc.getSubcontext(AuthenticationContext.class);
        return authnCtx != null ? authnCtx.getAttemptedFlow() : null;
    }

    @Nullable
    public Principal getPrincipal(@Nonnull AuthenticationFlowDescriptor descriptor, @Nonnull @NotEmpty String method) {
        for (Principal p : descriptor.getSupportedPrincipals()) {
            if (!p.getName().equals(method)) continue;
            return p;
        }
        return null;
    }
}

