/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import com.google.common.base.Function;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import net.shibboleth.idp.authn.AbstractUsernamePasswordValidationAction;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.RequestedPrincipalContext;
import net.shibboleth.idp.authn.principal.PrincipalEvalPredicate;
import net.shibboleth.idp.authn.principal.PrincipalEvalPredicateFactory;
import net.shibboleth.idp.authn.principal.PrincipalSupportingComponent;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.collection.Pair;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidateUsernamePasswordAgainstJAAS
extends AbstractUsernamePasswordValidationAction {
    @Nonnull
    @NotEmpty
    private static final String DEFAULT_METRIC_NAME = "net.shibboleth.idp.authn";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ValidateUsernamePasswordAgainstJAAS.class);
    @Nullable
    private String loginConfigType;
    @Nullable
    private Configuration.Parameters loginConfigParameters;
    @Nonnull
    private Collection<Pair<String, Subject>> loginConfigurations = Collections.singletonList(new Pair((Object)"ShibUserPassAuth", null));
    @Nullable
    private Function<ProfileRequestContext, Collection<Pair<String, Subject>>> loginConfigStrategy;
    @Nullable
    private RequestedPrincipalContext requestedPrincipalCtx;
    @Nullable
    private Subject derivedSubject;
    @Nullable
    private String currentLoginConfigName;

    @Nullable
    public String getLoginConfigType() {
        return this.loginConfigType;
    }

    public void setLoginConfigType(@Nullable String type) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.loginConfigType = StringSupport.trimOrNull((String)type);
    }

    @Nullable
    public Configuration.Parameters getLoginConfigParameters() {
        return this.loginConfigParameters;
    }

    public void setLoginConfigParameters(@Nullable Configuration.Parameters params) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.loginConfigParameters = params;
    }

    public void setLoginConfigurations(@Nullable Collection<Pair<String, Collection<Principal>>> configs) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        if (configs != null) {
            this.loginConfigurations = new ArrayList<Pair<String, Subject>>(configs.size());
            for (Pair<String, Collection<Principal>> config : configs) {
                String trimmed = StringSupport.trimOrNull((String)((String)config.getFirst()));
                if (trimmed == null) continue;
                if (config.getSecond() == null || ((Collection)config.getSecond()).isEmpty()) {
                    this.loginConfigurations.add((Pair<String, Subject>)new Pair((Object)trimmed, null));
                    continue;
                }
                Subject subject = new Subject();
                subject.getPrincipals().addAll((Collection)config.getSecond());
                this.loginConfigurations.add((Pair<String, Subject>)new Pair((Object)trimmed, (Object)subject));
            }
        }
    }

    public void setLoginConfigNames(@Nullable @NonnullElements Collection<String> names) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        if (names != null) {
            this.loginConfigurations = new ArrayList<Pair<String, Subject>>(names.size());
            for (String name : names) {
                String trimmed = StringSupport.trimOrNull((String)name);
                if (trimmed == null) continue;
                this.loginConfigurations.add((Pair<String, Subject>)new Pair((Object)trimmed, null));
            }
        }
    }

    public void setLoginConfigStrategy(@Nullable Function<ProfileRequestContext, Collection<Pair<String, Subject>>> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.loginConfigStrategy = strategy;
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        if (!super.doPreExecute(profileRequestContext, authenticationContext)) {
            return false;
        }
        this.requestedPrincipalCtx = (RequestedPrincipalContext)authenticationContext.getSubcontext(RequestedPrincipalContext.class);
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        Collection configs = this.loginConfigStrategy != null ? (Collection)this.loginConfigStrategy.apply((Object)profileRequestContext) : this.loginConfigurations;
        boolean eventSignaled = false;
        for (Pair loginConfig : configs) {
            if (!this.isAcceptable(authenticationContext, (String)loginConfig.getFirst(), (Subject)loginConfig.getSecond())) continue;
            try {
                this.currentLoginConfigName = (String)loginConfig.getFirst();
                this.log.debug("{} Attempting to authenticate user '{}' via '{}'", new Object[]{this.getLogPrefix(), this.getUsernamePasswordContext().getUsername(), this.currentLoginConfigName});
                this.authenticate(this.currentLoginConfigName);
                this.log.info("{} Login by '{}' via '{}' succeeded", new Object[]{this.getLogPrefix(), this.getUsernamePasswordContext().getUsername(), this.currentLoginConfigName});
                this.recordSuccess(profileRequestContext);
                this.derivedSubject = (Subject)loginConfig.getSecond();
                this.buildAuthenticationResult(profileRequestContext, authenticationContext);
                ActionSupport.buildProceedEvent((ProfileRequestContext)profileRequestContext);
                return;
            }
            catch (LoginException e) {
                this.log.info("{} Login by '{}' via '{}' failed", new Object[]{this.getLogPrefix(), this.getUsernamePasswordContext().getUsername(), this.currentLoginConfigName, e});
                this.handleError(profileRequestContext, authenticationContext, e, "InvalidCredentials");
                this.recordFailure(profileRequestContext, true);
                eventSignaled = true;
            }
            catch (Exception e) {
                this.log.warn("{} Login by '{}' via '{}' produced exception", new Object[]{this.getLogPrefix(), this.getUsernamePasswordContext().getUsername(), this.currentLoginConfigName, e});
                this.handleError(profileRequestContext, authenticationContext, e, "AuthenticationException");
                this.recordFailure(profileRequestContext, false);
                eventSignaled = true;
            }
        }
        if (!eventSignaled) {
            this.log.warn("{} No JAAS application configurations are available or acceptable for use", (Object)this.getLogPrefix());
            this.handleError(profileRequestContext, authenticationContext, "RequestUnsupported", "RequestUnsupported");
        }
    }

    private boolean isAcceptable(@Nonnull AuthenticationContext authenticationContext, @Nonnull @NotEmpty String configName, final @Nullable Subject subject) {
        if (subject != null && this.requestedPrincipalCtx != null && this.requestedPrincipalCtx.getOperator() != null) {
            this.log.debug("{} Request contains principal requirements, evaluating JAAS config '{}' for compatibility", (Object)this.getLogPrefix(), (Object)configName);
            for (Principal p : this.requestedPrincipalCtx.getRequestedPrincipals()) {
                PrincipalEvalPredicateFactory factory = this.requestedPrincipalCtx.getPrincipalEvalPredicateFactoryRegistry().lookup(p.getClass(), this.requestedPrincipalCtx.getOperator());
                if (factory != null) {
                    PrincipalSupportingComponent wrapper;
                    PrincipalEvalPredicate predicate = factory.getPredicate(p);
                    if (predicate.apply((Object)(wrapper = new PrincipalSupportingComponent(){

                        public <T extends Principal> Set<T> getSupportedPrincipals(Class<T> c) {
                            return subject.getPrincipals(c);
                        }
                    }))) {
                        this.log.debug("{} JAAS config '{}' compatible with principal type '{}' and operator '{}'", new Object[]{this.getLogPrefix(), configName, p.getClass(), this.requestedPrincipalCtx.getOperator()});
                        this.requestedPrincipalCtx.setMatchingPrincipal(predicate.getMatchingPrincipal());
                        return true;
                    }
                    this.log.debug("{} JAAS config '{}' not compatible with principal type '{}' and operator '{}'", new Object[]{this.getLogPrefix(), configName, p.getClass(), this.requestedPrincipalCtx.getOperator()});
                    continue;
                }
                this.log.debug("{} No comparison logic registered for principal type '{}' and operator '{}'", new Object[]{this.getLogPrefix(), p.getClass(), this.requestedPrincipalCtx.getOperator()});
            }
            this.log.debug("{} Skipping JAAS config '{}', not compatible with request's principal requirements", (Object)this.getLogPrefix(), (Object)configName);
            return false;
        }
        return true;
    }

    private void authenticate(@Nonnull @NotEmpty String loginConfigName) throws LoginException, NoSuchAlgorithmException {
        LoginContext jaasLoginCtx;
        if (this.getLoginConfigType() != null) {
            this.log.debug("{} Using custom JAAS configuration type {} with parameters of type {}", new Object[]{this.getLogPrefix(), this.getLoginConfigType(), this.getLoginConfigParameters().getClass().getName()});
            Configuration loginConfig = Configuration.getInstance(this.getLoginConfigType(), this.getLoginConfigParameters());
            jaasLoginCtx = new LoginContext(loginConfigName, this.getSubject(), new SimpleCallbackHandler(), loginConfig);
        } else {
            this.log.debug("{} Using system JAAS configuration", (Object)this.getLogPrefix());
            jaasLoginCtx = new LoginContext(loginConfigName, this.getSubject(), new SimpleCallbackHandler());
        }
        jaasLoginCtx.login();
    }

    @Nonnull
    protected Subject populateSubject(@Nonnull Subject subject) {
        Subject theSubject = super.populateSubject(subject);
        if (this.derivedSubject != null) {
            theSubject.getPrincipals().addAll(this.derivedSubject.getPrincipals());
        }
        return theSubject;
    }

    @Nonnull
    @NotEmpty
    public String getMetricName() {
        return super.getMetricName() + '.' + this.currentLoginConfigName;
    }

    protected class SimpleCallbackHandler
    implements CallbackHandler {
        protected SimpleCallbackHandler() {
        }

        @Override
        public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
            if (callbacks == null || callbacks.length == 0) {
                return;
            }
            for (Callback cb : callbacks) {
                if (cb instanceof NameCallback) {
                    NameCallback ncb = (NameCallback)cb;
                    ncb.setName(ValidateUsernamePasswordAgainstJAAS.this.getUsernamePasswordContext().getUsername());
                    continue;
                }
                if (!(cb instanceof PasswordCallback)) continue;
                PasswordCallback pcb = (PasswordCallback)cb;
                pcb.setPassword(ValidateUsernamePasswordAgainstJAAS.this.getUsernamePasswordContext().getPassword().toCharArray());
            }
        }
    }
}

