/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.security.x509.X509Support;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class X509ProxyFilter
implements Filter {
    @Nonnull
    @NotEmpty
    public static final String LEAF_HEADER_PARAM = "leafHeader";
    @Nonnull
    @NotEmpty
    public static final String CHAIN_HEADERS_PARAM = "chainHeaders";
    @Nonnull
    @NotEmpty
    private static final String APACHE_NULL = "(null)";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(X509ProxyFilter.class);
    @Nullable
    @NotEmpty
    private String leafHeader;
    @Nonnull
    @NonnullElements
    private Collection<String> chainHeaders = Collections.emptyList();

    public void init(FilterConfig config) throws ServletException {
        String[] headers;
        this.leafHeader = config.getInitParameter(LEAF_HEADER_PARAM);
        if (this.leafHeader == null) {
            throw new ServletException("Required init-parameter leafHeader missing");
        }
        this.log.info("X509ProxyFilter will check for the end-entity certificate in: {}", (Object)this.leafHeader);
        String param = config.getInitParameter(CHAIN_HEADERS_PARAM);
        if (param != null && (headers = param.split(" ")) != null) {
            this.chainHeaders = StringSupport.normalizeStringCollection(Arrays.asList(headers));
        }
        this.log.info("X509ProxyFilter will check for chain certificates in: {}", this.chainHeaders);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        try {
            X509Certificate[] certs = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
            if (null == certs || 0 == certs.length) {
                ArrayList<X509Certificate> proxyCerts = new ArrayList<X509Certificate>();
                if (this.leafHeader != null) {
                    String pem = httpRequest.getHeader(this.leafHeader);
                    if (pem == null || pem.isEmpty() || APACHE_NULL.equals(pem)) {
                        this.log.warn("No end-entity certificate found");
                        return;
                    }
                    proxyCerts.add(X509Support.decodeCertificate((byte[])pem.getBytes()));
                } else {
                    this.log.warn("No end-entity certificate found");
                    return;
                }
                for (String s : this.chainHeaders) {
                    String pem = httpRequest.getHeader(s);
                    if (pem == null || pem.isEmpty() || APACHE_NULL.equals(pem)) continue;
                    proxyCerts.add(X509Support.decodeCertificate((byte[])pem.getBytes()));
                }
                if (!proxyCerts.isEmpty()) {
                    request.setAttribute("javax.servlet.request.X509Certificate", (Object)proxyCerts.toArray(new X509Certificate[proxyCerts.size()]));
                }
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage());
        }
        finally {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }
}

