/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.principal.impl;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.security.Principal;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.principal.PrincipalEvalPredicate;
import net.shibboleth.idp.authn.principal.PrincipalEvalPredicateFactory;
import net.shibboleth.idp.authn.principal.PrincipalSupportingComponent;
import net.shibboleth.utilities.java.support.annotation.constraint.Live;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.logic.Constraint;

public class InexactPrincipalEvalPredicateFactory
implements PrincipalEvalPredicateFactory {
    @Nonnull
    @NonnullElements
    private final HashMultimap<String, String> matchingRules = HashMultimap.create();

    InexactPrincipalEvalPredicateFactory() {
    }

    @Nonnull
    @NonnullElements
    @Live
    Multimap<String, String> getMatchingRules() {
        return this.matchingRules;
    }

    public void setMatchingRules(@Nonnull @NonnullElements Map<String, Collection<String>> rules) {
        Constraint.isNotNull(rules, (String)"Map cannot be null");
        this.matchingRules.clear();
        for (Map.Entry<String, Collection<String>> e : rules.entrySet()) {
            if (Strings.isNullOrEmpty((String)e.getKey()) || e.getValue() == null) continue;
            this.matchingRules.putAll((Object)e.getKey(), (Iterable)Collections2.filter(e.getValue(), (Predicate)Predicates.notNull()));
        }
    }

    @Nonnull
    public PrincipalEvalPredicate getPredicate(@Nonnull Principal candidate) {
        return new InexactMatchPredicate(candidate);
    }

    private class InexactMatchPredicate
    implements PrincipalEvalPredicate {
        @Nonnull
        private final Principal principal;
        @Nullable
        private Principal theMatch;

        public InexactMatchPredicate(Principal candidate) {
            this.principal = (Principal)Constraint.isNotNull((Object)candidate, (String)"Principal cannot be null");
        }

        public boolean apply(PrincipalSupportingComponent input) {
            Set matches = InexactPrincipalEvalPredicateFactory.this.matchingRules.get((Object)this.principal.getName());
            Set inputs = input.getSupportedPrincipals(this.principal.getClass());
            for (Principal p : inputs) {
                if (!matches.contains(p.getName())) continue;
                this.theMatch = p;
                return true;
            }
            return false;
        }

        @Nullable
        public Principal getMatchingPrincipal() {
            return this.theMatch;
        }
    }
}

