/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.principal.impl;

import com.google.common.base.Strings;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.security.Principal;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonString;
import javax.json.JsonStructure;
import javax.json.stream.JsonGenerator;
import net.shibboleth.idp.authn.principal.AbstractPrincipalSerializer;
import net.shibboleth.idp.authn.principal.UsernamePrincipal;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class UsernamePrincipalSerializer
extends AbstractPrincipalSerializer<String> {
    @Nonnull
    @NotEmpty
    private static final String USERNAME_FIELD = "U";
    @Nonnull
    private static final Pattern JSON_PATTERN = Pattern.compile("^\\{\"U\":.*\\}$");
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(UsernamePrincipalSerializer.class);

    public boolean supports(@Nonnull Principal principal) {
        return principal instanceof UsernamePrincipal;
    }

    @Nonnull
    @NotEmpty
    public String serialize(@Nonnull Principal principal) throws IOException {
        StringWriter sink = new StringWriter(32);
        JsonGenerator gen = this.getJsonGenerator(sink);
        gen.writeStartObject().write(USERNAME_FIELD, principal.getName()).writeEnd();
        gen.close();
        return sink.toString();
    }

    public boolean supports(@Nonnull @NotEmpty String value) {
        return JSON_PATTERN.matcher(value).matches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public UsernamePrincipal deserialize(@Nonnull @NotEmpty String value) throws IOException {
        String username;
        JsonStructure st = null;
        try (JsonReader reader = this.getJsonReader(new StringReader(value));){
            st = reader.read();
        }
        if (!(st instanceof JsonObject)) {
            throw new IOException("Found invalid data structure while parsing UsernamePrincipal");
        }
        JsonString str = ((JsonObject)st).getJsonString(USERNAME_FIELD);
        if (str != null && !Strings.isNullOrEmpty((String)(username = str.getString()))) {
            return new UsernamePrincipal(username);
        }
        return null;
    }
}

