/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.spnego.impl;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import net.shibboleth.idp.authn.spnego.impl.KerberosRealmSettings;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GSSAcceptorLoginModule {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(GSSAcceptorLoginModule.class);
    @Nullable
    private LoginModule krbModule;
    @Nonnull
    private Map<String, String> state = new HashMap<String, String>();
    @Nonnull
    private Map<String, String> options = new HashMap<String, String>();
    @Nonnull
    private KerberosRealmSettings realm;

    public GSSAcceptorLoginModule(@Nonnull KerberosRealmSettings realmSettings, boolean refreshKrb5Config, @Nonnull @NotEmpty String loginModuleClassName) {
        this.realm = (KerberosRealmSettings)((Object)Constraint.isNotNull((Object)((Object)realmSettings), (String)"KerberosRealmSettings cannot be null"));
        this.options.put("refreshKrb5Config", Boolean.valueOf(refreshKrb5Config).toString());
        this.options.put("useKeyTab", "true");
        this.options.put("keyTab", realmSettings.getKeytab());
        this.options.put("principal", realmSettings.getServicePrincipal());
        this.options.put("isInitiator", realmSettings.getPassword() != null ? "true" : "false");
        this.options.put("storeKey", "true");
        try {
            this.krbModule = (LoginModule)Class.forName(loginModuleClassName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            this.log.error("Unable to instantiate JAAS module for Kerberos", (Throwable)e);
            this.krbModule = null;
        }
    }

    public Subject login() throws LoginException {
        if (this.krbModule == null) {
            throw new LoginException("No JAAS module for Kerberos available");
        }
        UsernamePasswordCallbackHandler callbackH = new UsernamePasswordCallbackHandler(this.realm.getServicePrincipal(), this.realm.getPassword());
        Subject subject = new Subject();
        this.krbModule.initialize(subject, callbackH, this.state, this.options);
        if (this.krbModule.login()) {
            this.krbModule.commit();
        }
        return subject;
    }

    public void logout() throws LoginException {
        if (this.krbModule != null) {
            this.krbModule.logout();
        }
    }

    private class UsernamePasswordCallbackHandler
    implements CallbackHandler {
        @Nullable
        private String name;
        @Nullable
        private String password;

        public UsernamePasswordCallbackHandler(@Nullable String theName, String thePassword) {
            this.name = theName;
            this.password = thePassword;
        }

        @Override
        public void handle(@Nullable Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            if (callbacks != null && callbacks.length > 0) {
                if (this.name == null || this.name.length() == 0) {
                    throw new IllegalArgumentException("No username provided");
                }
                if (this.password == null || this.password.length() == 0) {
                    throw new IllegalArgumentException("No password provided");
                }
                for (Callback c : callbacks) {
                    if (c instanceof NameCallback) {
                        ((NameCallback)c).setName(this.name);
                        continue;
                    }
                    if (c instanceof PasswordCallback) {
                        ((PasswordCallback)c).setPassword(this.password.toCharArray());
                        continue;
                    }
                    throw new UnsupportedCallbackException(c);
                }
            }
        }
    }
}

