/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.security.Principal;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonReaderFactory;
import javax.json.JsonString;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonGeneratorFactory;
import javax.security.auth.Subject;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.idp.authn.principal.PrincipalSerializer;
import net.shibboleth.idp.authn.principal.impl.AuthenticationResultPrincipalSerializer;
import net.shibboleth.idp.authn.principal.impl.GenericPrincipalSerializer;
import net.shibboleth.idp.authn.principal.impl.UsernamePrincipalSerializer;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.AbstractInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.storage.StorageSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAuthenticationResultSerializer
extends AbstractInitializableComponent
implements StorageSerializer<AuthenticationResult> {
    @Nonnull
    @NotEmpty
    private static final String FLOW_ID_FIELD = "id";
    @Nonnull
    @NotEmpty
    private static final String AUTHN_INSTANT_FIELD = "ts";
    @Nonnull
    @NotEmpty
    private static final String PRINCIPAL_ARRAY_FIELD = "princ";
    @Nonnull
    @NotEmpty
    private static final String PUB_CREDS_ARRAY_FIELD = "pub";
    @Nonnull
    @NotEmpty
    private static final String PRIV_CREDS_ARRAY_FIELD = "priv";
    @Nonnull
    @NotEmpty
    private static final String ADDTL_DATA_FIELD = "props";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DefaultAuthenticationResultSerializer.class);
    @Nonnull
    private final JsonGeneratorFactory generatorFactory = Json.createGeneratorFactory(null);
    @Nonnull
    private final JsonReaderFactory readerFactory = Json.createReaderFactory(null);
    @Nonnull
    @NonnullElements
    private Collection<PrincipalSerializer<String>> principalSerializers = Collections.emptyList();
    @Nonnull
    private final AuthenticationResultPrincipalSerializer authnResultPrincipalSerializer = new AuthenticationResultPrincipalSerializer(this);
    @Nonnull
    private final GenericPrincipalSerializer genericSerializer = new GenericPrincipalSerializer();

    public void setPrincipalSerializers(@Nonnull @NonnullElements Collection<PrincipalSerializer<String>> serializers) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.principalSerializers = List.copyOf((Collection)Constraint.isNotNull(serializers, (String)"Serializers cannot be null"));
    }

    @Nonnull
    public GenericPrincipalSerializer getGenericPrincipalSerializer() {
        return this.genericSerializer;
    }

    public void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.genericSerializer.initialize();
        this.authnResultPrincipalSerializer.initialize();
        if (this.principalSerializers.isEmpty()) {
            UsernamePrincipalSerializer ups = new UsernamePrincipalSerializer();
            ups.initialize();
            this.principalSerializers = List.of(ups, this.authnResultPrincipalSerializer);
        } else {
            ArrayList<PrincipalSerializer<String>> copy = new ArrayList<PrincipalSerializer<String>>(this.principalSerializers);
            copy.add((PrincipalSerializer<String>)this.authnResultPrincipalSerializer);
            this.principalSerializers = List.copyOf(copy);
        }
    }

    @Nonnull
    @NotEmpty
    public String serialize(@Nonnull AuthenticationResult instance) throws IOException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        try {
            Set<Principal> set;
            StringWriter sink = new StringWriter(128);
            JsonGenerator gen = this.generatorFactory.createGenerator((Writer)sink);
            gen.writeStartObject().write(FLOW_ID_FIELD, instance.getAuthenticationFlowId()).write(AUTHN_INSTANT_FIELD, instance.getAuthenticationInstant().toEpochMilli());
            Map addtlData = instance.getAdditionalData();
            if (!addtlData.isEmpty()) {
                gen.writeStartObject(ADDTL_DATA_FIELD);
                addtlData.forEach((k, v) -> gen.write(k, v));
                gen.writeEnd();
            }
            gen.writeStartArray(PRINCIPAL_ARRAY_FIELD);
            for (Principal principal : instance.getSubject().getPrincipals()) {
                this.serializePrincipal(gen, principal);
            }
            gen.writeEnd();
            Set<Principal> publicCreds = instance.getSubject().getPublicCredentials(Principal.class);
            if (publicCreds != null && !publicCreds.isEmpty()) {
                gen.writeStartArray(PUB_CREDS_ARRAY_FIELD);
                for (Principal p : publicCreds) {
                    this.serializePrincipal(gen, p);
                }
                gen.writeEnd();
            }
            if ((set = instance.getSubject().getPrivateCredentials(Principal.class)) != null && !set.isEmpty()) {
                gen.writeStartArray(PRIV_CREDS_ARRAY_FIELD);
                for (Principal p : set) {
                    this.serializePrincipal(gen, p);
                }
                gen.writeEnd();
            }
            gen.writeEnd().close();
            return sink.toString();
        }
        catch (JsonException e) {
            throw new IOException("Exception while serializing AuthenticationResult", e);
        }
    }

    @Nonnull
    public AuthenticationResult deserialize(long version, @Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key, @Nonnull @NotEmpty String value, @Nullable Long expiration) throws IOException {
        AuthenticationResult authenticationResult;
        block16: {
            ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
            JsonReader reader = this.readerFactory.createReader((Reader)new StringReader(value));
            try {
                JsonArray privateCreds;
                JsonArray publicCreds;
                JsonArray principals;
                JsonStructure st = reader.read();
                if (!(st instanceof JsonObject)) {
                    throw new IOException("Found invalid data structure while parsing AuthenticationResult");
                }
                JsonObject obj = (JsonObject)st;
                String flowId = obj.getString(FLOW_ID_FIELD);
                long authnInstant = obj.getJsonNumber(AUTHN_INSTANT_FIELD).longValueExact();
                AuthenticationResult result = new AuthenticationResult(flowId, new Subject());
                result.setAuthenticationInstant(Instant.ofEpochMilli(authnInstant));
                result.setLastActivityInstant(Instant.ofEpochMilli(expiration != null ? expiration : authnInstant));
                result.setPreviousResult(true);
                JsonObject addtlData = obj.getJsonObject(ADDTL_DATA_FIELD);
                if (addtlData != null) {
                    Map dataMap = result.getAdditionalData();
                    addtlData.entrySet().stream().filter(e -> ((JsonValue)e.getValue()).getValueType().equals((Object)JsonValue.ValueType.STRING)).forEach(e -> dataMap.put((String)e.getKey(), ((JsonString)e.getValue()).getString()));
                }
                if ((principals = obj.getJsonArray(PRINCIPAL_ARRAY_FIELD)) != null) {
                    for (Iterator val : principals) {
                        Principal principal = this.deserializePrincipal((JsonValue)val);
                        if (principal == null) continue;
                        result.getSubject().getPrincipals().add(principal);
                    }
                }
                if ((publicCreds = obj.getJsonArray(PUB_CREDS_ARRAY_FIELD)) != null) {
                    for (JsonValue val : publicCreds) {
                        Principal principal = this.deserializePrincipal(val);
                        if (principal == null) continue;
                        result.getSubject().getPublicCredentials().add(principal);
                    }
                }
                if ((privateCreds = obj.getJsonArray(PRIV_CREDS_ARRAY_FIELD)) != null) {
                    for (JsonValue val : privateCreds) {
                        Principal principal = this.deserializePrincipal(val);
                        if (principal == null) continue;
                        result.getSubject().getPrivateCredentials().add(principal);
                    }
                }
                authenticationResult = result;
                if (reader == null) break block16;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ArithmeticException | ClassCastException | NullPointerException | JsonException e2) {
                    throw new IOException("Found invalid data structure while parsing AuthenticationResult", e2);
                }
            }
            reader.close();
        }
        return authenticationResult;
    }

    private void serializePrincipal(@Nonnull JsonGenerator generator, @Nonnull Principal principal) throws IOException {
        boolean serialized = false;
        for (PrincipalSerializer<String> serializer : this.principalSerializers) {
            if (!serializer.supports(principal)) continue;
            try (JsonReader reader = this.readerFactory.createReader((Reader)new StringReader((String)serializer.serialize(principal)));){
                generator.write((JsonValue)reader.readObject());
            }
            serialized = true;
        }
        if (!serialized && this.genericSerializer.supports(principal)) {
            try (JsonReader reader = this.readerFactory.createReader((Reader)new StringReader(this.genericSerializer.serialize(principal)));){
                generator.write((JsonValue)reader.readObject());
            }
        }
    }

    @Nullable
    private Principal deserializePrincipal(@Nonnull JsonValue jsonValue) throws IOException {
        if (jsonValue instanceof JsonObject) {
            String json = ((JsonObject)jsonValue).toString();
            for (PrincipalSerializer<String> serializer : this.principalSerializers) {
                if (!serializer.supports((Object)json)) continue;
                return serializer.deserialize((Object)json);
            }
            if (this.genericSerializer.supports(json)) {
                return this.genericSerializer.deserialize(json);
            }
        }
        return null;
    }
}

