/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.Subject;
import net.shibboleth.idp.authn.AbstractValidationAction;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.CertificateContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.security.SecurityException;
import org.opensaml.security.trust.TrustEngine;
import org.opensaml.security.x509.BasicX509Credential;
import org.opensaml.security.x509.X509Credential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidateX509Certificate
extends AbstractValidationAction {
    @Nonnull
    @NotEmpty
    private static final String DEFAULT_METRIC_NAME = "net.shibboleth.idp.authn.x509";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ValidateX509Certificate.class);
    @Nullable
    private TrustEngine<? super X509Credential> trustEngine;
    @Nullable
    private CertificateContext certContext;

    public ValidateX509Certificate() {
        this.setMetricName(DEFAULT_METRIC_NAME);
    }

    public void setTrustEngine(@Nullable TrustEngine<? super X509Credential> tm) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.trustEngine = tm;
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        if (!super.doPreExecute(profileRequestContext, authenticationContext)) {
            return false;
        }
        this.certContext = (CertificateContext)authenticationContext.getSubcontext(CertificateContext.class);
        if (this.certContext == null) {
            this.log.info("{} No CertificateContext available within authentication context", (Object)this.getLogPrefix());
            this.handleError(profileRequestContext, authenticationContext, "NoCredentials", "NoCredentials");
            return false;
        }
        if (this.certContext.getCertificate() == null || !(this.certContext.getCertificate() instanceof X509Certificate)) {
            this.log.info("{} No X.509 certificate available within CertificateContext", (Object)this.getLogPrefix());
            this.handleError(profileRequestContext, authenticationContext, "NoCredentials", "NoCredentials");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        if (this.trustEngine != null) {
            this.log.debug("{} Attempting to validate certificate using trust engine", (Object)this.getLogPrefix());
            try {
                BasicX509Credential cred = new BasicX509Credential((X509Certificate)this.certContext.getCertificate());
                if (!this.certContext.getIntermediates().isEmpty()) {
                    cred.getEntityCertificateChain().add((X509Certificate)this.certContext.getCertificate());
                    for (Certificate extra : this.certContext.getIntermediates()) {
                        if (!(extra instanceof X509Certificate)) continue;
                        cred.getEntityCertificateChain().add((X509Certificate)extra);
                    }
                }
                if (!this.trustEngine.validate((Object)cred, new CriteriaSet())) {
                    this.log.warn("{} Trust engine failed to validate X.509 certificate", (Object)this.getLogPrefix());
                    this.handleError(profileRequestContext, authenticationContext, "InvalidCredentials", "InvalidCredentials");
                    this.recordFailure();
                    return;
                }
                this.log.debug("{} Trust engine validated X.509 certificate", (Object)this.getLogPrefix());
            }
            catch (SecurityException e) {
                this.log.error("{} Exception raised by trust engine", (Object)this.getLogPrefix(), (Object)e);
                this.handleError(profileRequestContext, authenticationContext, (Exception)((Object)e), "InvalidCredentials");
                this.recordFailure();
                return;
            }
        } else {
            this.log.debug("{} No trust engine configured, certificate will be trusted", (Object)this.getLogPrefix());
        }
        this.log.info("{} Login by '{}' succeeded", (Object)this.getLogPrefix(), (Object)((X509Certificate)this.certContext.getCertificate()).getSubjectX500Principal().getName());
        this.recordSuccess();
        this.buildAuthenticationResult(profileRequestContext, authenticationContext);
        ActionSupport.buildProceedEvent((ProfileRequestContext)profileRequestContext);
    }

    @Nonnull
    protected Subject populateSubject(@Nonnull Subject subject) {
        subject.getPrincipals().add(((X509Certificate)this.certContext.getCertificate()).getSubjectX500Principal());
        subject.getPublicCredentials().add(this.certContext.getCertificate());
        return subject;
    }
}

