/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.duo.impl;

import com.duosecurity.duoweb.DuoWebException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.authn.duo.impl.DuoFailureResponse;
import net.shibboleth.idp.authn.duo.impl.DuoResponseWrapper;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.AbstractInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.protocol.HttpContext;
import org.opensaml.security.httpclient.HttpClientSecurityParameters;
import org.opensaml.security.httpclient.HttpClientSecuritySupport;

@ThreadSafe
public abstract class AbstractDuoAuthenticator
extends AbstractInitializableComponent {
    @NonnullAfterInit
    private HttpClient httpClient;
    @Nullable
    private HttpClientSecurityParameters httpClientSecurityParameters;
    @NonnullAfterInit
    private ObjectMapper objectMapper;

    public void setHttpClient(@Nonnull HttpClient client) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.httpClient = (HttpClient)Constraint.isNotNull((Object)client, (String)"HTTP client cannot be null");
    }

    public void setHttpClientSecurityParameters(@Nullable HttpClientSecurityParameters params) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.httpClientSecurityParameters = params;
    }

    public void setObjectMapper(@Nonnull ObjectMapper mapper) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.objectMapper = (ObjectMapper)Constraint.isNotNull((Object)mapper, (String)"Object mapper cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.httpClient == null) {
            throw new ComponentInitializationException("HttpClient cannot be null");
        }
        if (this.objectMapper == null) {
            throw new ComponentInitializationException("ObjectMapper cannot be null");
        }
    }

    protected <T extends DuoResponseWrapper<?>> T doAPIRequest(@Nonnull HttpUriRequest request, @Nonnull TypeReference<T> wrapperTypeRef) throws DuoWebException, ClientProtocolException, IOException {
        HttpClientContext clientContext = HttpClientContext.create();
        HttpClientSecuritySupport.marshalSecurityParameters((HttpClientContext)clientContext, (HttpClientSecurityParameters)this.httpClientSecurityParameters, (boolean)true);
        HttpClientSecuritySupport.addDefaultTLSTrustEngineCriteria((HttpClientContext)clientContext, (HttpUriRequest)request);
        HttpResponse httpResponse = this.httpClient.execute(request, (HttpContext)clientContext);
        HttpClientSecuritySupport.checkTLSCredentialEvaluated((HttpClientContext)clientContext, (String)request.getURI().getScheme());
        int httpStatusCode = httpResponse.getStatusLine().getStatusCode();
        if (httpStatusCode == 400) {
            InputStream httpContent = httpResponse.getEntity().getContent();
            DuoFailureResponse msg = (DuoFailureResponse)this.objectMapper.readValue(httpContent, DuoFailureResponse.class);
            StringBuilder builder = new StringBuilder();
            builder.append(msg.getMessage() != null ? msg.getMessage() : "no message").append(" (").append(msg.getMessageDetail() != null ? msg.getMessageDetail() : "no detail").append(")");
            throw new DuoWebException(builder.toString());
        }
        if (httpStatusCode != 200) {
            throw new IOException("Non-ok status code (" + httpStatusCode + ") returned from Duo: " + httpResponse.getStatusLine().getReasonPhrase());
        }
        if (httpResponse.getEntity() == null) {
            throw new IOException("No response body returned from Duo");
        }
        DuoResponseWrapper duoResponse = (DuoResponseWrapper)this.objectMapper.readValue(httpResponse.getEntity().getContent(), wrapperTypeRef);
        if (duoResponse == null) {
            throw new DuoWebException("Unable to parse JSON response");
        }
        if (!"OK".equals(duoResponse.getStat())) {
            throw new DuoWebException("Unexpected status value in JSON response: " + duoResponse.getStat());
        }
        return (T)duoResponse;
    }
}

