/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.duo.impl;

import com.duosecurity.duoweb.DuoWebException;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.annotation.Nonnull;
import net.shibboleth.idp.authn.duo.DuoIntegration;
import net.shibboleth.idp.authn.duo.context.DuoAuthenticationContext;
import net.shibboleth.idp.authn.duo.impl.AbstractDuoAuthenticator;
import net.shibboleth.idp.authn.duo.impl.DuoPreauthResponse;
import net.shibboleth.idp.authn.duo.impl.DuoResponseWrapper;
import net.shibboleth.idp.authn.duo.impl.DuoSupport;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.utils.URIBuilder;

public class DuoPreauthAuthenticator
extends AbstractDuoAuthenticator {
    @Nonnull
    private final TypeReference<DuoResponseWrapper<DuoPreauthResponse>> wrapperTypeRef = new TypeReference<DuoResponseWrapper<DuoPreauthResponse>>(){};

    public DuoPreauthResponse authenticate(@Nonnull DuoAuthenticationContext duoContext, @Nonnull DuoIntegration duoIntegration) throws DuoWebException {
        try {
            URI uri = new URIBuilder().setScheme("https").setHost(duoIntegration.getAPIHost()).setPath("/auth/v2/preauth").build();
            RequestBuilder rb = RequestBuilder.post().setUri(uri).addParameter("username", duoContext.getUsername());
            if (duoContext.getClientAddress() != null) {
                rb.addParameter("ipaddr", duoContext.getClientAddress());
            }
            DuoSupport.signRequest(rb, duoIntegration);
            HttpUriRequest request = rb.build();
            return this.doAPIRequest(request, this.wrapperTypeRef).getResponse();
        }
        catch (IOException | URISyntaxException | InvalidKeyException | NoSuchAlgorithmException ex) {
            throw new DuoWebException("Duo AuthAPI preauth request failed: " + ex.getMessage());
        }
    }
}

