/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.AbstractValidationAction;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.profile.audit.impl.PopulateAuditContext;
import net.shibboleth.idp.profile.audit.impl.WriteAuditLog;
import net.shibboleth.idp.profile.context.AuditContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.EventContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public abstract class AbstractAuditingValidationAction
extends AbstractValidationAction {
    @Nonnull
    private Function<ProfileRequestContext, AuditContext> auditContextCreationStrategy = new ChildContextLookup(AuditContext.class, true).compose((Function)new ChildContextLookup(AuthenticationContext.class));
    @Nullable
    private PopulateAuditContext populateAuditContextAction;
    @Nullable
    private WriteAuditLog writeAuditLogAction;
    @Nullable
    private RequestContext requestContext;

    public void setAuditContextCreationStrategy(@Nonnull Function<ProfileRequestContext, AuditContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.auditContextCreationStrategy = (Function)Constraint.isNotNull(strategy, (String)"AuditContext creation strategy cannot be null");
    }

    public void setPopulateAuditContextAction(@Nullable PopulateAuditContext action) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.populateAuditContextAction = action;
    }

    public void setWriteAuditLogAction(@Nullable WriteAuditLog action) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.writeAuditLogAction = action;
    }

    protected Event doExecute(@Nonnull RequestContext springRequestContext, @Nonnull ProfileRequestContext profileRequestContext) {
        this.requestContext = springRequestContext;
        return super.doExecute(springRequestContext, profileRequestContext);
    }

    protected void recordSuccess(@Nonnull ProfileRequestContext profileRequestContext) {
        this.doAudit(profileRequestContext);
        super.recordSuccess(profileRequestContext);
    }

    protected void recordFailure(@Nonnull ProfileRequestContext profileRequestContext) {
        this.doAudit(profileRequestContext);
        super.recordFailure(profileRequestContext);
    }

    @Nullable
    protected AuditContext getAuditContext(@Nonnull ProfileRequestContext profileRequestContext) {
        return this.auditContextCreationStrategy.apply(profileRequestContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doAudit(@Nonnull ProfileRequestContext profileRequestContext) {
        if (this.populateAuditContextAction != null && this.writeAuditLogAction != null) {
            EventContext existingEvent = (EventContext)profileRequestContext.getSubcontext(EventContext.class);
            try {
                AuditContext ac;
                this.populateAuditContextAction.execute(this.requestContext);
                Map<String, String> fields = this.getAuditFields(profileRequestContext);
                if (fields != null && (ac = this.getAuditContext(profileRequestContext)) != null) {
                    for (Map.Entry<String, String> field : fields.entrySet()) {
                        ac.getFieldValues(field.getKey()).add(field.getValue());
                    }
                }
            }
            finally {
                if (existingEvent != null) {
                    profileRequestContext.addSubcontext((BaseContext)existingEvent);
                }
            }
            try {
                this.writeAuditLogAction.execute(this.requestContext);
            }
            finally {
                if (existingEvent != null) {
                    profileRequestContext.addSubcontext((BaseContext)existingEvent);
                }
            }
        }
    }

    @Nullable
    @NonnullElements
    protected Map<String, String> getAuditFields(@Nonnull ProfileRequestContext profileRequestContext) {
        return null;
    }
}

