/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import net.shibboleth.idp.authn.AbstractAuthenticationAction;
import net.shibboleth.idp.authn.AuthenticationFlowDescriptor;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterFlowsByNonBrowserSupport
extends AbstractAuthenticationAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(FilterFlowsByNonBrowserSupport.class);

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        if (!super.doPreExecute(profileRequestContext, authenticationContext)) {
            return false;
        }
        if (profileRequestContext.isBrowserProfile()) {
            this.log.debug("{} Request does not have non-browser requirement, nothing to do", (Object)this.getLogPrefix());
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        Map potentialFlows = authenticationContext.getPotentialFlows();
        Iterator descriptorItr = potentialFlows.entrySet().iterator();
        while (descriptorItr.hasNext()) {
            AuthenticationFlowDescriptor descriptor = (AuthenticationFlowDescriptor)descriptorItr.next().getValue();
            if (descriptor.isNonBrowserSupported()) {
                this.log.debug("{} Retaining flow {}, it supports non-browser authentication", (Object)this.getLogPrefix(), (Object)descriptor.getId());
                continue;
            }
            this.log.debug("{} Removing flow {}, it does not support non-browser authentication", (Object)this.getLogPrefix(), (Object)descriptor.getId());
            descriptorItr.remove();
        }
        if (potentialFlows.size() == 0) {
            this.log.info("{} No potential authentication flows remain after filtering", (Object)this.getLogPrefix());
        } else {
            this.log.debug("{} Potential authentication flows left after filtering: {}", (Object)this.getLogPrefix(), potentialFlows.keySet());
        }
    }
}

