/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import java.security.Principal;
import java.util.Collection;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.Subject;
import net.shibboleth.idp.authn.AbstractAuthenticationAction;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.MultiFactorAuthenticationContext;
import net.shibboleth.idp.authn.context.SubjectCanonicalizationContext;
import net.shibboleth.idp.authn.principal.AuthenticationResultPrincipal;
import net.shibboleth.idp.profile.context.navigate.RelyingPartyIdLookupFunction;
import net.shibboleth.idp.profile.context.navigate.ResponderIdLookupFunction;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FinalizeMultiFactorAuthentication
extends AbstractAuthenticationAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(FinalizeMultiFactorAuthentication.class);
    @Nonnull
    private Function<ProfileRequestContext, MultiFactorAuthenticationContext> multiFactorContextLookupStrategy = new ChildContextLookup(MultiFactorAuthenticationContext.class).compose((Function)new ChildContextLookup(AuthenticationContext.class));
    @NonnullAfterInit
    private Function<ProfileRequestContext, AuthenticationResult> resultMergingStrategy;
    @Nullable
    private Predicate<ProfileRequestContext> resultCachingPredicate;
    @Nullable
    private Function<ProfileRequestContext, String> requesterLookupStrategy = new RelyingPartyIdLookupFunction();
    @Nullable
    private Function<ProfileRequestContext, String> responderLookupStrategy = new ResponderIdLookupFunction();
    @Nullable
    private MultiFactorAuthenticationContext mfaContext;

    public void setMultiFactorContextLookupStrategy(@Nonnull Function<ProfileRequestContext, MultiFactorAuthenticationContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.multiFactorContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"MultiFactorAuthenticationContext lookup strategy cannot be null");
    }

    public void setResultMergingStrategy(@Nullable Function<ProfileRequestContext, AuthenticationResult> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.resultMergingStrategy = strategy;
    }

    public void setResultCachingPredicate(@Nullable Predicate<ProfileRequestContext> predicate) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.resultCachingPredicate = predicate;
    }

    public void setRequesterLookupStrategy(@Nullable Function<ProfileRequestContext, String> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.requesterLookupStrategy = strategy;
    }

    public void setResponderLookupStrategy(@Nullable Function<ProfileRequestContext, String> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.responderLookupStrategy = strategy;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.resultMergingStrategy == null) {
            this.resultMergingStrategy = new DefaultResultMergingStrategy();
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        if (!super.doPreExecute(profileRequestContext, authenticationContext)) {
            return false;
        }
        this.mfaContext = this.multiFactorContextLookupStrategy.apply(profileRequestContext);
        if (this.mfaContext == null) {
            this.log.error("{} No MultiFactorAuthenticationContext found by lookup strategy", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        this.log.debug("{} MFA complete, producing merged result", (Object)this.getLogPrefix());
        AuthenticationResult result = this.resultMergingStrategy.apply(profileRequestContext);
        if (result == null) {
            this.log.warn("{} Unable to produce merged AuthenticationResult", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidAuthenticationContext");
            return;
        }
        authenticationContext.setAuthenticationResult(result);
        BiConsumer decorator = authenticationContext.getAttemptedFlow().getSubjectDecorator();
        if (decorator != null) {
            decorator.accept(profileRequestContext, result.getSubject());
        }
        if (authenticationContext.isResultCacheable() && this.resultCachingPredicate != null) {
            authenticationContext.setResultCacheable(this.resultCachingPredicate.test(profileRequestContext));
            this.log.info("{} Predicate indicates authentication result {} be cacheable in a session", (Object)this.getLogPrefix(), (Object)(authenticationContext.isResultCacheable() ? "will" : "will not"));
        }
        SubjectCanonicalizationContext c14n = new SubjectCanonicalizationContext();
        c14n.setSubject(result.getSubject());
        if (this.requesterLookupStrategy != null) {
            c14n.setRequesterId(this.requesterLookupStrategy.apply(profileRequestContext));
        }
        if (this.responderLookupStrategy != null) {
            c14n.setResponderId(this.responderLookupStrategy.apply(profileRequestContext));
        }
        profileRequestContext.addSubcontext((BaseContext)c14n, true);
    }

    public static class DefaultResultMergingStrategy
    implements Function<ProfileRequestContext, AuthenticationResult> {
        @Override
        @Nullable
        public AuthenticationResult apply(@Nullable ProfileRequestContext input) {
            Collection results;
            MultiFactorAuthenticationContext mfaContext;
            AuthenticationContext authnContext;
            if (input != null && (authnContext = (AuthenticationContext)input.getSubcontext(AuthenticationContext.class)) != null && (mfaContext = (MultiFactorAuthenticationContext)authnContext.getSubcontext(MultiFactorAuthenticationContext.class)) != null && !(results = mfaContext.getActiveResults().values()).isEmpty()) {
                boolean allPreviousResults = true;
                Subject subject = new Subject();
                for (AuthenticationResult result : results) {
                    subject.getPrincipals().add((Principal)new AuthenticationResultPrincipal(result));
                    subject.getPrincipals().addAll(result.getSubject().getPrincipals());
                    subject.getPublicCredentials().addAll(result.getSubject().getPublicCredentials());
                    subject.getPrivateCredentials().addAll(result.getSubject().getPrivateCredentials());
                    allPreviousResults = allPreviousResults && result.isPreviousResult();
                }
                AuthenticationResult merged = new AuthenticationResult(mfaContext.getAuthenticationFlowDescriptor().getId(), subject);
                merged.setPreviousResult(allPreviousResults);
                return merged;
            }
            return null;
        }
    }
}

