/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import net.shibboleth.idp.authn.AbstractCredentialValidator;
import net.shibboleth.idp.authn.CredentialValidator;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.CertificateContext;
import net.shibboleth.utilities.java.support.annotation.constraint.ThreadSafeAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.security.SecurityException;
import org.opensaml.security.trust.TrustEngine;
import org.opensaml.security.x509.BasicX509Credential;
import org.opensaml.security.x509.X509Credential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafeAfterInit
public class X509CertificateCredentialValidator
extends AbstractCredentialValidator {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(X509CertificateCredentialValidator.class);
    @Nonnull
    private Function<AuthenticationContext, CertificateContext> certContextLookupStrategy = new ChildContextLookup(CertificateContext.class);
    @Nullable
    private TrustEngine<? super X509Credential> trustEngine;
    private boolean saveCertificateToCredentialSet;

    public void setCertificateContextLookupStrategy(@Nonnull Function<AuthenticationContext, CertificateContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.certContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"CertificateContextLookupStrategy cannot be null");
    }

    public void setTrustEngine(@Nullable TrustEngine<? super X509Credential> tm) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.trustEngine = tm;
    }

    public void setSaveCertificateToCredentialSet(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.saveCertificateToCredentialSet = flag;
    }

    @Nullable
    protected Subject doValidate(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext, @Nullable CredentialValidator.WarningHandler warningHandler, @Nullable CredentialValidator.ErrorHandler errorHandler) throws Exception {
        CertificateContext certContext = this.certContextLookupStrategy.apply(authenticationContext);
        if (certContext == null) {
            this.log.debug("{} No CertificateContext available within authentication context", (Object)this.getLogPrefix());
            return null;
        }
        if (certContext.getCertificate() == null || !(certContext.getCertificate() instanceof X509Certificate)) {
            this.log.debug("{} No X.509 certificate available within CertificateContext", (Object)this.getLogPrefix());
            return null;
        }
        if (this.trustEngine != null) {
            this.log.debug("{} Attempting to validate certificate using trust engine", (Object)this.getLogPrefix());
            try {
                BasicX509Credential cred = new BasicX509Credential((X509Certificate)certContext.getCertificate());
                if (!certContext.getIntermediates().isEmpty()) {
                    cred.getEntityCertificateChain().add((X509Certificate)certContext.getCertificate());
                    for (Certificate extra : certContext.getIntermediates()) {
                        if (!(extra instanceof X509Certificate)) continue;
                        cred.getEntityCertificateChain().add((X509Certificate)extra);
                    }
                }
                if (!this.trustEngine.validate((Object)cred, new CriteriaSet())) {
                    this.log.warn("{} Trust engine failed to validate X.509 certificate", (Object)this.getLogPrefix());
                    LoginException e = new LoginException("InvalidCredentials");
                    if (errorHandler != null) {
                        errorHandler.handleError(profileRequestContext, authenticationContext, (Exception)e, "InvalidCredentials");
                    }
                    throw e;
                }
                this.log.debug("{} Trust engine validated X.509 certificate", (Object)this.getLogPrefix());
            }
            catch (SecurityException e) {
                this.log.error("{} Exception raised by trust engine", (Object)this.getLogPrefix(), (Object)e);
                if (errorHandler != null) {
                    errorHandler.handleError(profileRequestContext, authenticationContext, (Exception)((Object)e), "InvalidCredentials");
                }
                throw e;
            }
        } else {
            this.log.debug("{} No trust engine configured, certificate will be trusted", (Object)this.getLogPrefix());
        }
        this.log.info("{} Login by '{}' succeeded", (Object)this.getLogPrefix(), (Object)((X509Certificate)certContext.getCertificate()).getSubjectX500Principal().getName());
        return this.populateSubject((X509Certificate)certContext.getCertificate());
    }

    @Nonnull
    protected Subject populateSubject(@Nonnull X509Certificate certificate) {
        Subject subject = new Subject();
        subject.getPrincipals().add(certificate.getSubjectX500Principal());
        if (this.saveCertificateToCredentialSet) {
            subject.getPublicCredentials().add(certificate);
        }
        return super.populateSubject(subject);
    }
}

