/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.proxy.impl;

import com.google.common.escape.Escaper;
import com.google.common.net.UrlEscapers;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import javax.servlet.http.HttpServletRequest;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.collection.Pair;
import net.shibboleth.utilities.java.support.component.AbstractInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.RequestContext;

@ThreadSafe
public class DiscoveryProfileRequestFunction
extends AbstractInitializableComponent
implements Function<Pair<RequestContext, ProfileRequestContext>, String> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DiscoveryProfileRequestFunction.class);
    @Nonnull
    private Escaper escaper = UrlEscapers.urlFormParameterEscaper();
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyContext> relyingPartyContextLookupStrategy = new ChildContextLookup(RelyingPartyContext.class);
    @NonnullAfterInit
    private Function<ProfileRequestContext, String> discoveryURLLookupStrategy;

    public void setRelyingPartyContextLookupStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.relyingPartyContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"RelyingPartyContext lookup strategy cannot be null");
    }

    public void setDiscoveryURLLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.discoveryURLLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Discovery URL lookup strategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.discoveryURLLookupStrategy == null) {
            throw new ComponentInitializationException("Discovery URL lookup strategy cannot be null");
        }
    }

    @Override
    @Nullable
    public String apply(@Nonnull Pair<RequestContext, ProfileRequestContext> input) {
        RelyingPartyContext rpCtx = this.relyingPartyContextLookupStrategy.apply((ProfileRequestContext)input.getSecond());
        Constraint.isNotNull((Object)rpCtx, (String)"RelyingPartyContext cannot be null");
        Constraint.isNotNull((Object)rpCtx.getConfiguration(), (String)"RelyingPartyConfiguration cannot be null");
        String baseURL = this.discoveryURLLookupStrategy.apply((ProfileRequestContext)input.getSecond());
        Constraint.isNotEmpty((String)baseURL, (String)"Discovery URL cannot be null or empty");
        String entityID = rpCtx.getConfiguration().getResponderId((ProfileRequestContext)input.getSecond());
        StringBuilder builder = new StringBuilder(baseURL);
        builder.append(baseURL.contains("?") ? (char)'&' : '?').append("entityID=").append(this.escaper.escape(entityID));
        AuthenticationContext authenticationContext = (AuthenticationContext)((ProfileRequestContext)input.getSecond()).getSubcontext(AuthenticationContext.class);
        if (authenticationContext != null && authenticationContext.isPassive()) {
            builder.append("&isPassive=true");
        }
        HttpServletRequest httpServletRequest = (HttpServletRequest)((RequestContext)input.getFirst()).getExternalContext().getNativeRequest();
        StringBuilder selfBuilder = new StringBuilder(httpServletRequest.getScheme());
        selfBuilder.append("://").append(httpServletRequest.getServerName());
        int port = httpServletRequest.getServerPort();
        if (port != (httpServletRequest.isSecure() ? 443 : 80)) {
            selfBuilder.append(':').append(port);
        }
        selfBuilder.append(((RequestContext)input.getFirst()).getFlowExecutionUrl()).append("&_eventId_proceed=1");
        builder.append("&return=").append(this.escaper.escape(selfBuilder.toString()));
        return builder.toString();
    }
}

