/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.AbstractAuthenticationAction;
import net.shibboleth.idp.authn.AuthenticationFlowDescriptor;
import net.shibboleth.idp.authn.config.navigate.AuthenticationFlowsLookupFunction;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.principal.PrincipalEvalPredicateFactoryRegistry;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.logic.FunctionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PopulateAuthenticationContext
extends AbstractAuthenticationAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(PopulateAuthenticationContext.class);
    @Nonnull
    @NonnullElements
    private Collection<AuthenticationFlowDescriptor> availableFlows = Collections.emptyList();
    @Nonnull
    private Function<ProfileRequestContext, Collection<AuthenticationFlowDescriptor>> potentialFlowsLookupStrategy = FunctionSupport.constant(Collections.emptyList());
    @Nonnull
    private Function<ProfileRequestContext, Collection<String>> activeFlowsLookupStrategy = new AuthenticationFlowsLookupFunction();
    @Nullable
    private PrincipalEvalPredicateFactoryRegistry evalRegistry;
    @Nullable
    private Function<ProfileRequestContext, String> fixedEventLookupStrategy;

    public void setAvailableFlows(@Nonnull @NonnullElements Collection<AuthenticationFlowDescriptor> flows) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.availableFlows = List.copyOf((Collection)Constraint.isNotNull(flows, (String)"Flow collection cannot be null"));
    }

    public void setPotentialFlowsLookupStrategy(@Nonnull Function<ProfileRequestContext, Collection<AuthenticationFlowDescriptor>> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.potentialFlowsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Potential flow lookup strategy cannot be null");
    }

    public void setActiveFlowsLookupStrategy(@Nonnull Function<ProfileRequestContext, Collection<String>> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.activeFlowsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Flow lookup strategy cannot be null");
    }

    @Nonnull
    public PrincipalEvalPredicateFactoryRegistry getPrincipalPredicateFactoryEvalRegistry() {
        return this.evalRegistry;
    }

    public void setPrincipalEvalPredicateFactoryRegistry(@Nonnull PrincipalEvalPredicateFactoryRegistry registry) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.evalRegistry = (PrincipalEvalPredicateFactoryRegistry)Constraint.isNotNull((Object)registry, (String)"PrincipalEvalPredicateFactoryRegistry cannot be null");
    }

    public void setFixedEventLookupStrategy(@Nullable Function<ProfileRequestContext, String> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.fixedEventLookupStrategy = strategy;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        if (this.evalRegistry != null) {
            authenticationContext.setPrincipalEvalPredicateFactoryRegistry(this.evalRegistry);
        }
        if (this.fixedEventLookupStrategy != null) {
            authenticationContext.setFixedEventLookupStrategy(this.fixedEventLookupStrategy);
        }
        if (this.availableFlows.isEmpty()) {
            this.log.warn("{} No authentication flows are available", (Object)this.getLogPrefix());
            return;
        }
        for (AuthenticationFlowDescriptor desc : this.availableFlows) {
            authenticationContext.getAvailableFlows().put(desc.getId(), desc);
        }
        Collection<String> activeFlows = this.activeFlowsLookupStrategy.apply(profileRequestContext);
        if (activeFlows != null && !activeFlows.isEmpty()) {
            for (AuthenticationFlowDescriptor desc : this.potentialFlowsLookupStrategy.apply(profileRequestContext)) {
                String flowId = desc.getId().substring(desc.getId().indexOf(47) + 1);
                if (activeFlows.contains(flowId)) {
                    if (authenticationContext.getAvailableFlows().containsKey(desc.getId()) && desc.test(profileRequestContext)) {
                        authenticationContext.getPotentialFlows().put(desc.getId(), desc);
                        continue;
                    }
                    this.log.debug("{} Filtered out authentication flow {}", (Object)this.getLogPrefix(), (Object)desc.getId());
                    continue;
                }
                this.log.debug("{} Filtered out authentication flow {} due to profile configuration", (Object)this.getLogPrefix(), (Object)desc.getId());
            }
        } else {
            for (AuthenticationFlowDescriptor desc : this.potentialFlowsLookupStrategy.apply(profileRequestContext)) {
                if (authenticationContext.getAvailableFlows().containsKey(desc.getId()) && desc.test(profileRequestContext)) {
                    authenticationContext.getPotentialFlows().put(desc.getId(), desc);
                    continue;
                }
                this.log.debug("{} Filtered out authentication flow {}", (Object)this.getLogPrefix(), (Object)desc.getId());
            }
        }
        if (authenticationContext.getPotentialFlows().isEmpty()) {
            this.log.warn("{} No authentication flows are active for this request", (Object)this.getLogPrefix());
        } else {
            this.log.debug("{} Installed {} potential authentication flows into AuthenticationContext", (Object)this.getLogPrefix(), (Object)authenticationContext.getPotentialFlows().size());
        }
    }
}

