/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import java.security.Principal;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.AbstractAuthenticationAction;
import net.shibboleth.idp.authn.AuthenticationFlowDescriptor;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.PreferredPrincipalContext;
import net.shibboleth.idp.authn.context.RequestedPrincipalContext;
import net.shibboleth.idp.authn.principal.PrincipalEvalPredicate;
import net.shibboleth.idp.authn.principal.PrincipalSupportingComponent;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectAuthenticationFlow
extends AbstractAuthenticationAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SelectAuthenticationFlow.class);
    private boolean favorSSO;
    @Nullable
    private RequestedPrincipalContext requestedPrincipalCtx;
    @Nullable
    private PreferredPrincipalContext preferredPrincipalCtx;
    private boolean noProxying;

    public boolean getFavorSSO() {
        return this.favorSSO;
    }

    public void setFavorSSO(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.favorSSO = flag;
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        if (!super.doPreExecute(profileRequestContext, authenticationContext)) {
            return false;
        }
        this.noProxying = authenticationContext.getProxyCount() != null && authenticationContext.getProxyCount() == 0;
        this.requestedPrincipalCtx = (RequestedPrincipalContext)authenticationContext.getSubcontext(RequestedPrincipalContext.class);
        if (this.requestedPrincipalCtx != null && (this.requestedPrincipalCtx.getOperator() == null || this.requestedPrincipalCtx.getRequestedPrincipals().isEmpty())) {
            this.requestedPrincipalCtx = null;
        }
        this.preferredPrincipalCtx = (PreferredPrincipalContext)authenticationContext.getSubcontext(PreferredPrincipalContext.class);
        if (this.preferredPrincipalCtx != null && this.preferredPrincipalCtx.getPreferredPrincipals().isEmpty()) {
            this.preferredPrincipalCtx = null;
        }
        if (authenticationContext.getAttemptedFlow() != null) {
            this.log.info("{} Moving incomplete flow {} to intermediate set", (Object)this.getLogPrefix(), (Object)authenticationContext.getAttemptedFlow().getId());
            authenticationContext.getIntermediateFlows().put(authenticationContext.getAttemptedFlow().getId(), authenticationContext.getAttemptedFlow());
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        if (authenticationContext.getSignaledFlowId() != null) {
            this.doSelectSignaledFlow(profileRequestContext, authenticationContext);
        } else if (this.requestedPrincipalCtx == null) {
            this.doSelectNoRequestedPrincipals(profileRequestContext, authenticationContext);
        } else {
            this.doSelectRequestedPrincipals(profileRequestContext, authenticationContext);
        }
    }

    private void doSelectSignaledFlow(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        PrincipalEvalPredicate predicate;
        AuthenticationFlowDescriptor flow = (AuthenticationFlowDescriptor)authenticationContext.getPotentialFlows().get(authenticationContext.getSignaledFlowId());
        if (flow == null) {
            this.log.error("{} Signaled flow {} is not available", (Object)this.getLogPrefix(), (Object)authenticationContext.getSignaledFlowId());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)(authenticationContext.isPassive() ? "NoPassive" : "NoPotentialFlow"));
            authenticationContext.setSignaledFlowId(null);
            return;
        }
        authenticationContext.setSignaledFlowId(null);
        this.log.debug("{} Attempting to honor signaled flow {}", (Object)this.getLogPrefix(), (Object)flow.getId());
        if (this.noProxying && flow.isProxyScopingEnforced()) {
            this.log.error("{} Signaled flow {} disallowed due to proxy count of zero", (Object)this.getLogPrefix(), (Object)flow.getId());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)(authenticationContext.isPassive() ? "NoPassive" : "ProxyCountExceeded"));
            return;
        }
        AuthenticationResult activeResult = null;
        if (!authenticationContext.isForceAuthn() && !(activeResult = (AuthenticationResult)authenticationContext.getActiveResults().get(flow.getId())).test(profileRequestContext)) {
            this.log.debug("{} Active result for flow {} not reusable, ignoring", (Object)this.getLogPrefix(), (Object)activeResult.getAuthenticationFlowId());
            activeResult = null;
        }
        if (activeResult != null) {
            if (this.requestedPrincipalCtx != null) {
                for (Principal p : this.requestedPrincipalCtx.getRequestedPrincipals()) {
                    predicate = this.requestedPrincipalCtx.getPredicate(p);
                    if (predicate != null) {
                        if (!predicate.test((Object)activeResult)) continue;
                        this.selectActiveResult(profileRequestContext, authenticationContext, activeResult);
                        return;
                    }
                    this.log.warn("{} Configuration does not support requested principal evaluation with operator '{}' and type '{}'", new Object[]{this.getLogPrefix(), this.requestedPrincipalCtx.getOperator(), p.getClass()});
                }
            } else {
                this.selectActiveResult(profileRequestContext, authenticationContext, activeResult);
                return;
            }
        }
        if (authenticationContext.isPassive() && !flow.isPassiveAuthenticationSupported()) {
            this.log.error("{} Signaled flow {} does not support passive authentication", (Object)this.getLogPrefix(), (Object)flow.getId());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"NoPassive");
            return;
        }
        if (this.requestedPrincipalCtx != null) {
            for (Principal p : this.requestedPrincipalCtx.getRequestedPrincipals()) {
                predicate = this.requestedPrincipalCtx.getPredicate(p);
                if (predicate != null) {
                    if (!predicate.test((Object)flow) || !flow.test(profileRequestContext)) continue;
                    this.selectInactiveFlow(profileRequestContext, authenticationContext, flow);
                    return;
                }
                this.log.warn("{} Configuration does not support requested principal evaluation with operator '{}' and type '{}'", new Object[]{this.getLogPrefix(), this.requestedPrincipalCtx.getOperator(), p.getClass()});
            }
        } else if (flow.test(profileRequestContext)) {
            this.selectInactiveFlow(profileRequestContext, authenticationContext, flow);
            return;
        }
        this.log.error("{} Signaled flow {} was not applicable to request", (Object)this.getLogPrefix(), (Object)flow.getId());
        ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)(authenticationContext.isPassive() ? "NoPassive" : "NoPotentialFlow"));
    }

    private void doSelectNoRequestedPrincipals(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        this.log.debug("{} No specific Principals requested", (Object)this.getLogPrefix());
        if (authenticationContext.isForceAuthn()) {
            this.log.debug("{} Forced authentication requested, selecting an inactive flow", (Object)this.getLogPrefix());
            AuthenticationFlowDescriptor flow = this.getUnattemptedInactiveFlow(profileRequestContext, authenticationContext);
            if (flow == null) {
                this.log.info("{} No potential flows left to choose from, authentication failed", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)(authenticationContext.isPassive() ? "NoPassive" : (this.noProxying ? "ProxyCountExceeded" : "NoPotentialFlow")));
                return;
            }
            this.selectInactiveFlow(profileRequestContext, authenticationContext, flow);
            return;
        }
        AuthenticationResult resultToSelect = null;
        for (AuthenticationResult activeResult : authenticationContext.getActiveResults().values()) {
            if (activeResult.test(profileRequestContext)) {
                resultToSelect = activeResult;
                if (this.preferredPrincipalCtx != null && !this.preferredPrincipalCtx.isAcceptable((PrincipalSupportingComponent)activeResult)) continue;
                break;
            }
            this.log.debug("{} Active result for flow {} not reusable, ignoring", (Object)this.getLogPrefix(), (Object)activeResult.getAuthenticationFlowId());
        }
        if (resultToSelect != null) {
            this.selectActiveResult(profileRequestContext, authenticationContext, resultToSelect);
            return;
        }
        this.log.debug("{} No usable active results available, selecting an inactive flow", (Object)this.getLogPrefix());
        AuthenticationFlowDescriptor flow = this.getUnattemptedInactiveFlow(profileRequestContext, authenticationContext);
        if (flow == null) {
            this.log.info("{} No potential flows left to choose from, authentication failed", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)(authenticationContext.isPassive() ? "NoPassive" : (this.noProxying ? "ProxyCountExceeded" : "NoPotentialFlow")));
            return;
        }
        this.selectInactiveFlow(profileRequestContext, authenticationContext, flow);
    }

    @Nullable
    private AuthenticationFlowDescriptor getUnattemptedInactiveFlow(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        AuthenticationFlowDescriptor selectedFlow = null;
        for (AuthenticationFlowDescriptor flow : authenticationContext.getPotentialFlows().values()) {
            if (authenticationContext.getIntermediateFlows().containsKey(flow.getId()) || authenticationContext.isPassive() && !flow.isPassiveAuthenticationSupported() || this.noProxying && flow.isProxyScopingEnforced() || !flow.test(profileRequestContext)) continue;
            selectedFlow = flow;
            if (this.preferredPrincipalCtx != null && !this.preferredPrincipalCtx.isAcceptable((PrincipalSupportingComponent)flow)) continue;
            break;
        }
        return selectedFlow;
    }

    private void selectInactiveFlow(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext, @Nonnull AuthenticationFlowDescriptor descriptor) {
        this.log.debug("{} Selecting inactive authentication flow {}", (Object)this.getLogPrefix(), (Object)descriptor.getId());
        authenticationContext.setAttemptedFlow(descriptor);
        ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)descriptor.getId());
    }

    private void selectActiveResult(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext, @Nonnull AuthenticationResult result) {
        this.log.debug("{} Reusing active result {}", (Object)this.getLogPrefix(), (Object)result.getAuthenticationFlowId());
        result.setLastActivityInstantToNow();
        authenticationContext.setAuthenticationResult(result);
        ActionSupport.buildProceedEvent((ProfileRequestContext)profileRequestContext);
    }

    private void doSelectRequestedPrincipals(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        this.log.debug("{} Specific principals requested with '{}' operator: {}", new Object[]{this.getLogPrefix(), this.requestedPrincipalCtx.getOperator(), this.requestedPrincipalCtx.getRequestedPrincipals()});
        if (authenticationContext.isForceAuthn()) {
            this.log.debug("{} Forced authentication requested, selecting an inactive flow", (Object)this.getLogPrefix());
            this.selectRequestedInactiveFlow(profileRequestContext, authenticationContext);
        } else if (authenticationContext.getActiveResults().isEmpty()) {
            this.log.debug("{} No active results available, selecting an inactive flow", (Object)this.getLogPrefix());
            this.selectRequestedInactiveFlow(profileRequestContext, authenticationContext);
        } else {
            this.selectRequestedFlow(profileRequestContext, authenticationContext, authenticationContext.getActiveResults());
        }
    }

    private void selectRequestedInactiveFlow(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        Map potentialFlows = authenticationContext.getPotentialFlows();
        for (Principal p : this.requestedPrincipalCtx.getRequestedPrincipals()) {
            this.log.debug("{} Checking for inactive flow compatible with operator '{}' and principal '{}'", new Object[]{this.getLogPrefix(), this.requestedPrincipalCtx.getOperator(), p.getName()});
            PrincipalEvalPredicate predicate = this.requestedPrincipalCtx.getPredicate(p);
            if (predicate != null) {
                for (AuthenticationFlowDescriptor descriptor : potentialFlows.values()) {
                    if (authenticationContext.getIntermediateFlows().containsKey(descriptor.getId()) || !predicate.test((Object)descriptor) || !descriptor.test(profileRequestContext) || authenticationContext.isPassive() && !descriptor.isPassiveAuthenticationSupported()) continue;
                    if (!this.noProxying || !descriptor.isProxyScopingEnforced()) {
                        this.selectInactiveFlow(profileRequestContext, authenticationContext, descriptor);
                        return;
                    }
                    this.log.debug("{} Flow '{}' disallowed by effective proxy count of zero", (Object)this.getLogPrefix(), (Object)descriptor.getId());
                }
                continue;
            }
            this.log.warn("{} Configuration does not support requested principal evaluation with operator '{}' and type '{}'", new Object[]{this.getLogPrefix(), this.requestedPrincipalCtx.getOperator(), p.getClass()});
        }
        this.log.info("{} None of the potential authentication flows can satisfy the request", (Object)this.getLogPrefix());
        ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)(authenticationContext.isPassive() ? "NoPassive" : (this.noProxying ? "ProxyCountExceeded" : "RequestUnsupported")));
    }

    private void selectRequestedFlow(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext, @Nonnull @NonnullElements Map<String, AuthenticationResult> activeResults) {
        if (this.favorSSO) {
            this.log.debug("{} Giving priority to active results that meet request requirements");
            for (Principal p : this.requestedPrincipalCtx.getRequestedPrincipals()) {
                this.log.debug("{} Checking for an active result compatible with operator '{}' and principal '{}'", new Object[]{this.getLogPrefix(), this.requestedPrincipalCtx.getOperator(), p.getName()});
                PrincipalEvalPredicate predicate = this.requestedPrincipalCtx.getPredicate(p);
                if (predicate != null) {
                    for (AuthenticationResult result : activeResults.values()) {
                        if (result.test(profileRequestContext) && predicate.test((Object)result)) {
                            this.selectActiveResult(profileRequestContext, authenticationContext, result);
                            return;
                        }
                        this.log.debug("{} Active result for flow {} not usable, ignoring", (Object)this.getLogPrefix(), (Object)result.getAuthenticationFlowId());
                    }
                    continue;
                }
                this.log.warn("{} Configuration does not support requested principal evaluation with operator '{}' and type '{}'", new Object[]{this.getLogPrefix(), this.requestedPrincipalCtx.getOperator(), p.getClass()});
            }
            this.selectRequestedInactiveFlow(profileRequestContext, authenticationContext);
            return;
        }
        Map potentialFlows = authenticationContext.getPotentialFlows();
        for (Principal p : this.requestedPrincipalCtx.getRequestedPrincipals()) {
            this.log.debug("{} Checking for an inactive flow or active result compatible with operator '{}' and principal '{}'", new Object[]{this.getLogPrefix(), this.requestedPrincipalCtx.getOperator(), p.getName()});
            PrincipalEvalPredicate predicate = this.requestedPrincipalCtx.getPredicate(p);
            if (predicate != null) {
                for (AuthenticationFlowDescriptor descriptor : potentialFlows.values()) {
                    if (authenticationContext.getIntermediateFlows().containsKey(descriptor.getId()) || !predicate.test((Object)descriptor) || !descriptor.test(profileRequestContext)) continue;
                    AuthenticationResult result = activeResults.get(descriptor.getId());
                    if (result == null || !result.test(profileRequestContext) || !predicate.test((Object)result)) {
                        if (result != null) {
                            this.log.debug("{} Active result for flow {} not usable, ignoring", (Object)this.getLogPrefix(), (Object)result.getAuthenticationFlowId());
                        }
                        if (authenticationContext.isPassive() && !descriptor.isPassiveAuthenticationSupported()) continue;
                        if (!this.noProxying || !descriptor.isProxyScopingEnforced()) {
                            this.selectInactiveFlow(profileRequestContext, authenticationContext, descriptor);
                            return;
                        }
                        this.log.debug("{} Flow '{}' disallowed by effective proxy count of zero", (Object)this.getLogPrefix(), (Object)descriptor.getId());
                        continue;
                    }
                    this.selectActiveResult(profileRequestContext, authenticationContext, result);
                    return;
                }
                continue;
            }
            this.log.warn("{} Configuration does not support requested principal evaluation with operator '{}' and type '{}'", new Object[]{this.getLogPrefix(), this.requestedPrincipalCtx.getOperator(), p.getClass()});
        }
        this.log.info("{} None of the potential authentication flows can satisfy the request", (Object)this.getLogPrefix());
        ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)(authenticationContext.isPassive() ? "NoPassive" : (this.noProxying ? "ProxyCountExceeded" : "RequestUnsupported")));
    }
}

