/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.principal.impl;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.security.Principal;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonBuilderFactory;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import javax.json.JsonString;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.stream.JsonGenerator;
import javax.security.auth.x500.X500Principal;
import net.shibboleth.idp.authn.principal.AbstractPrincipalSerializer;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.codec.Base64Support;
import net.shibboleth.utilities.java.support.codec.DecodingException;
import net.shibboleth.utilities.java.support.codec.EncodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class X500PrincipalSerializer
extends AbstractPrincipalSerializer<String> {
    @Nonnull
    @NotEmpty
    private static final String X500_NAME_FIELD = "X500";
    private static final Pattern JSON_PATTERN = Pattern.compile("^\\{\"X500\":.*\\}$");
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(X500PrincipalSerializer.class);
    @Nonnull
    private final JsonBuilderFactory objectBuilderFactory = Json.createBuilderFactory(null);

    public boolean supports(@Nonnull Principal principal) {
        return principal instanceof X500Principal;
    }

    @Nonnull
    @NotEmpty
    public String serialize(@Nonnull Principal principal) throws IOException {
        String name;
        X500Principal x500Principal = (X500Principal)principal;
        try {
            name = Base64Support.encode((byte[])x500Principal.getEncoded(), (boolean)false);
        }
        catch (EncodingException e) {
            throw new IOException(e);
        }
        StringWriter sink = new StringWriter(32);
        try (JsonGenerator gen = this.getJsonGenerator(sink);){
            gen.writeStartObject().write(X500_NAME_FIELD, name).writeEnd();
        }
        return sink.toString();
    }

    public boolean supports(@Nonnull @NotEmpty String value) {
        return JSON_PATTERN.matcher(value).matches();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public X500Principal deserialize(@Nonnull @NotEmpty String value) throws IOException {
        try (JsonReader reader = this.getJsonReader(new StringReader(value));){
            JsonStructure st = reader.read();
            if (!(st instanceof JsonObject)) {
                throw new IOException("Found invalid data structure while parsing X500Principal");
            }
            JsonValue jsonValue = (JsonValue)((JsonObject)st).get((Object)X500_NAME_FIELD);
            if (jsonValue == null) throw new IOException("Serialized X500Principal missing name field");
            if (!JsonValue.ValueType.STRING.equals((Object)jsonValue.getValueType())) throw new IOException("Serialized X500Principal missing name field");
            X500Principal x500Principal = new X500Principal(Base64Support.decode((String)((JsonString)jsonValue).getString()));
            return x500Principal;
        }
        catch (IllegalArgumentException | JsonException | DecodingException e) {
            throw new IOException("Found invalid data while parsing X500Principal", e);
        }
    }

    @Nonnull
    private synchronized JsonObjectBuilder getJsonObjectBuilder() {
        return this.objectBuilderFactory.createObjectBuilder();
    }

    @Nonnull
    private synchronized JsonArrayBuilder getJsonArrayBuilder() {
        return this.objectBuilderFactory.createArrayBuilder();
    }
}

