/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.proxy.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;

@ThreadSafe
public final class InitializeProxyProfileRequestContext
extends AbstractProfileAction {
    @Nonnull
    private Function<ProfileRequestContext, ProfileRequestContext> profileRequestContextCreationStrategy = new DefaultPRCCreationStrategy();
    @Nullable
    private String profileId;
    @Nullable
    private String loggingId;
    private boolean browserProfile;

    public void setProfileRequestContextCreationStrategy(@Nonnull Function<ProfileRequestContext, ProfileRequestContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.profileRequestContextCreationStrategy = (Function)Constraint.isNotNull(strategy, (String)"Creation strategy cannot be null");
    }

    public void setProfileId(@Nullable String id) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.profileId = StringSupport.trimOrNull((String)id);
    }

    public void setLoggingId(@Nullable String id) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.loggingId = StringSupport.trimOrNull((String)id);
    }

    public void setBrowserProfile(boolean browser) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.browserProfile = browser;
    }

    @Nonnull
    public void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        ProfileRequestContext prc = this.profileRequestContextCreationStrategy.apply(profileRequestContext);
        if (prc == null) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return;
        }
        if (this.profileId != null) {
            prc.setProfileId(this.profileId);
        }
        if (this.loggingId != null) {
            prc.setLoggingId(this.loggingId);
        }
        prc.setBrowserProfile(this.browserProfile);
    }

    private class DefaultPRCCreationStrategy
    implements Function<ProfileRequestContext, ProfileRequestContext> {
        private DefaultPRCCreationStrategy() {
        }

        @Override
        @Nullable
        public ProfileRequestContext apply(@Nullable ProfileRequestContext input) {
            AuthenticationContext ac;
            if (input != null && (ac = (AuthenticationContext)input.getSubcontext(AuthenticationContext.class)) != null) {
                return (ProfileRequestContext)ac.addSubcontext((BaseContext)new ProfileRequestContext(), true);
            }
            return null;
        }
    }
}

