/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.revocation.impl;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.jasminb.jsonapi.models.errors.Error;
import com.github.jasminb.jsonapi.models.errors.Errors;
import com.google.common.base.Strings;
import java.io.IOException;
import java.io.OutputStream;
import java.time.Duration;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.context.SpringRequestContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.xml.DOMTypeSupport;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.storage.RevocationCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.RequestContext;

public class DoRevocationCacheOperation
extends AbstractProfileAction {
    @Nonnull
    @NotEmpty
    public static final String CACHE_ID = "revocationCacheId";
    @Nonnull
    @NotEmpty
    public static final String CONTEXT = "context";
    @Nonnull
    @NotEmpty
    public static final String KEY = "key";
    @Nonnull
    private Logger log = LoggerFactory.getLogger(DoRevocationCacheOperation.class);
    @NonnullAfterInit
    private ObjectMapper objectMapper;
    @Nullable
    @NotEmpty
    private String context;
    @Nullable
    @NotEmpty
    private String key;
    @Nullable
    private RevocationCache revocationCache;

    public void setObjectMapper(@Nonnull ObjectMapper mapper) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.objectMapper = (ObjectMapper)Constraint.isNotNull((Object)mapper, (String)"ObjectMapper cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.objectMapper == null) {
            throw new ComponentInitializationException("ObjectMapper cannot be null");
        }
    }

    protected boolean doPreExecute(ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        if (this.getHttpServletRequest() == null || this.getHttpServletResponse() == null) {
            this.log.warn("{} No HttpServletRequest or HttpServletResponse available", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        try {
            SpringRequestContext springRequestContext = (SpringRequestContext)profileRequestContext.getSubcontext(SpringRequestContext.class);
            if (springRequestContext == null) {
                this.log.warn("{} Spring request context not found in profile request context", (Object)this.getLogPrefix());
                this.sendError(500, "Internal Server Error", "System misconfiguration.");
                return false;
            }
            RequestContext requestContext = springRequestContext.getRequestContext();
            if (requestContext == null) {
                this.log.warn("{} Web Flow request context not found in Spring request context", (Object)this.getLogPrefix());
                this.sendError(500, "Internal Server Error", "System misconfiguration.");
                return false;
            }
            String id = (String)this.getParameter(requestContext, CACHE_ID);
            this.context = (String)this.getParameter(requestContext, CONTEXT);
            this.key = (String)this.getParameter(requestContext, KEY);
            if (Strings.isNullOrEmpty((String)id) || Strings.isNullOrEmpty((String)this.context) || Strings.isNullOrEmpty((String)this.key)) {
                this.sendError(404, "Missing revocation cache ID, context, or key", "No revocation cache ID, context, key specified.");
                return false;
            }
            this.revocationCache = (RevocationCache)this.getBean(requestContext, id, RevocationCache.class);
            if (this.revocationCache == null) {
                this.sendError(404, "Invalid Revocation Cache", "Invalid revocation cache identifier in path.");
                return false;
            }
        }
        catch (IOException e) {
            this.log.error("{} I/O error issuing API response", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InputOutputError");
            return false;
        }
        return true;
    }

    protected void doExecute(ProfileRequestContext profileRequestContext) {
        try {
            String method = this.getHttpServletRequest().getMethod();
            HttpServletResponse response = this.getHttpServletResponse();
            response.setContentType("application/json");
            response.setHeader("Cache-Control", "must-revalidate,no-cache,no-store");
            if ("GET".equals(method)) {
                this.doGet();
            } else if ("POST".equals(method) || "PUT".equals(method)) {
                this.doPost();
            } else if ("DELETE".equals(method)) {
                this.doDelete();
            } else {
                this.log.warn("{} Invalid method: {}", (Object)this.getLogPrefix(), (Object)method);
                this.sendError(405, "Unknown Operation", "Only GET, POST, and DELETE are supported.");
            }
        }
        catch (IOException e) {
            this.log.error("{} I/O error responding to request", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InputOutputError");
        }
    }

    private void doGet() throws IOException {
        block9: {
            try {
                String revocation = this.revocationCache.getRevocationRecord(this.context, this.key);
                if (revocation != null) {
                    this.getHttpServletResponse().setStatus(200);
                    JsonFactory jsonFactory = new JsonFactory();
                    try (JsonGenerator g = jsonFactory.createGenerator((OutputStream)this.getHttpServletResponse().getOutputStream()).useDefaultPrettyPrinter();){
                        g.setCodec((ObjectCodec)this.objectMapper);
                        g.writeStartObject();
                        g.writeObjectFieldStart("data");
                        g.writeStringField("type", "revocation-records");
                        g.writeStringField("id", this.revocationCache.getId() + "/" + this.context + "/" + this.key);
                        g.writeObjectFieldStart("attributes");
                        g.writeStringField("revocation", revocation);
                        break block9;
                    }
                }
                this.getHttpServletResponse().setStatus(404);
            }
            catch (IOException e) {
                this.sendError(500, "Internal Server Error", "Revocation cache error.");
            }
        }
    }

    private void doPost() throws IOException {
        boolean result;
        String value = this.getHttpServletRequest().getParameter("value");
        String duration = this.getHttpServletRequest().getParameter("duration");
        if (value == null) {
            this.sendError(400, "Bad Request", "Request missing value parameter.");
            return;
        }
        Duration durationSeconds = null;
        if (duration != null) {
            if (duration.startsWith("P")) {
                durationSeconds = DOMTypeSupport.stringToDuration((String)duration);
            } else {
                try {
                    durationSeconds = Duration.ofSeconds(Long.valueOf(duration));
                }
                catch (NumberFormatException e) {
                    this.sendError(400, "Bad Request", "Duration parameter was not a long integer.");
                    return;
                }
            }
        }
        if (result = durationSeconds != null ? this.revocationCache.revoke(this.context, this.key, value, durationSeconds) : this.revocationCache.revoke(this.context, this.key, value)) {
            this.getHttpServletResponse().setStatus(202);
        } else {
            this.sendError(500, "Internal Server Error", "Attempt to insert revocation record failed.");
        }
    }

    private void doDelete() throws IOException {
        if (this.revocationCache.unrevoke(this.context, this.key)) {
            this.getHttpServletResponse().setStatus(204);
        } else {
            this.getHttpServletResponse().setStatus(404);
        }
    }

    private void sendError(int status, @Nonnull @NotEmpty String title, @Nonnull @NotEmpty String detail) throws IOException {
        HttpServletResponse response = this.getHttpServletResponse();
        response.setContentType("application/json");
        response.setHeader("Cache-Control", "must-revalidate,no-cache,no-store");
        response.setStatus(status);
        Error e = new Error();
        Errors errors = new Errors();
        errors.setErrors(Collections.singletonList(e));
        e.setStatus(Integer.toString(status));
        e.setTitle(title);
        e.setDetail(detail);
        this.objectMapper.writer().withDefaultPrettyPrinter().writeValue((OutputStream)response.getOutputStream(), (Object)errors);
    }
}

