/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.spnego.impl;

import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.AbstractInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.net.CookieManager;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SPNEGOAutoLoginManager
extends AbstractInitializableComponent {
    @Nonnull
    @NotEmpty
    public static final String AUTOLOGIN_PARAMETER_NAME = "_shib_idp_SPNEGO_enable_autologin";
    @Nonnull
    @NotEmpty
    public static final String AUTOLOGIN_COOKIE_NAME = "_idp_spnego_autologin";
    @Nonnull
    @NotEmpty
    public static final String AUTOLOGIN_COOKIE_VALUE_TRUE = "1";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SPNEGOAutoLoginManager.class);
    @NonnullAfterInit
    private CookieManager cookieManager;
    @Nonnull
    @NotEmpty
    private String cookieName = "_idp_spnego_autologin";

    public void setCookieManager(@Nonnull CookieManager manager) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.cookieManager = (CookieManager)Constraint.isNotNull((Object)manager, (String)"CookieManager cannot be null");
    }

    @NonnullAfterInit
    public CookieManager getCookieManager() {
        return this.cookieManager;
    }

    public void setCookieName(@Nonnull @NotEmpty String name) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.cookieName = Constraint.isNotEmpty((String)StringSupport.trimOrNull((String)name), (String)"Cookie name cannot be null or empty");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.cookieManager == null) {
            throw new ComponentInitializationException("CookieManager cannot be null");
        }
    }

    public void enable() {
        this.cookieManager.addCookie(this.cookieName, AUTOLOGIN_COOKIE_VALUE_TRUE);
        this.log.debug("Auto-login has been enabled.");
    }

    public void disable() {
        this.cookieManager.unsetCookie(this.cookieName);
        this.log.debug("Auto-login has been disabled.");
    }

    public boolean isEnabled() {
        return this.cookieManager.cookieHasValue(this.cookieName, AUTOLOGIN_COOKIE_VALUE_TRUE);
    }

    public boolean isDisabled() {
        String value = this.getCookieManager().getCookieValue(this.cookieName, null);
        return value == null || !value.equals(AUTOLOGIN_COOKIE_VALUE_TRUE);
    }
}

