/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import java.security.Principal;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.Subject;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.impl.AbstractAuditingValidationAction;
import net.shibboleth.idp.authn.principal.UsernamePrincipal;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidateFunctionResult
extends AbstractAuditingValidationAction {
    @Nonnull
    @NotEmpty
    private static final String DEFAULT_METRIC_NAME = "net.shibboleth.idp.authn.function";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ValidateFunctionResult.class);
    @NonnullAfterInit
    private Function<ProfileRequestContext, ?> resultLookupStrategy;
    @Nullable
    private Object result;

    public ValidateFunctionResult() {
        this.setMetricName(DEFAULT_METRIC_NAME);
    }

    public void setResultLookupStrategy(@Nonnull Function<ProfileRequestContext, ?> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.resultLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Result lookup strategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.resultLookupStrategy == null) {
            throw new ComponentInitializationException("Result lookup strategy cannot be null");
        }
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        try {
            this.result = this.resultLookupStrategy.apply(profileRequestContext);
        }
        catch (Exception e) {
            this.log.info("{} Authentication by function failed with exception", (Object)this.getLogPrefix(), (Object)e);
            this.handleError(profileRequestContext, authenticationContext, e, "AuthenticationException");
            this.recordFailure(profileRequestContext);
            return;
        }
        if (this.result == null) {
            this.log.info("{} Authentication by function failed", (Object)this.getLogPrefix());
            this.handleError(profileRequestContext, authenticationContext, "NoCredentials", "NoCredentials");
            this.recordFailure(profileRequestContext);
        } else if (this.result instanceof String) {
            this.log.info("{} Validated user via name '{}'", (Object)this.getLogPrefix(), this.result);
            this.recordSuccess(profileRequestContext);
            this.buildAuthenticationResult(profileRequestContext, authenticationContext);
        } else if (this.result instanceof Principal) {
            this.log.info("{} Validated user via Principal '{}'", (Object)this.getLogPrefix(), this.result);
            this.recordSuccess(profileRequestContext);
            this.buildAuthenticationResult(profileRequestContext, authenticationContext);
        } else if (this.result instanceof Subject) {
            this.log.info("{} Validated user via Subject", (Object)this.getLogPrefix());
            this.recordSuccess(profileRequestContext);
            this.buildAuthenticationResult(profileRequestContext, authenticationContext);
        } else {
            this.log.info("{} Authentication by function failed, result type was invalid", (Object)this.getLogPrefix());
            this.handleError(profileRequestContext, authenticationContext, "InvalidCredentials", "InvalidCredentials");
            this.recordFailure(profileRequestContext);
        }
    }

    @Nonnull
    protected Subject populateSubject(@Nonnull Subject subject) {
        if (this.result instanceof String) {
            subject.getPrincipals().add((Principal)new UsernamePrincipal((String)this.result));
            return subject;
        }
        if (this.result instanceof Principal) {
            subject.getPrincipals().add((Principal)this.result);
            return subject;
        }
        if (this.result instanceof Subject) {
            ((Subject)this.result).getPrincipals().addAll(subject.getPrincipals());
            return (Subject)this.result;
        }
        throw new ConstraintViolationException("Result type was unexpected");
    }

    @Override
    @Nullable
    protected Map<String, String> getAuditFields(@Nonnull ProfileRequestContext profileRequestContext) {
        String name;
        if (this.result instanceof String) {
            return Collections.singletonMap("u", (String)this.result);
        }
        if (this.result instanceof UsernamePrincipal) {
            return Collections.singletonMap("u", ((UsernamePrincipal)this.result).getName());
        }
        if (this.result instanceof Subject && (name = this.getUsername((Subject)this.result)) != null) {
            return Collections.singletonMap("u", name);
        }
        return super.getAuditFields(profileRequestContext);
    }

    @Nullable
    private String getUsername(@Nonnull Subject subject) {
        Set<UsernamePrincipal> princs = subject.getPrincipals(UsernamePrincipal.class);
        if (princs != null && !princs.isEmpty()) {
            return princs.iterator().next().getName();
        }
        return null;
    }
}

