/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.context.impl;

import java.security.Principal;
import java.time.Instant;
import java.util.Collection;
import javax.security.auth.Subject;
import net.shibboleth.idp.authn.AuthenticationFlowDescriptor;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.RequestedPrincipalContext;
import net.shibboleth.idp.authn.principal.PrincipalEvalPredicateFactoryRegistry;
import net.shibboleth.idp.authn.testing.TestPrincipal;
import net.shibboleth.shared.collection.CollectionSupport;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test
public class AuthenticationContextTest {
    public void testInitiationInstant() throws Exception {
        Instant start = Instant.now();
        Thread.sleep(50L);
        AuthenticationContext ctx = new AuthenticationContext();
        Assert.assertTrue((boolean)ctx.getInitiationInstant().isAfter(start));
    }

    public void testForcingAuthentication() throws Exception {
        AuthenticationContext ctx = new AuthenticationContext();
        Assert.assertFalse((boolean)ctx.isForceAuthn());
        ctx.setForceAuthn(true);
        Assert.assertTrue((boolean)ctx.isForceAuthn());
    }

    public void testActiveResults() throws Exception {
        AuthenticationResult result = new AuthenticationResult("test", new Subject());
        AuthenticationContext ctx = new AuthenticationContext();
        Assert.assertTrue((boolean)ctx.getActiveResults().isEmpty());
        ctx.setActiveResults((Iterable)CollectionSupport.singletonList((Object)result));
        Assert.assertEquals((int)ctx.getActiveResults().size(), (int)1);
        Assert.assertEquals(ctx.getActiveResults().get("test"), (Object)result);
    }

    public void testPotentialFlows() throws Exception {
        AuthenticationContext ctx = new AuthenticationContext();
        Assert.assertTrue((boolean)ctx.getPotentialFlows().isEmpty());
        AuthenticationFlowDescriptor descriptor = new AuthenticationFlowDescriptor();
        descriptor.setId("test");
        ctx = new AuthenticationContext();
        ctx.getPotentialFlows().put(descriptor.getId(), descriptor);
        Assert.assertEquals((int)ctx.getPotentialFlows().size(), (int)1);
        Assert.assertEquals(ctx.getPotentialFlows().get("test"), (Object)descriptor);
    }

    public void testAttemptedFlow() throws Exception {
        AuthenticationContext ctx = new AuthenticationContext();
        Assert.assertNull((Object)ctx.getAttemptedFlow());
        AuthenticationFlowDescriptor descriptor = new AuthenticationFlowDescriptor();
        descriptor.setId("test");
        ctx.setAttemptedFlow(descriptor);
        Assert.assertEquals((Object)ctx.getAttemptedFlow(), (Object)descriptor);
    }

    public void testCompletionInstant() throws Exception {
        AuthenticationContext ctx = new AuthenticationContext();
        Assert.assertNull((Object)ctx.getCompletionInstant());
        Instant now = Instant.now();
        Thread.sleep(50L);
        ctx.setCompletionInstant();
        Instant completion = ctx.getCompletionInstant();
        assert (completion != null && completion.isAfter(now));
    }

    public void testRequestedPrincipalContextHelpers() throws Exception {
        AuthenticationContext ctx = new AuthenticationContext();
        ctx.setPrincipalEvalPredicateFactoryRegistry(new PrincipalEvalPredicateFactoryRegistry());
        ctx.addRequestedPrincipalContext("foo", (Principal)new TestPrincipal("bar"), false);
        RequestedPrincipalContext rpCtx = (RequestedPrincipalContext)ctx.getSubcontext(RequestedPrincipalContext.class);
        assert (rpCtx != null);
        Assert.assertEquals((String)rpCtx.getOperator(), (String)"foo");
        Assert.assertEquals((Collection)rpCtx.getRequestedPrincipals(), (Collection)CollectionSupport.singletonList((Object)new TestPrincipal("bar")));
        Assert.assertFalse((boolean)ctx.addRequestedPrincipalContext("foo", (Principal)new TestPrincipal("bar"), false));
        ctx.addRequestedPrincipalContext("fob", TestPrincipal.class.getName(), "baz", true);
        rpCtx = (RequestedPrincipalContext)ctx.getSubcontext(RequestedPrincipalContext.class);
        assert (rpCtx != null);
        Assert.assertEquals((String)rpCtx.getOperator(), (String)"fob");
        Assert.assertEquals((Collection)rpCtx.getRequestedPrincipals(), (Collection)CollectionSupport.singletonList((Object)new TestPrincipal("baz")));
        ctx.addRequestedPrincipalContext("fog", TestPrincipal.class.getName(), (Collection)CollectionSupport.listOf((Object)"baf", (Object)"bag"), true);
        rpCtx = (RequestedPrincipalContext)ctx.getSubcontext(RequestedPrincipalContext.class);
        assert (rpCtx != null);
        Assert.assertEquals((String)rpCtx.getOperator(), (String)"fog");
        Assert.assertEquals((int)rpCtx.getRequestedPrincipals().size(), (int)2);
    }

    @Test(expectedExceptions={ClassCastException.class})
    public void testRequestedPrincipalContextHelperBadType() throws Exception {
        AuthenticationContext ctx = new AuthenticationContext();
        ctx.setPrincipalEvalPredicateFactoryRegistry(new PrincipalEvalPredicateFactoryRegistry());
        ctx.addRequestedPrincipalContext("fob", AuthenticationContext.class.getName(), "baz", false);
    }
}

