/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.context.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nonnull;
import net.shibboleth.idp.attribute.resolver.AttributeDefinition;
import net.shibboleth.idp.attribute.resolver.DataConnector;
import net.shibboleth.idp.attribute.resolver.impl.AttributeResolverImpl;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.spring.config.IdentifiableBeanPostProcessor;
import net.shibboleth.shared.spring.config.StringToDurationConverter;
import net.shibboleth.shared.spring.config.StringToIPRangeConverter;
import net.shibboleth.shared.spring.config.StringToResourceConverter;
import net.shibboleth.shared.spring.context.FilesystemGenericApplicationContext;
import net.shibboleth.shared.spring.custom.SchemaTypeAwareXMLBeanDefinitionReader;
import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ConversionServiceFactoryBean;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.convert.converter.Converter;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;

public abstract class BaseAttributeDefinitionParserTest
extends OpenSAMLInitBaseTestCase {
    public static final String BEAN_FILE_PATH = "net/shibboleth/idp/attribute/resolver/spring/";
    public static final String ATTRIBUTE_FILE_PATH = "net/shibboleth/idp/attribute/resolver/spring/ad/";
    public static final String DATACONNECTOR_FILE_PATH = "net/shibboleth/idp/attribute/resolver/spring/dc/";
    public static final String ENCODER_FILE_PATH = "net/shibboleth/idp/attribute/resolver/spring/enc/";
    public static final String PRINCIPALCONNECTOR_FILE_PATH = "net/shibboleth/idp/attribute/resolver/spring/pc/";
    protected GenericApplicationContext pendingTeardownContext = null;

    @AfterMethod
    public void tearDownTestContext() {
        if (null == this.pendingTeardownContext) {
            return;
        }
        this.pendingTeardownContext.close();
        this.pendingTeardownContext = null;
    }

    protected void setTestContext(GenericApplicationContext context) {
        this.tearDownTestContext();
        this.pendingTeardownContext = context;
    }

    private void loadFile(String fileName, GenericApplicationContext context, boolean supressValid) {
        SchemaTypeAwareXMLBeanDefinitionReader beanDefinitionReader = new SchemaTypeAwareXMLBeanDefinitionReader((BeanDefinitionRegistry)context);
        if (supressValid) {
            beanDefinitionReader.setValidating(false);
        }
        beanDefinitionReader.loadBeanDefinitions(new String[]{fileName, "net/shibboleth/idp/attribute/resolver/spring/customBean.xml"});
    }

    protected void loadFile(String fileName, GenericApplicationContext context) {
        this.loadFile(fileName, context, false);
    }

    @Nonnull
    protected <Type> Type getBean(String fileName, Class<Type> claz, GenericApplicationContext context, boolean supressValid) {
        ConversionServiceFactoryBean service = new ConversionServiceFactoryBean();
        service.setConverters(new HashSet<Converter>(Arrays.asList(new StringToIPRangeConverter(), new StringToResourceConverter(), new StringToDurationConverter())));
        service.afterPropertiesSet();
        context.getBeanFactory().setConversionService(service.getObject());
        this.loadFile(fileName, context, supressValid);
        context.refresh();
        Collection beans = context.getBeansOfType(claz).values();
        Assert.assertEquals((int)beans.size(), (int)1);
        Object result = beans.iterator().next();
        assert (result != null);
        return (Type)result;
    }

    @Nonnull
    protected <Type> Type getBean(String fileName, Class<Type> claz, GenericApplicationContext context) {
        return this.getBean(fileName, claz, context, false);
    }

    @Nonnull
    protected <Type extends AttributeDefinition> Type getAttributeDefn(String fileName, Class<Type> claz, GenericApplicationContext context) {
        return (Type)((AttributeDefinition)this.getBean(ATTRIBUTE_FILE_PATH + fileName, claz, context));
    }

    @Nonnull
    private <Type extends AttributeDefinition> Type getAttributeDefn(String fileName, Class<Type> claz, GenericApplicationContext context, boolean supressValidation) {
        return (Type)((AttributeDefinition)this.getBean(ATTRIBUTE_FILE_PATH + fileName, claz, context, supressValidation));
    }

    @Nonnull
    protected <Type extends AttributeDefinition> Type getAttributeDefn(String fileName, String beanFileName, Class<Type> claz) {
        return this.getAttributeDefn(fileName, beanFileName, claz, false);
    }

    @Nonnull
    private <Type extends AttributeDefinition> Type getAttributeDefn(String fileName, String beanFileName, Class<Type> claz, boolean supressValidation) {
        GenericApplicationContext context = new GenericApplicationContext();
        this.setTestContext(context);
        context.setDisplayName("ApplicationContext: " + claz);
        SchemaTypeAwareXMLBeanDefinitionReader configReader = new SchemaTypeAwareXMLBeanDefinitionReader((BeanDefinitionRegistry)context);
        ConversionServiceFactoryBean service = new ConversionServiceFactoryBean();
        service.setConverters(new HashSet<Converter>(Arrays.asList(new StringToIPRangeConverter(), new StringToResourceConverter(), new StringToDurationConverter())));
        service.afterPropertiesSet();
        context.getBeanFactory().setConversionService(service.getObject());
        configReader.loadBeanDefinitions(BEAN_FILE_PATH + beanFileName);
        return this.getAttributeDefn(fileName, claz, context, supressValidation);
    }

    @Nonnull
    protected <Type extends AttributeDefinition> Type getAttributeDefn(String fileName, Class<Type> claz) {
        return this.getAttributeDefn(fileName, claz, false);
    }

    @Nonnull
    protected <Type extends AttributeDefinition> Type getAttributeDefn(String fileName, Class<Type> claz, boolean supressValid) {
        FilesystemGenericApplicationContext context = new FilesystemGenericApplicationContext();
        this.setTestContext((GenericApplicationContext)context);
        context.setDisplayName("ApplicationContext: " + claz);
        return this.getAttributeDefn(fileName, claz, (GenericApplicationContext)context, supressValid);
    }

    @Nonnull
    protected <Type extends DataConnector> Type getDataConnector(String fileName, Class<Type> claz) {
        return this.getDataConnector(fileName, claz, false);
    }

    @Nonnull
    private <Type extends DataConnector> Type getDataConnector(String fileName, Class<Type> claz, boolean supressValid) {
        GenericApplicationContext context = new GenericApplicationContext();
        context.getBeanFactory().addBeanPostProcessor((BeanPostProcessor)new IdentifiableBeanPostProcessor());
        this.setTestContext(context);
        context.setDisplayName("ApplicationContext: " + claz);
        return (Type)((DataConnector)this.getBean(DATACONNECTOR_FILE_PATH + fileName, claz, context, supressValid));
    }

    @Nonnull
    public static AttributeResolverImpl getResolver(ApplicationContext appContext) throws ComponentInitializationException {
        Map attributesMap = appContext.getBeansOfType(AttributeDefinition.class);
        Collection definitions = attributesMap.values();
        Map dataConnectorsMap = appContext.getBeansOfType(DataConnector.class);
        Collection connectors = dataConnectorsMap.values();
        assert (connectors != null && definitions != null);
        AttributeResolverImpl resolver = new AttributeResolverImpl();
        resolver.setAttributeDefinitions(definitions);
        resolver.setDataConnectors(connectors);
        resolver.setId("testResolver");
        resolver.initialize();
        return resolver;
    }
}

