/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.context.impl;

import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.security.auth.Subject;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.ad.impl.ContextDerivedAttributeDefinition;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.testing.TestSources;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.idp.authn.context.SubjectCanonicalizationContext;
import net.shibboleth.idp.authn.context.SubjectContext;
import net.shibboleth.idp.authn.context.impl.BaseAttributeDefinitionParserTest;
import net.shibboleth.idp.authn.principal.IdPAttributePrincipal;
import net.shibboleth.idp.saml.authn.principal.AuthenticationMethodPrincipal;
import org.opensaml.messaging.context.BaseContext;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ContextDerivedAttributeDefinitionParserTest
extends BaseAttributeDefinitionParserTest {
    @Nonnull
    private static final String SIMPLE_VALUE = "simple";

    @Nonnull
    private AttributeResolutionContext getCtx(@Nonnull String attributeName, boolean c14n) {
        ArrayList<StringAttributeValue> list = new ArrayList<StringAttributeValue>(2);
        list.add(new StringAttributeValue(SIMPLE_VALUE));
        list.add(new StringAttributeValue("simple2"));
        IdPAttribute attr = new IdPAttribute(attributeName);
        attr.setValues(list);
        AttributeResolutionContext ctx = TestSources.createResolutionContext((String)"PETER_THE_PRINCIPAL", (String)"https://idp.example.org/idp", (String)"https://sp.example.org/sp");
        Subject subject = new Subject();
        subject.getPrincipals().add((Principal)new IdPAttributePrincipal(attr));
        subject.getPrincipals().add((Principal)new AuthenticationMethodPrincipal("simple2"));
        BaseContext parent = ctx.getParent();
        assert (parent != null);
        if (c14n) {
            ((SubjectCanonicalizationContext)parent.ensureSubcontext(SubjectCanonicalizationContext.class)).setSubject(subject);
        } else {
            SubjectContext sc = (SubjectContext)parent.ensureSubcontext(SubjectContext.class);
            Map authnResults = sc.getAuthenticationResults();
            authnResults.put("one", new AuthenticationResult("1", subject));
        }
        return ctx;
    }

    @Test
    public void resolverSubject() throws ResolutionException {
        ContextDerivedAttributeDefinition attrDef = this.getAttributeDefn("subjectDerived.xml", ContextDerivedAttributeDefinition.class);
        IdPAttribute attr = (IdPAttribute)attrDef.resolve(this.getCtx("Whatever", false));
        assert (attr != null);
        List foo = attr.getValues();
        Assert.assertEquals((int)2, (int)foo.size());
        Assert.assertTrue((boolean)foo.contains(new StringAttributeValue(SIMPLE_VALUE)));
        Assert.assertTrue((boolean)foo.contains(new StringAttributeValue("simple2")));
    }

    @Test
    public void resolverSubjectViaC14N() throws ResolutionException {
        ContextDerivedAttributeDefinition attrDef = this.getAttributeDefn("subjectDerivedViaC14N.xml", ContextDerivedAttributeDefinition.class);
        IdPAttribute attr = (IdPAttribute)attrDef.resolve(this.getCtx("Whatever", true));
        assert (attr != null);
        List foo = attr.getValues();
        Assert.assertEquals((int)2, (int)foo.size());
        Assert.assertTrue((boolean)foo.contains(new StringAttributeValue(SIMPLE_VALUE)));
        Assert.assertTrue((boolean)foo.contains(new StringAttributeValue("simple2")));
    }

    @Test
    public void complex() throws ResolutionException {
        ContextDerivedAttributeDefinition attrDef = this.getAttributeDefn("subjectDerivedComplex.xml", "contextDerivedBeans.xml", ContextDerivedAttributeDefinition.class);
        assert (attrDef != null);
        IdPAttribute attr = (IdPAttribute)attrDef.resolve(this.getCtx("BeanWhatever", false));
        assert (attr != null);
        List foo = attr.getValues();
        Assert.assertEquals((int)2, (int)foo.size());
        Assert.assertTrue((boolean)foo.contains(new StringAttributeValue(SIMPLE_VALUE)));
        Assert.assertTrue((boolean)foo.contains(new StringAttributeValue("simple2")));
    }

    @Test
    public void context() throws ResolutionException {
        ContextDerivedAttributeDefinition attrDef = this.getAttributeDefn("contextDerived.xml", "contextDerivedBeans.xml", ContextDerivedAttributeDefinition.class);
        assert (attrDef != null);
        IdPAttribute attr = (IdPAttribute)attrDef.resolve(this.getCtx("BeanWhatever", false));
        assert (attr != null);
        List foo = attr.getValues();
        Assert.assertEquals((int)2, (int)foo.size());
        Assert.assertTrue((boolean)foo.contains(new StringAttributeValue(SIMPLE_VALUE)));
        Assert.assertTrue((boolean)foo.contains(new StringAttributeValue("simple2")));
    }

    @Test
    public void warn() throws ResolutionException {
        ContextDerivedAttributeDefinition attrDef = this.getAttributeDefn("subjectDerivedWarn.xml", ContextDerivedAttributeDefinition.class);
        IdPAttribute attr = (IdPAttribute)attrDef.resolve(this.getCtx("Whatever", false));
        assert (attr != null);
        List foo = attr.getValues();
        Assert.assertEquals((int)2, (int)foo.size());
        Assert.assertTrue((boolean)foo.contains(new StringAttributeValue(SIMPLE_VALUE)));
        Assert.assertTrue((boolean)foo.contains(new StringAttributeValue("simple2")));
    }

    @Test(expectedExceptions={BeanDefinitionStoreException.class})
    public void fail() throws ResolutionException {
        this.getAttributeDefn("subjectDerivedFail.xml", ContextDerivedAttributeDefinition.class);
    }

    @Test(expectedExceptions={BeanDefinitionStoreException.class})
    public void dependency() throws ResolutionException {
        this.getAttributeDefn("subjectDerivedDependency.xml", ContextDerivedAttributeDefinition.class);
    }
}

