/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.context.impl;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.security.auth.Subject;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.dc.impl.ContextDerivedDataConnector;
import net.shibboleth.idp.attribute.resolver.testing.TestSources;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.idp.authn.context.SubjectCanonicalizationContext;
import net.shibboleth.idp.authn.context.SubjectContext;
import net.shibboleth.idp.authn.context.impl.SubjectDerivedAttributesFunction;
import net.shibboleth.idp.authn.principal.IdPAttributePrincipal;
import net.shibboleth.idp.saml.authn.principal.AuthenticationMethodPrincipal;
import net.shibboleth.shared.component.ComponentInitializationException;
import org.opensaml.messaging.context.BaseContext;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SubjectDataConnectorTest {
    @Nonnull
    private static final String SIMPLE_VALUE = "simple";

    @Test
    public void simpleValue() throws ComponentInitializationException, ResolutionException {
        ArrayList<StringAttributeValue> list = new ArrayList<StringAttributeValue>(2);
        list.add(new StringAttributeValue(SIMPLE_VALUE));
        list.add(new StringAttributeValue("simple2"));
        IdPAttribute attr = new IdPAttribute("wibble");
        attr.setValues(list);
        SubjectDerivedAttributesFunction fn = new SubjectDerivedAttributesFunction();
        fn.setId("test");
        fn.initialize();
        ContextDerivedDataConnector defn = new ContextDerivedDataConnector();
        defn.setAttributesFunction((Function)fn);
        defn.setId("pDAD");
        defn.initialize();
        AttributeResolutionContext ctx = TestSources.createResolutionContext((String)"PETER_THE_PRINCIPAL", (String)"https://idp.example.org/idp", (String)"https://sp.example.org/sp");
        BaseContext parent = ctx.getParent();
        assert (parent != null);
        SubjectContext sc = (SubjectContext)parent.ensureSubcontext(SubjectContext.class);
        Map authnResults = sc.getAuthenticationResults();
        Subject subject = new Subject();
        subject.getPrincipals().add((Principal)new IdPAttributePrincipal(attr));
        subject.getPrincipals().add((Principal)new AuthenticationMethodPrincipal("simple2"));
        authnResults.put("one", new AuthenticationResult("1", subject));
        Map results = (Map)defn.resolve(ctx);
        assert (results != null && results.size() == 1);
        IdPAttribute copy = (IdPAttribute)results.get("wibble");
        Assert.assertEquals((int)copy.getValues().size(), (int)2);
        Assert.assertTrue((boolean)copy.getValues().contains(new StringAttributeValue(SIMPLE_VALUE)));
        Assert.assertTrue((boolean)copy.getValues().contains(new StringAttributeValue("simple2")));
    }

    @Test
    public void simpleValueViaC14N() throws ComponentInitializationException, ResolutionException {
        ArrayList<StringAttributeValue> list = new ArrayList<StringAttributeValue>(2);
        list.add(new StringAttributeValue(SIMPLE_VALUE));
        list.add(new StringAttributeValue("simple2"));
        IdPAttribute attr = new IdPAttribute("wibble");
        attr.setValues(list);
        SubjectDerivedAttributesFunction fn = new SubjectDerivedAttributesFunction();
        fn.setId("test");
        fn.setForCanonicalization(true);
        fn.initialize();
        ContextDerivedDataConnector defn = new ContextDerivedDataConnector();
        defn.setId("pDAD");
        defn.setAttributesFunction((Function)fn);
        defn.initialize();
        AttributeResolutionContext ctx = TestSources.createResolutionContext((String)"PETER_THE_PRINCIPAL", (String)"https://idp.example.org/idp", (String)"https://sp.example.org/sp");
        BaseContext parent = ctx.getParent();
        assert (parent != null);
        SubjectCanonicalizationContext sc = (SubjectCanonicalizationContext)parent.ensureSubcontext(SubjectCanonicalizationContext.class);
        Subject subject = new Subject();
        subject.getPrincipals().add((Principal)new IdPAttributePrincipal(attr));
        subject.getPrincipals().add((Principal)new AuthenticationMethodPrincipal("simple2"));
        sc.setSubject(subject);
        Map results = (Map)defn.resolve(ctx);
        assert (results != null && results.size() == 1);
        IdPAttribute copy = (IdPAttribute)results.get("wibble");
        Assert.assertEquals((int)copy.getValues().size(), (int)2);
        Assert.assertTrue((boolean)copy.getValues().contains(new StringAttributeValue(SIMPLE_VALUE)));
        Assert.assertTrue((boolean)copy.getValues().contains(new StringAttributeValue("simple2")));
    }

    @Test
    public void emptyOk() throws ComponentInitializationException, ResolutionException {
        SubjectDerivedAttributesFunction fn = new SubjectDerivedAttributesFunction();
        fn.setId("test");
        fn.setForCanonicalization(true);
        fn.initialize();
        ContextDerivedDataConnector defn = new ContextDerivedDataConnector();
        defn.setId("pDAD");
        defn.setAttributesFunction((Function)fn);
        defn.initialize();
        AttributeResolutionContext ctx = TestSources.createResolutionContext((String)"PETER_THE_PRINCIPAL", (String)"https://idp.example.org/idp", (String)"https://sp.example.org/sp");
        BaseContext parent = ctx.getParent();
        assert (parent != null);
        SubjectContext sc = (SubjectContext)parent.ensureSubcontext(SubjectContext.class);
        Map authnResults = sc.getAuthenticationResults();
        Subject subject = new Subject();
        subject.getPrincipals().add((Principal)new AuthenticationMethodPrincipal("simple2"));
        authnResults.put("one", new AuthenticationResult("1", subject));
        Map results = (Map)defn.resolve(ctx);
        Assert.assertNull((Object)results);
    }

    @Test(expectedExceptions={ResolutionException.class})
    public void emptyError() throws ComponentInitializationException, ResolutionException {
        SubjectDerivedAttributesFunction fn = new SubjectDerivedAttributesFunction();
        fn.setId("test");
        fn.initialize();
        ContextDerivedDataConnector defn = new ContextDerivedDataConnector();
        defn.setId("pDAD");
        defn.setNoResultIsError(true);
        defn.setAttributesFunction((Function)fn);
        defn.initialize();
        AttributeResolutionContext ctx = TestSources.createResolutionContext((String)"PETER_THE_PRINCIPAL", (String)"https://idp.example.org/idp", (String)"https://sp.example.org/sp");
        BaseContext parent = ctx.getParent();
        assert (parent != null);
        SubjectContext sc = (SubjectContext)parent.ensureSubcontext(SubjectContext.class);
        Map authnResults = sc.getAuthenticationResults();
        Subject subject = new Subject();
        subject.getPrincipals().add((Principal)new AuthenticationMethodPrincipal("simple2"));
        authnResults.put("one", new AuthenticationResult("1", subject));
        defn.resolve(ctx);
    }
}

