/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.context.impl;

import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.security.auth.Subject;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.ad.impl.ContextDerivedAttributeDefinition;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.testing.TestSources;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.idp.authn.context.SubjectCanonicalizationContext;
import net.shibboleth.idp.authn.context.SubjectContext;
import net.shibboleth.idp.authn.context.impl.IdPAttributePrincipalValuesFunction;
import net.shibboleth.idp.authn.context.impl.SubjectDerivedAttributeValuesFunction;
import net.shibboleth.idp.authn.principal.IdPAttributePrincipal;
import net.shibboleth.idp.saml.authn.principal.AuthenticationMethodPrincipal;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.FunctionSupport;
import org.opensaml.messaging.context.BaseContext;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SubjectDerivedAttributeValuesFunctionTest {
    private static final String SIMPLE_VALUE = "simple";

    @Nonnull
    private List<IdPAttributeValue> doResolve(@Nonnull ContextDerivedAttributeDefinition defn, @Nonnull AttributeResolutionContext ctx) throws ResolutionException {
        IdPAttribute attr = (IdPAttribute)defn.resolve(ctx);
        assert (attr != null);
        return attr.getValues();
    }

    @Test
    public void noSubjectContext() throws ComponentInitializationException, ResolutionException {
        SubjectDerivedAttributeValuesFunction ctxValueFunction = new SubjectDerivedAttributeValuesFunction();
        ctxValueFunction.setId("pDaD");
        IdPAttributePrincipalValuesFunction fn = new IdPAttributePrincipalValuesFunction();
        fn.setAttributeName("wibble");
        fn.doInitialize();
        ctxValueFunction.setAttributeValuesFunction((Function)fn);
        ctxValueFunction.initialize();
        ContextDerivedAttributeDefinition defn = new ContextDerivedAttributeDefinition();
        defn.setAttributeValuesFunction((Function)ctxValueFunction);
        defn.setId("pDAD");
        defn.initialize();
        AttributeResolutionContext ctx = TestSources.createResolutionContext((String)"PETER_THE_PRINCIPAL", (String)"https://idp.example.org/idp", (String)"https://sp.example.org/sp");
        IdPAttribute result = (IdPAttribute)defn.resolve(ctx);
        Assert.assertNull((Object)result);
    }

    @Test
    public void simpleValue() throws ComponentInitializationException, ResolutionException {
        ArrayList<StringAttributeValue> list = new ArrayList<StringAttributeValue>(2);
        list.add(new StringAttributeValue(SIMPLE_VALUE));
        list.add(new StringAttributeValue("simple2"));
        IdPAttribute attr = new IdPAttribute("wibble");
        attr.setValues(list);
        SubjectDerivedAttributeValuesFunction ctxValueFunction = new SubjectDerivedAttributeValuesFunction();
        ctxValueFunction.setId("pDaD");
        IdPAttributePrincipalValuesFunction fn = new IdPAttributePrincipalValuesFunction();
        fn.setAttributeName("wibble");
        fn.doInitialize();
        ctxValueFunction.setAttributeValuesFunction((Function)fn);
        ctxValueFunction.initialize();
        ContextDerivedAttributeDefinition defn = new ContextDerivedAttributeDefinition();
        defn.setAttributeValuesFunction((Function)ctxValueFunction);
        defn.setId("pDAD");
        defn.initialize();
        AttributeResolutionContext ctx = TestSources.createResolutionContext((String)"PETER_THE_PRINCIPAL", (String)"https://idp.example.org/idp", (String)"https://sp.example.org/sp");
        BaseContext parent = ctx.getParent();
        assert (parent != null);
        SubjectContext sc = (SubjectContext)parent.ensureSubcontext(SubjectContext.class);
        Map authnResults = sc.getAuthenticationResults();
        Subject subject = new Subject();
        subject.getPrincipals().add((Principal)new IdPAttributePrincipal(attr));
        subject.getPrincipals().add((Principal)new AuthenticationMethodPrincipal("simple2"));
        authnResults.put("one", new AuthenticationResult("1", subject));
        List<IdPAttributeValue> foo = this.doResolve(defn, ctx);
        Assert.assertEquals((int)2, (int)foo.size());
        Assert.assertTrue((boolean)foo.contains(new StringAttributeValue(SIMPLE_VALUE)));
        Assert.assertTrue((boolean)foo.contains(new StringAttributeValue("simple2")));
    }

    @Test
    public void simpleValueViaSubject() throws ComponentInitializationException, ResolutionException {
        ArrayList<StringAttributeValue> list = new ArrayList<StringAttributeValue>(2);
        list.add(new StringAttributeValue(SIMPLE_VALUE));
        list.add(new StringAttributeValue("simple2"));
        IdPAttribute attr = new IdPAttribute("wibble");
        attr.setValues(list);
        Subject subject = new Subject();
        subject.getPrincipals().add((Principal)new IdPAttributePrincipal(attr));
        subject.getPrincipals().add((Principal)new AuthenticationMethodPrincipal("simple2"));
        SubjectDerivedAttributeValuesFunction ctxValueFunction = new SubjectDerivedAttributeValuesFunction();
        ctxValueFunction.setId("pDaD");
        ctxValueFunction.setSubjectLookupStrategy(FunctionSupport.constant((Object)subject));
        IdPAttributePrincipalValuesFunction fn = new IdPAttributePrincipalValuesFunction();
        fn.setAttributeName("wibble");
        fn.doInitialize();
        ctxValueFunction.setAttributeValuesFunction((Function)fn);
        ctxValueFunction.initialize();
        ContextDerivedAttributeDefinition defn = new ContextDerivedAttributeDefinition();
        defn.setAttributeValuesFunction((Function)ctxValueFunction);
        defn.setId("pDAD");
        defn.initialize();
        AttributeResolutionContext ctx = TestSources.createResolutionContext((String)"PETER_THE_PRINCIPAL", (String)"https://idp.example.org/idp", (String)"https://sp.example.org/sp");
        List<IdPAttributeValue> foo = this.doResolve(defn, ctx);
        Assert.assertEquals((int)2, (int)foo.size());
        Assert.assertTrue((boolean)foo.contains(new StringAttributeValue(SIMPLE_VALUE)));
        Assert.assertTrue((boolean)foo.contains(new StringAttributeValue("simple2")));
    }

    @Test
    public void simpleValueViaSubjectC14N() throws ComponentInitializationException, ResolutionException {
        ArrayList<StringAttributeValue> list = new ArrayList<StringAttributeValue>(2);
        list.add(new StringAttributeValue(SIMPLE_VALUE));
        list.add(new StringAttributeValue("simple2"));
        IdPAttribute attr = new IdPAttribute("wibble");
        attr.setValues(list);
        Subject subject = new Subject();
        subject.getPrincipals().add((Principal)new IdPAttributePrincipal(attr));
        subject.getPrincipals().add((Principal)new AuthenticationMethodPrincipal("simple2"));
        SubjectDerivedAttributeValuesFunction ctxValueFunction = new SubjectDerivedAttributeValuesFunction();
        ctxValueFunction.setId("pDaD");
        ctxValueFunction.setForCanonicalization(true);
        IdPAttributePrincipalValuesFunction fn = new IdPAttributePrincipalValuesFunction();
        fn.setAttributeName("wibble");
        fn.doInitialize();
        ctxValueFunction.setAttributeValuesFunction((Function)fn);
        ctxValueFunction.initialize();
        ContextDerivedAttributeDefinition defn = new ContextDerivedAttributeDefinition();
        defn.setAttributeValuesFunction((Function)ctxValueFunction);
        defn.setId("pDAD");
        defn.initialize();
        AttributeResolutionContext ctx = TestSources.createResolutionContext((String)"PETER_THE_PRINCIPAL", (String)"https://idp.example.org/idp", (String)"https://sp.example.org/sp");
        BaseContext parent = ctx.getParent();
        assert (parent != null);
        SubjectCanonicalizationContext sc = (SubjectCanonicalizationContext)parent.ensureSubcontext(SubjectCanonicalizationContext.class);
        sc.setSubject(subject);
        List<IdPAttributeValue> foo = this.doResolve(defn, ctx);
        Assert.assertEquals((int)2, (int)foo.size());
        Assert.assertTrue((boolean)foo.contains(new StringAttributeValue(SIMPLE_VALUE)));
        Assert.assertTrue((boolean)foo.contains(new StringAttributeValue("simple2")));
    }

    @Test
    public void empty() throws ComponentInitializationException, ResolutionException {
        List list = CollectionSupport.emptyList();
        IdPAttribute attr = new IdPAttribute("wibble");
        attr.setValues(list);
        SubjectDerivedAttributeValuesFunction ctxValueFunction = new SubjectDerivedAttributeValuesFunction();
        ctxValueFunction.setId("pDaD");
        IdPAttributePrincipalValuesFunction fn = new IdPAttributePrincipalValuesFunction();
        fn.setAttributeName("wibble");
        fn.doInitialize();
        ctxValueFunction.setAttributeValuesFunction((Function)fn);
        ctxValueFunction.initialize();
        ContextDerivedAttributeDefinition defn = new ContextDerivedAttributeDefinition();
        defn.setAttributeValuesFunction((Function)ctxValueFunction);
        defn.setId("pDAD");
        defn.initialize();
        AttributeResolutionContext ctx = TestSources.createResolutionContext((String)"PETER_THE_PRINCIPAL", (String)"https://idp.example.org/idp", (String)"https://sp.example.org/sp");
        BaseContext parent = ctx.getParent();
        assert (parent != null);
        SubjectContext sc = (SubjectContext)parent.ensureSubcontext(SubjectContext.class);
        Map authnResults = sc.getAuthenticationResults();
        Subject subject = new Subject();
        subject.getPrincipals().add((Principal)new IdPAttributePrincipal(attr));
        subject.getPrincipals().add((Principal)new AuthenticationMethodPrincipal("simple2"));
        authnResults.put("one", new AuthenticationResult("1", subject));
        IdPAttribute result = (IdPAttribute)defn.resolve(ctx);
        Assert.assertNull((Object)result);
    }
}

