/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import java.security.Principal;
import java.util.Collection;
import javax.security.auth.Subject;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.ScopedStringAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.context.AttributeContext;
import net.shibboleth.idp.authn.context.SubjectCanonicalizationContext;
import net.shibboleth.idp.authn.impl.AttributeSourcedSubjectCanonicalization;
import net.shibboleth.idp.authn.impl.testing.BaseAuthenticationContextTest;
import net.shibboleth.idp.authn.principal.IdPAttributePrincipal;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import org.springframework.webflow.execution.Event;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AttributeSourcedSubjectCanonicalizationTest
extends BaseAuthenticationContextTest {
    private AttributeSourcedSubjectCanonicalization action;

    @Override
    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        super.setUp();
        this.action = new AttributeSourcedSubjectCanonicalization();
        this.action.setAttributeSourceIds(CollectionSupport.listOf((Object)"attr1", (Object)"attr2"));
    }

    @Test(expectedExceptions={ComponentInitializationException.class})
    public void testNoSources() throws ComponentInitializationException {
        this.action = new AttributeSourcedSubjectCanonicalization();
        this.action.initialize();
    }

    @Test
    public void testNoContext() throws ComponentInitializationException {
        this.action.initialize();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidSubjectCanonicalizationContext");
    }

    @Test
    public void testNoAttributes() throws ComponentInitializationException {
        this.action.initialize();
        Subject subject = new Subject();
        ((SubjectCanonicalizationContext)this.prc.ensureSubcontext(SubjectCanonicalizationContext.class)).setSubject(subject);
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidSubject");
        SubjectCanonicalizationContext scc = (SubjectCanonicalizationContext)this.prc.getSubcontext(SubjectCanonicalizationContext.class);
        assert (scc != null && scc.getException() != null);
    }

    @Test
    public void testNoSubjectSourcedAttributes() throws ComponentInitializationException {
        this.action.setResolveFromSubject(true);
        this.action.initialize();
        Subject subject = new Subject();
        ((SubjectCanonicalizationContext)this.prc.ensureSubcontext(SubjectCanonicalizationContext.class)).setSubject(subject);
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidSubject");
        SubjectCanonicalizationContext scc = (SubjectCanonicalizationContext)this.prc.getSubcontext(SubjectCanonicalizationContext.class);
        assert (scc != null && scc.getException() != null);
    }

    @Test
    public void testSuccess() throws ComponentInitializationException {
        this.action.initialize();
        IdPAttribute inputAttribute = new IdPAttribute("attr2");
        inputAttribute.setValues(CollectionSupport.singletonList((Object)new StringAttributeValue("foo")));
        SubjectCanonicalizationContext sc = (SubjectCanonicalizationContext)this.prc.ensureSubcontext(SubjectCanonicalizationContext.class);
        sc.setSubject(new Subject());
        ((AttributeContext)sc.ensureSubcontext(AttributeContext.class)).setIdPAttributes((Collection)CollectionSupport.singleton((Object)inputAttribute));
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertEquals((String)sc.getPrincipalName(), (String)"foo");
    }

    @Test
    public void testSubjectSourcedSuccess() throws ComponentInitializationException {
        this.action.setResolveFromSubject(true);
        this.action.initialize();
        IdPAttribute inputAttribute = new IdPAttribute("attr2");
        inputAttribute.setValues(CollectionSupport.singletonList((Object)new StringAttributeValue("foo")));
        SubjectCanonicalizationContext sc = (SubjectCanonicalizationContext)this.prc.ensureSubcontext(SubjectCanonicalizationContext.class);
        Subject subject = new Subject();
        sc.setSubject(subject);
        subject.getPrincipals().add((Principal)new IdPAttributePrincipal(inputAttribute));
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertEquals((String)sc.getPrincipalName(), (String)"foo");
    }

    @Test
    public void testSubjectSourcedScopedSuccess() throws ComponentInitializationException {
        this.action.setResolveFromSubject(true);
        this.action.initialize();
        IdPAttribute inputAttribute = new IdPAttribute("attr2");
        inputAttribute.setValues(CollectionSupport.singletonList((Object)new ScopedStringAttributeValue("foo", "scope")));
        SubjectCanonicalizationContext sc = (SubjectCanonicalizationContext)this.prc.ensureSubcontext(SubjectCanonicalizationContext.class);
        Subject subject = new Subject();
        sc.setSubject(subject);
        subject.getPrincipals().add((Principal)new IdPAttributePrincipal(inputAttribute));
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertEquals((String)sc.getPrincipalName(), (String)"foo@scope");
    }

    @Test
    public void testDualSubjectSourcedSuccess() throws ComponentInitializationException {
        this.action.setResolveFromSubject(true);
        this.action.initialize();
        IdPAttribute attr2 = new IdPAttribute("attr2");
        attr2.setValues(CollectionSupport.singletonList((Object)new StringAttributeValue("foo")));
        IdPAttribute attr2bar = new IdPAttribute("attr2");
        attr2bar.setValues(CollectionSupport.singletonList((Object)new StringAttributeValue("bar")));
        SubjectCanonicalizationContext sc = (SubjectCanonicalizationContext)this.prc.ensureSubcontext(SubjectCanonicalizationContext.class);
        Subject subject = new Subject();
        sc.setSubject(subject);
        subject.getPrincipals().add((Principal)new IdPAttributePrincipal(attr2));
        ((AttributeContext)sc.ensureSubcontext(AttributeContext.class)).setIdPAttributes((Collection)CollectionSupport.singleton((Object)attr2bar));
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertEquals((String)sc.getPrincipalName(), (String)"foo");
        subject.getPrincipals().clear();
        subject.getPrincipals().add((Principal)new IdPAttributePrincipal(attr2bar));
        ((AttributeContext)sc.ensureSubcontext(AttributeContext.class)).setIdPAttributes((Collection)CollectionSupport.singleton((Object)attr2));
        event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertEquals((String)sc.getPrincipalName(), (String)"bar");
    }

    @Test
    public void testDualSubjectSourcedSuccess2() throws ComponentInitializationException {
        this.action.setResolveFromSubject(true);
        this.action.initialize();
        IdPAttribute attr2 = new IdPAttribute("attr2");
        attr2.setValues(CollectionSupport.singletonList((Object)new StringAttributeValue("bar")));
        IdPAttribute attr1 = new IdPAttribute("attr1");
        attr1.setValues(CollectionSupport.singletonList((Object)new StringAttributeValue("foo")));
        SubjectCanonicalizationContext sc = (SubjectCanonicalizationContext)this.prc.ensureSubcontext(SubjectCanonicalizationContext.class);
        Subject subject = new Subject();
        sc.setSubject(subject);
        subject.getPrincipals().add((Principal)new IdPAttributePrincipal(attr2));
        ((AttributeContext)sc.ensureSubcontext(AttributeContext.class)).setIdPAttributes((Collection)CollectionSupport.singleton((Object)attr1));
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertEquals((String)sc.getPrincipalName(), (String)"foo");
    }
}

