/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.HashMap;
import net.shibboleth.idp.authn.AuthenticationFlowDescriptor;
import net.shibboleth.idp.authn.MultiFactorAuthenticationTransition;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.MultiFactorAuthenticationContext;
import net.shibboleth.idp.authn.impl.DefaultAuthenticationResultSerializer;
import net.shibboleth.idp.authn.impl.PopulateAuthenticationContext;
import net.shibboleth.idp.authn.impl.PopulateMultiFactorAuthenticationContext;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.FunctionSupport;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.storage.StorageSerializer;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;

public class BaseMultiFactorAuthenticationContextTest {
    protected RequestContext src;
    protected ProfileRequestContext prc;
    protected AuthenticationContext ac;
    protected MultiFactorAuthenticationContext mfa;
    protected ImmutableMap<String, AuthenticationFlowDescriptor> authenticationFlows;

    protected void initializeMembers() throws ComponentInitializationException {
        this.src = new RequestContextBuilder().buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(this.src);
        this.ac = (AuthenticationContext)this.prc.addSubcontext((BaseContext)new AuthenticationContext(), true);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        AuthenticationFlowDescriptor flow = new AuthenticationFlowDescriptor();
        flow.setId("authn/MFA");
        flow.setResultSerializer((StorageSerializer)new DefaultAuthenticationResultSerializer());
        flow.initialize();
        builder.put((Object)"authn/MFA", (Object)flow);
        this.ac.setAttemptedFlow(flow);
        flow = new AuthenticationFlowDescriptor();
        flow.setId("authn/test1");
        flow.setResultSerializer((StorageSerializer)new DefaultAuthenticationResultSerializer());
        flow.initialize();
        builder.put((Object)"authn/test1", (Object)flow);
        flow = new AuthenticationFlowDescriptor();
        flow.setId("authn/test2");
        flow.setResultSerializer((StorageSerializer)new DefaultAuthenticationResultSerializer());
        flow.initialize();
        builder.put((Object)"authn/test2", (Object)flow);
        flow = new AuthenticationFlowDescriptor();
        flow.setId("authn/test3");
        flow.setResultSerializer((StorageSerializer)new DefaultAuthenticationResultSerializer());
        flow.initialize();
        builder.put((Object)"authn/test3", (Object)flow);
        this.authenticationFlows = builder.build();
    }

    protected void setUp() throws ComponentInitializationException {
        this.initializeMembers();
        PopulateAuthenticationContext action = new PopulateAuthenticationContext();
        action.setAvailableFlows((Collection)this.authenticationFlows.values());
        action.setPotentialFlowsLookupStrategy(FunctionSupport.constant((Object)CollectionSupport.singletonList((Object)((AuthenticationFlowDescriptor)this.authenticationFlows.get((Object)"authn/MFA")))));
        action.initialize();
        action.execute(this.src);
        HashMap<String, MultiFactorAuthenticationTransition> transitionMap = new HashMap<String, MultiFactorAuthenticationTransition>();
        MultiFactorAuthenticationTransition transition = new MultiFactorAuthenticationTransition();
        transition.setNextFlow("authn/test1");
        transitionMap.put(null, transition);
        transition = new MultiFactorAuthenticationTransition();
        transition.setNextFlow("interim");
        transitionMap.put("authn/test1", transition);
        transition = new MultiFactorAuthenticationTransition();
        transition.setNextFlow("authn/test2");
        transitionMap.put("interim", transition);
        PopulateMultiFactorAuthenticationContext mfaaction = new PopulateMultiFactorAuthenticationContext();
        mfaaction.setTransitionMapLookupStrategy(FunctionSupport.constant(transitionMap));
        mfaaction.initialize();
        ActionTestingSupport.assertProceedEvent((Event)mfaaction.execute(this.src));
        this.mfa = (MultiFactorAuthenticationContext)this.ac.getSubcontext(MultiFactorAuthenticationContext.class);
        Assert.assertNotNull((Object)this.mfa);
    }
}

