/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.Principal;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.security.auth.Subject;
import net.shibboleth.idp.attribute.ByteAttributeValue;
import net.shibboleth.idp.attribute.EmptyAttributeValue;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.ScopedStringAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.authn.AuthenticationFlowDescriptor;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.impl.DefaultAuthenticationResultSerializer;
import net.shibboleth.idp.authn.principal.AuthenticationResultPrincipal;
import net.shibboleth.idp.authn.principal.GenericPrincipalSerializer;
import net.shibboleth.idp.authn.principal.GenericPrincipalService;
import net.shibboleth.idp.authn.principal.IdPAttributePrincipal;
import net.shibboleth.idp.authn.principal.PasswordPrincipal;
import net.shibboleth.idp.authn.principal.PrincipalSerializer;
import net.shibboleth.idp.authn.principal.PrincipalServiceManager;
import net.shibboleth.idp.authn.principal.ProxyAuthenticationPrincipal;
import net.shibboleth.idp.authn.principal.SealedPrincipalSerializer;
import net.shibboleth.idp.authn.principal.SimplePrincipalSerializer;
import net.shibboleth.idp.authn.principal.UsernamePrincipal;
import net.shibboleth.idp.authn.principal.impl.IdPAttributePrincipalSerializer;
import net.shibboleth.idp.authn.principal.impl.LDAPPrincipalSerializer;
import net.shibboleth.idp.authn.principal.impl.ProxyAuthenticationPrincipalSerializer;
import net.shibboleth.idp.authn.testing.TestPrincipal;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.PredicateSupport;
import net.shibboleth.shared.security.DataSealer;
import net.shibboleth.shared.security.DataSealerKeyStrategy;
import net.shibboleth.shared.security.impl.BasicKeystoreKeyStrategy;
import net.shibboleth.shared.spring.resource.ResourceHelper;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapEntry;
import org.ldaptive.jaas.LdapPrincipal;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.testing.RequestContextBuilder;
import org.opensaml.security.x509.X509Support;
import org.opensaml.storage.StorageSerializer;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class DefaultAuthenticationResultSerializerTest {
    private static final String DATAPATH = "/net/shibboleth/idp/authn/impl/";
    private static final String CONTEXT = "_context";
    private static final String KEY = "_key";
    private static final Instant INSTANT = Instant.ofEpochMilli(1378827849463L);
    private static final long ACTIVITY = 1378827556778L;
    @Nonnull
    private static final String entityCertBase64 = "MIIDjDCCAnSgAwIBAgIBKjANBgkqhkiG9w0BAQUFADAtMRIwEAYDVQQKEwlJbnRlcm5ldDIxFzAVBgNVBAMTDmNhLmV4YW1wbGUub3JnMB4XDTA3MDQwOTA2MTIwOVoXDTE3MDQwNjA2MTIwOVowMTESMBAGA1UEChMJSW50ZXJuZXQyMRswGQYDVQQDExJmb29iYXIuZXhhbXBsZS5vcmcwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDNWnkFmhy1vYa6gN/xBRKkZxFy3sUq2V0LsYb6Q3pe9Qlb6+BzaM5DrN8uIqqroBE3Wp0LtrgKuQTpDpNFBdS2p5afiUtOYLWBDtizTOzs3Z36MGMjIPUYQ4s03IP3yPh2ud6EKpDPiYqzNbkRaiIwmYSit5r+RMYvd6fuKvTOn6h7PZI5AD7Rda7VWh5OVSoZXlRx3qxFho+mZhW0q4fUfTi5lWwf4EhkfBlzgw/k5gf4cOi6rrGpRS1zxmbtX1RAg+I20z6d04g0N2WsK5stszgYKoIROJCiXwjraa8/SoFcILolWQpttVHBIUYlyDlm8mIFleZf4ReFpfm+nUYxAgMBAAGjgbIwga8wCQYDVR0TBAIwADAsBglghkgBhvhCAQ0EHxYdT3BlblNTTCBHZW5lcmF0ZWQgQ2VydGlmaWNhdGUwHQYDVR0OBBYEFDgRgTkjaKoK6DoZfUZ4g9LDJUWuMFUGA1UdIwROMEyAFNXuZVPeUdqHrULqQW7yr9buRpQLoTGkLzAtMRIwEAYDVQQKEwlJbnRlcm5ldDIxFzAVBgNVBAMTDmNhLmV4YW1wbGUub3JnggEBMA0GCSqGSIb3DQEBBQUAA4IBAQCPj3Si4Eiw9abNgPBUhBXWd6eRYlIHaHcnez6j6g7foAOyuVIUso9Q5c6pvL87lmasK55l09YPXw1qmiH+bHMcrwEPODpLx7xd3snlOCi7FyxahxwSs8yfTu8Pq95rWt0LNcfHxQK938Cpnav6jgDo2uH/ywAOFFSnoBzGHAfScHMfj8asZ6THosYsklII7FSU8j49GV2utkvGB3mcu4STuLdeRCZmi93vq1D4JVGsXC4UaHjg114+a+9q0XZdz6a1UW4pt1ryXIPotCS62M71pkJf5neHUinKAqgoRfPXowudZg1Zl8DjzoOBn+MNHRrR5KYbVGvdHcxoJLCwVB/v";
    private PrincipalServiceManager manager;
    private DefaultAuthenticationResultSerializer serializer;
    private AuthenticationFlowDescriptor flowDescriptor;

    @BeforeMethod
    public void setUp() throws ComponentInitializationException, NoSuchMethodException, SecurityException {
        SimplePrincipalSerializer upSerializer = new SimplePrincipalSerializer(UsernamePrincipal.class, "U");
        upSerializer.initialize();
        GenericPrincipalService upService = new GenericPrincipalService(UsernamePrincipal.class, (PrincipalSerializer)upSerializer);
        upService.setId("username");
        upService.initialize();
        LDAPPrincipalSerializer lpSerializer = new LDAPPrincipalSerializer();
        lpSerializer.initialize();
        GenericPrincipalService lpService = new GenericPrincipalService(LdapPrincipal.class, (PrincipalSerializer)lpSerializer);
        lpService.setId("ldap");
        lpService.initialize();
        IdPAttributePrincipalSerializer attrSerializer = new IdPAttributePrincipalSerializer();
        attrSerializer.initialize();
        GenericPrincipalService attrService = new GenericPrincipalService(IdPAttributePrincipal.class, (PrincipalSerializer)attrSerializer);
        attrService.setId("attr");
        attrService.initialize();
        ProxyAuthenticationPrincipalSerializer proxySerializer = new ProxyAuthenticationPrincipalSerializer();
        proxySerializer.initialize();
        GenericPrincipalService proxyService = new GenericPrincipalService(ProxyAuthenticationPrincipal.class, (PrincipalSerializer)proxySerializer);
        proxyService.setId("proxy");
        proxyService.initialize();
        ClassPathResource keystoreResource = new ClassPathResource("/net/shibboleth/idp/authn/impl/SealerKeyStore.jks");
        ClassPathResource versionResource = new ClassPathResource("/net/shibboleth/idp/authn/impl/SealerKeyStore.kver");
        BasicKeystoreKeyStrategy strategy = new BasicKeystoreKeyStrategy();
        strategy.setKeyAlias("secret");
        strategy.setKeyPassword("kpassword");
        strategy.setKeystorePassword("password");
        strategy.setKeystoreResource(ResourceHelper.of((Resource)keystoreResource));
        strategy.setKeyVersionResource(ResourceHelper.of((Resource)versionResource));
        DataSealer sealer = new DataSealer();
        sealer.setKeyStrategy((DataSealerKeyStrategy)strategy);
        try {
            strategy.initialize();
            sealer.initialize();
        }
        catch (ComponentInitializationException e) {
            Assert.fail((String)e.getMessage());
        }
        SealedPrincipalSerializer pwSerializer = new SealedPrincipalSerializer(PasswordPrincipal.class, "PW");
        pwSerializer.setDataSealer(sealer);
        pwSerializer.initialize();
        GenericPrincipalService pwService = new GenericPrincipalService(PasswordPrincipal.class, (PrincipalSerializer)pwSerializer);
        pwService.setId("password");
        pwService.initialize();
        this.manager = new PrincipalServiceManager(List.of(upService, pwService, lpService, attrService, proxyService));
        GenericPrincipalSerializer generic = new GenericPrincipalSerializer();
        generic.initialize();
        assert (this.manager != null);
        this.serializer = new DefaultAuthenticationResultSerializer(this.manager, generic);
        this.flowDescriptor = new AuthenticationFlowDescriptor();
        this.flowDescriptor.setId("test");
        assert (this.serializer != null);
        this.flowDescriptor.setResultSerializer((StorageSerializer)this.serializer);
        this.flowDescriptor.setReuseCondition(PredicateSupport.alwaysTrue());
    }

    @Test
    public void testInvalid() throws Exception {
        this.serializer.initialize();
        try {
            this.serializer.deserialize(1L, CONTEXT, KEY, this.fileToString("/net/shibboleth/idp/authn/impl/invalid.json"), Long.valueOf(1378827556778L));
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.serializer.deserialize(1L, CONTEXT, KEY, this.fileToString("/net/shibboleth/idp/authn/impl/noFlowId.json"), Long.valueOf(1378827556778L));
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.serializer.deserialize(1L, CONTEXT, KEY, this.fileToString("/net/shibboleth/idp/authn/impl/noInstant.json"), Long.valueOf(1378827556778L));
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.serializer.deserialize(1L, CONTEXT, KEY, this.fileToString("/net/shibboleth/idp/authn/impl/invalidAdditional.json"), Long.valueOf(1378827556778L));
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testSimple() throws Exception {
        this.serializer.initialize();
        this.flowDescriptor.initialize();
        AuthenticationResult result = this.createResult(this.flowDescriptor, new Subject());
        result.getAdditionalData().put("foo", "bar");
        result.getAdditionalData().put("frobnitz", "zorkmid");
        result.getSubject().getPrincipals().add((Principal)new UsernamePrincipal("bob"));
        ProfileRequestContext prc = this.getProfileRequestContext(CollectionSupport.singletonList((Object)this.flowDescriptor));
        Assert.assertTrue((boolean)result.getReuseCondition().test(prc));
        this.flowDescriptor.serialize(result);
        String s2 = this.fileToString("/net/shibboleth/idp/authn/impl/simpleAuthenticationResult.json");
        AuthenticationResult result2 = this.flowDescriptor.deserialize(1L, CONTEXT, KEY, s2, Long.valueOf(Instant.ofEpochMilli(1378827556778L).plus(this.flowDescriptor.getInactivityTimeout()).plus(AuthenticationFlowDescriptor.STORAGE_EXPIRATION_OFFSET).toEpochMilli()));
        Assert.assertEquals((String)result.getAuthenticationFlowId(), (String)result2.getAuthenticationFlowId());
        Assert.assertEquals((Object)result.getAuthenticationInstant(), (Object)result2.getAuthenticationInstant());
        Assert.assertEquals((Object)result.getLastActivityInstant(), (Object)result2.getLastActivityInstant());
        Assert.assertEquals((Object)result.getSubject(), (Object)result2.getSubject());
        Assert.assertEquals((Map)result.getAdditionalData(), (Map)result2.getAdditionalData());
        Assert.assertTrue((boolean)result2.getReuseCondition().test(prc));
    }

    @Test
    public void testComplex() throws Exception {
        this.serializer.initialize();
        this.flowDescriptor.initialize();
        AuthenticationResult result = this.createResult(this.flowDescriptor, new Subject());
        result.getSubject().getPrincipals().add((Principal)new UsernamePrincipal("bob"));
        result.getSubject().getPrincipals().add((Principal)new TestPrincipal("foo"));
        result.getSubject().getPrincipals().add((Principal)new TestPrincipal("bar"));
        String s = this.flowDescriptor.serialize(result);
        String s2 = this.fileToString("/net/shibboleth/idp/authn/impl/complexAuthenticationResult.json");
        Assert.assertEquals((String)s, (String)s2);
        ProfileRequestContext prc = this.getProfileRequestContext(CollectionSupport.singletonList((Object)this.flowDescriptor));
        Assert.assertTrue((boolean)result.getReuseCondition().test(prc));
        AuthenticationResult result2 = this.flowDescriptor.deserialize(1L, CONTEXT, KEY, s2, Long.valueOf(Instant.ofEpochMilli(1378827556778L).plus(this.flowDescriptor.getInactivityTimeout()).plus(AuthenticationFlowDescriptor.STORAGE_EXPIRATION_OFFSET).toEpochMilli()));
        Assert.assertEquals((String)result.getAuthenticationFlowId(), (String)result2.getAuthenticationFlowId());
        Assert.assertEquals((Object)result.getAuthenticationInstant(), (Object)result2.getAuthenticationInstant());
        Assert.assertEquals((Object)result.getLastActivityInstant(), (Object)result2.getLastActivityInstant());
        Assert.assertEquals((Object)result.getSubject(), (Object)result2.getSubject());
        Assert.assertTrue((boolean)result2.getReuseCondition().test(prc));
    }

    @Test
    public void testCreds() throws Exception {
        this.serializer.initialize();
        this.flowDescriptor.initialize();
        AuthenticationResult result = this.createResult(this.flowDescriptor, new Subject());
        result.getSubject().getPrincipals().add((Principal)new UsernamePrincipal("bob"));
        result.getSubject().getPublicCredentials().add(X509Support.decodeCertificate((String)entityCertBase64));
        result.getSubject().getPrivateCredentials().add(new PasswordPrincipal("bar"));
        ProfileRequestContext prc = this.getProfileRequestContext(CollectionSupport.singletonList((Object)this.flowDescriptor));
        Assert.assertTrue((boolean)result.getReuseCondition().test(prc));
        String s = this.flowDescriptor.serialize(result);
        AuthenticationResult result2 = this.flowDescriptor.deserialize(1L, CONTEXT, KEY, s, Long.valueOf(Instant.ofEpochMilli(1378827556778L).plus(this.flowDescriptor.getInactivityTimeout()).plus(AuthenticationFlowDescriptor.STORAGE_EXPIRATION_OFFSET).toEpochMilli()));
        Assert.assertEquals((String)result.getAuthenticationFlowId(), (String)result2.getAuthenticationFlowId());
        Assert.assertEquals((Object)result.getAuthenticationInstant(), (Object)result2.getAuthenticationInstant());
        Assert.assertEquals((Object)result.getLastActivityInstant(), (Object)result2.getLastActivityInstant());
        Assert.assertEquals((Object)result.getSubject(), (Object)result2.getSubject());
        Assert.assertTrue((boolean)result2.getReuseCondition().test(prc));
    }

    @Test
    public void testSymbolic() throws Exception {
        GenericPrincipalSerializer generic = new GenericPrincipalSerializer();
        generic.setSymbolics(CollectionSupport.singletonMap((Object)TestPrincipal.class.getName(), (Object)1));
        generic.initialize();
        this.serializer = new DefaultAuthenticationResultSerializer(this.manager, generic);
        this.serializer.initialize();
        this.flowDescriptor.setResultSerializer((StorageSerializer)this.serializer);
        this.flowDescriptor.initialize();
        AuthenticationResult result = this.createResult(this.flowDescriptor, new Subject());
        result.getSubject().getPrincipals().add((Principal)new UsernamePrincipal("bob"));
        result.getSubject().getPrincipals().add((Principal)new TestPrincipal("foo"));
        result.getSubject().getPrincipals().add((Principal)new TestPrincipal("bar"));
        ProfileRequestContext prc = this.getProfileRequestContext(CollectionSupport.singletonList((Object)this.flowDescriptor));
        Assert.assertTrue((boolean)result.getReuseCondition().test(prc));
        String s = this.flowDescriptor.serialize(result);
        String s2 = this.fileToString("/net/shibboleth/idp/authn/impl/symbolicAuthenticationResult.json");
        Assert.assertEquals((String)s, (String)s2);
        AuthenticationResult result2 = this.flowDescriptor.deserialize(1L, CONTEXT, KEY, s2, Long.valueOf(Instant.ofEpochMilli(1378827556778L).plus(this.flowDescriptor.getInactivityTimeout()).plus(AuthenticationFlowDescriptor.STORAGE_EXPIRATION_OFFSET).toEpochMilli()));
        Assert.assertEquals((String)result.getAuthenticationFlowId(), (String)result2.getAuthenticationFlowId());
        Assert.assertEquals((Object)result.getAuthenticationInstant(), (Object)result2.getAuthenticationInstant());
        Assert.assertEquals((Object)result.getLastActivityInstant(), (Object)result2.getLastActivityInstant());
        Assert.assertEquals((Object)result.getSubject(), (Object)result2.getSubject());
        Assert.assertTrue((boolean)result2.getReuseCondition().test(prc));
    }

    @Test
    public void testLdap() throws Exception {
        this.serializer.initialize();
        this.flowDescriptor.initialize();
        AuthenticationResult result = this.createResult(this.flowDescriptor, new Subject());
        LdapEntry entry = new LdapEntry();
        entry.setDn("uid=1234,ou=people,dc=shibboleth,dc=net");
        LdapAttribute givenName = new LdapAttribute();
        givenName.setName("givenName");
        givenName.addStringValues(new String[]{"Bob", "Robert"});
        entry.addAttributes(new LdapAttribute[]{new LdapAttribute("cn", new String[]{"Bob Cobb"}), givenName, new LdapAttribute("sn", new String[]{"Cobb"}), new LdapAttribute("mail", new String[]{"bob@shibboleth.net"})});
        result.getSubject().getPrincipals().add((Principal)new LdapPrincipal("bob", LdapEntry.sort((LdapEntry)entry)));
        ProfileRequestContext prc = this.getProfileRequestContext(CollectionSupport.singletonList((Object)this.flowDescriptor));
        Assert.assertTrue((boolean)result.getReuseCondition().test(prc));
        String s = this.flowDescriptor.serialize(result);
        String s2 = this.fileToString("/net/shibboleth/idp/authn/impl/LDAPAuthenticationResult.json");
        Assert.assertEquals((String)s, (String)s2);
        AuthenticationResult result2 = this.flowDescriptor.deserialize(1L, CONTEXT, KEY, s2, Long.valueOf(Instant.ofEpochMilli(1378827556778L).plus(this.flowDescriptor.getInactivityTimeout()).plus(AuthenticationFlowDescriptor.STORAGE_EXPIRATION_OFFSET).toEpochMilli()));
        Assert.assertEquals((String)result.getAuthenticationFlowId(), (String)result2.getAuthenticationFlowId());
        Assert.assertEquals((Object)result.getAuthenticationInstant(), (Object)result2.getAuthenticationInstant());
        Assert.assertEquals((Object)result.getLastActivityInstant(), (Object)result2.getLastActivityInstant());
        Assert.assertEquals((Object)result.getSubject(), (Object)result2.getSubject());
        Assert.assertEquals((Object)((LdapPrincipal)result.getSubject().getPrincipals().iterator().next()).getLdapEntry(), (Object)((LdapPrincipal)result2.getSubject().getPrincipals().iterator().next()).getLdapEntry());
        Assert.assertTrue((boolean)result2.getReuseCondition().test(prc));
    }

    @Test
    public void testIdPAttribute() throws Exception {
        this.serializer.initialize();
        this.flowDescriptor.initialize();
        AuthenticationResult result = this.createResult(this.flowDescriptor, new Subject());
        IdPAttributePrincipal prin = new IdPAttributePrincipal(new IdPAttribute("foo"));
        prin.getAttribute().setValues(List.of(new StringAttributeValue("bar"), new ScopedStringAttributeValue("bar2", "scope"), EmptyAttributeValue.ZERO_LENGTH, new ByteAttributeValue("foo".getBytes())));
        result.getSubject().getPrincipals().add((Principal)prin);
        ProfileRequestContext prc = this.getProfileRequestContext(CollectionSupport.singletonList((Object)this.flowDescriptor));
        Assert.assertTrue((boolean)result.getReuseCondition().test(prc));
        String s = this.flowDescriptor.serialize(result);
        String s2 = this.fileToString("/net/shibboleth/idp/authn/impl/IdPAttributeAuthenticationResult.json");
        Assert.assertEquals((String)s, (String)s2);
        AuthenticationResult result2 = this.flowDescriptor.deserialize(1L, CONTEXT, KEY, s2, Long.valueOf(Instant.ofEpochMilli(1378827556778L).plus(this.flowDescriptor.getInactivityTimeout()).plus(AuthenticationFlowDescriptor.STORAGE_EXPIRATION_OFFSET).toEpochMilli()));
        Assert.assertEquals((String)result.getAuthenticationFlowId(), (String)result2.getAuthenticationFlowId());
        Assert.assertEquals((Object)result.getAuthenticationInstant(), (Object)result2.getAuthenticationInstant());
        Assert.assertEquals((Object)result.getLastActivityInstant(), (Object)result2.getLastActivityInstant());
        Assert.assertEquals((Object)result.getSubject(), (Object)result2.getSubject());
        Assert.assertTrue((boolean)result2.getReuseCondition().test(prc));
        IdPAttribute attribute = ((IdPAttributePrincipal)result2.getSubject().getPrincipals().iterator().next()).getAttribute();
        Assert.assertEquals((int)attribute.getValues().size(), (int)3);
        Assert.assertEquals((String)((StringAttributeValue)attribute.getValues().get(0)).getValue(), (String)"bar");
        Assert.assertEquals((String)((StringAttributeValue)attribute.getValues().get(1)).getValue(), (String)"bar2");
        Assert.assertEquals((String)((ScopedStringAttributeValue)attribute.getValues().get(1)).getScope(), (String)"scope");
        Assert.assertEquals(attribute.getValues().get(2), (Object)EmptyAttributeValue.ZERO_LENGTH);
    }

    @Test
    public void testProxyAuthentication() throws Exception {
        this.serializer.initialize();
        this.flowDescriptor.initialize();
        AuthenticationResult result = this.createResult(this.flowDescriptor, new Subject());
        ProxyAuthenticationPrincipal prin = new ProxyAuthenticationPrincipal((Collection)CollectionSupport.listOf((Object[])new String[]{"foo", "bar", "baz"}));
        prin.setProxyCount(Integer.valueOf(10));
        prin.getAudiences().add("zorkmid");
        result.getSubject().getPrincipals().add((Principal)prin);
        ProfileRequestContext prc = this.getProfileRequestContext(CollectionSupport.singletonList((Object)this.flowDescriptor));
        Assert.assertTrue((boolean)result.getReuseCondition().test(prc));
        String s = this.flowDescriptor.serialize(result);
        String s2 = this.fileToString("/net/shibboleth/idp/authn/impl/ProxyAuthenticationResult.json");
        Assert.assertEquals((String)s, (String)s2);
        AuthenticationResult result2 = this.flowDescriptor.deserialize(1L, CONTEXT, KEY, s2, Long.valueOf(Instant.ofEpochMilli(1378827556778L).plus(this.flowDescriptor.getInactivityTimeout()).plus(AuthenticationFlowDescriptor.STORAGE_EXPIRATION_OFFSET).toEpochMilli()));
        Assert.assertEquals((String)result.getAuthenticationFlowId(), (String)result2.getAuthenticationFlowId());
        Assert.assertEquals((Object)result.getAuthenticationInstant(), (Object)result2.getAuthenticationInstant());
        Assert.assertEquals((Object)result.getLastActivityInstant(), (Object)result2.getLastActivityInstant());
        Assert.assertEquals((Object)result.getSubject(), (Object)result2.getSubject());
        Assert.assertTrue((boolean)result2.getReuseCondition().test(prc));
        ProxyAuthenticationPrincipal prin2 = (ProxyAuthenticationPrincipal)result2.getSubject().getPrincipals().iterator().next();
        Assert.assertEquals((Collection)prin.getAuthorities(), (Collection)prin2.getAuthorities());
        Assert.assertEquals((Integer)prin.getProxyCount(), (Integer)prin2.getProxyCount());
        Assert.assertEquals((Set)prin.getAudiences(), (Set)prin2.getAudiences());
        Assert.assertTrue((boolean)result2.getReuseCondition().test(prc));
    }

    @Test
    public void testNestedAuthenticationResult() throws Exception {
        this.serializer.initialize();
        this.flowDescriptor.initialize();
        AuthenticationResult result = this.createResult(this.flowDescriptor, new Subject());
        AuthenticationFlowDescriptor nestedDescriptor = new AuthenticationFlowDescriptor();
        nestedDescriptor.setId("nested");
        assert (this.serializer != null);
        nestedDescriptor.setResultSerializer((StorageSerializer)this.serializer);
        nestedDescriptor.initialize();
        AuthenticationResult nested = this.createResult(nestedDescriptor, new Subject());
        nested.setLastActivityInstant(INSTANT);
        nested.getSubject().getPrincipals().add((Principal)new UsernamePrincipal("bob"));
        result.getSubject().getPrincipals().add((Principal)new AuthenticationResultPrincipal(nested));
        assert (this.flowDescriptor != null);
        ProfileRequestContext prc = this.getProfileRequestContext(CollectionSupport.listOf((Object)this.flowDescriptor, (Object)nestedDescriptor));
        Assert.assertTrue((boolean)result.getReuseCondition().test(prc));
        String s = this.flowDescriptor.serialize(result);
        String s2 = this.fileToString("/net/shibboleth/idp/authn/impl/NestedAuthenticationResult.json");
        Assert.assertEquals((String)s, (String)s2);
        AuthenticationResult result2 = this.flowDescriptor.deserialize(1L, CONTEXT, KEY, s2, Long.valueOf(Instant.ofEpochMilli(1378827556778L).plus(this.flowDescriptor.getInactivityTimeout()).plus(AuthenticationFlowDescriptor.STORAGE_EXPIRATION_OFFSET).toEpochMilli()));
        Assert.assertEquals((String)result.getAuthenticationFlowId(), (String)result2.getAuthenticationFlowId());
        Assert.assertEquals((Object)result.getAuthenticationInstant(), (Object)result2.getAuthenticationInstant());
        Assert.assertEquals((Object)result.getLastActivityInstant(), (Object)result2.getLastActivityInstant());
        Assert.assertEquals((Object)result.getSubject(), (Object)result2.getSubject());
        Assert.assertTrue((boolean)result2.getReuseCondition().test(prc));
        AuthenticationResult nested2 = ((AuthenticationResultPrincipal)result2.getSubject().getPrincipals().iterator().next()).getAuthenticationResult();
        Assert.assertEquals((String)nested.getAuthenticationFlowId(), (String)nested2.getAuthenticationFlowId());
        Assert.assertEquals((Object)nested.getAuthenticationInstant(), (Object)nested2.getAuthenticationInstant());
        Assert.assertEquals((Object)nested.getLastActivityInstant(), (Object)nested2.getLastActivityInstant());
        Assert.assertEquals((Object)nested.getSubject(), (Object)nested2.getSubject());
        Assert.assertTrue((boolean)nested2.getReuseCondition().test(prc));
    }

    @Nonnull
    private AuthenticationResult createResult(@Nonnull AuthenticationFlowDescriptor flow, @Nonnull Subject subject) {
        AuthenticationResult result = flow.newAuthenticationResult(subject);
        result.setAuthenticationInstant(INSTANT);
        result.setLastActivityInstant(Instant.ofEpochMilli(1378827556778L));
        return result;
    }

    @Nonnull
    private ProfileRequestContext getProfileRequestContext(@Nonnull List<AuthenticationFlowDescriptor> flows) {
        ProfileRequestContext prc = new RequestContextBuilder().buildProfileRequestContext();
        AuthenticationContext ac = (AuthenticationContext)prc.ensureSubcontext(AuthenticationContext.class);
        for (AuthenticationFlowDescriptor flow : flows) {
            ac.getAvailableFlows().put(flow.getId(), flow);
        }
        return prc;
    }

    @Nonnull
    private String fileToString(String pathname) throws URISyntaxException, IOException {
        try (FileInputStream stream = new FileInputStream(new File(DefaultAuthenticationResultSerializerTest.class.getResource(pathname).toURI()));){
            int avail = stream.available();
            byte[] data = new byte[avail];
            int numRead = 0;
            int pos = 0;
            do {
                if (pos + avail > data.length) {
                    byte[] newData = new byte[pos + avail];
                    System.arraycopy(data, 0, newData, 0, pos);
                    data = newData;
                }
                if ((numRead = stream.read(data, pos, avail)) < 0) continue;
                pos += numRead;
            } while ((avail = stream.available()) > 0 && numRead >= 0);
            String str = new String(data, 0, pos, "UTF-8").trim();
            assert (str != null);
            String string = str;
            return string;
        }
    }
}

