/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import java.util.Arrays;
import net.shibboleth.idp.authn.AbstractAuthenticationAction;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.UsernameContext;
import net.shibboleth.idp.authn.impl.ExtractRemoteUser;
import net.shibboleth.idp.authn.impl.testing.BaseAuthenticationContextTest;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.shared.collection.Pair;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.primitive.NonnullSupplier;
import net.shibboleth.shared.testing.ConstantSupplier;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.webflow.execution.Event;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ExtractRemoteUserTest
extends BaseAuthenticationContextTest {
    private ExtractRemoteUser action;

    @Override
    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        super.setUp();
        this.action = new ExtractRemoteUser();
        MockHttpServletRequest request = new MockHttpServletRequest();
        this.action.setHttpServletRequestSupplier((NonnullSupplier)new ConstantSupplier((Object)request));
    }

    @Test
    public void testNoConfig() {
        try {
            this.action.setCheckRemoteUser(false);
            this.action.initialize();
            Assert.fail();
        }
        catch (ComponentInitializationException componentInitializationException) {
            // empty catch block
        }
    }

    @Test
    public void testNoServlet() throws ComponentInitializationException {
        this.action.setHttpServletRequestSupplier(null);
        this.action.initialize();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"NoCredentials");
    }

    @Test
    public void testMissingIdentity() throws ComponentInitializationException {
        this.action.initialize();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"NoCredentials");
    }

    @Test
    public void testRemoteUser() throws ComponentInitializationException {
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).setRemoteUser("foo");
        this.action.initialize();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        AuthenticationContext authCtx = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (authCtx != null);
        UsernameContext unCtx = (UsernameContext)authCtx.getSubcontext(UsernameContext.class);
        assert (unCtx != null);
        Assert.assertEquals((String)unCtx.getUsername(), (String)"foo");
    }

    @Test
    public void testAttribute() throws ComponentInitializationException {
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).setAttribute("Username", (Object)"foo");
        this.action.setCheckAttributes(Arrays.asList("Username"));
        this.action.initialize();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        AuthenticationContext authCtx = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (authCtx != null);
        UsernameContext unCtx = (UsernameContext)authCtx.getSubcontext(UsernameContext.class);
        assert (unCtx != null);
        Assert.assertEquals((String)unCtx.getUsername(), (String)"foo");
    }

    @Test
    public void testHeader() throws ComponentInitializationException {
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addHeader("X-Username", (Object)"foo");
        this.action.setCheckAttributes(Arrays.asList("Username"));
        this.action.setCheckHeaders(Arrays.asList("X-Username"));
        this.action.initialize();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        AuthenticationContext authCtx = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (authCtx != null);
        UsernameContext unCtx = (UsernameContext)authCtx.getSubcontext(UsernameContext.class);
        assert (unCtx != null);
        Assert.assertEquals((String)unCtx.getUsername(), (String)"foo");
    }

    @Test
    public void testTransforms() throws ComponentInitializationException {
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).setRemoteUser(" Foo@osu.edu ");
        this.action.setTrim(true);
        this.action.setTransforms(Arrays.asList(new Pair((Object)"^(.+)@osu\\.edu$", (Object)"$1")));
        this.action.setLowercase(true);
        this.action.initialize();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        AuthenticationContext authCtx = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (authCtx != null);
        UsernameContext unCtx = (UsernameContext)authCtx.getSubcontext(UsernameContext.class);
        assert (unCtx != null);
        Assert.assertEquals((String)unCtx.getUsername(), (String)"foo");
    }
}

