/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import java.net.InetAddress;
import net.shibboleth.idp.authn.AbstractAuthenticationAction;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.UserAgentContext;
import net.shibboleth.idp.authn.impl.ExtractUserAgentAddress;
import net.shibboleth.idp.authn.impl.testing.BaseAuthenticationContextTest;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.primitive.NonnullSupplier;
import net.shibboleth.shared.testing.ConstantSupplier;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.webflow.execution.Event;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ExtractUserAgentAddressTest
extends BaseAuthenticationContextTest {
    private ExtractUserAgentAddress action;
    public Object nullObj;

    @Override
    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        super.setUp();
        this.action = new ExtractUserAgentAddress();
        MockHttpServletRequest request = new MockHttpServletRequest();
        this.action.setHttpServletRequestSupplier((NonnullSupplier)new ConstantSupplier((Object)request));
        this.action.initialize();
    }

    @Test
    public void testMissingAddress() {
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).setRemoteAddr((String)this.nullObj);
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"NoCredentials");
    }

    @Test
    public void testValidAddress() {
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        AuthenticationContext authCtx = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (authCtx != null);
        UserAgentContext uaCtx = (UserAgentContext)authCtx.getSubcontext(UserAgentContext.class);
        assert (uaCtx != null);
        InetAddress addr = uaCtx.getAddress();
        assert (addr != null);
        Assert.assertEquals((String)addr.getHostAddress(), (String)"127.0.0.1");
    }

    @Test
    public void testInvalidAddress() {
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).setRemoteAddr("zorkmids");
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"NoCredentials");
    }
}

