/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import net.shibboleth.idp.authn.AbstractAuthenticationAction;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.UsernamePasswordContext;
import net.shibboleth.idp.authn.impl.ExtractUsernamePasswordFromBasicAuth;
import net.shibboleth.idp.authn.impl.testing.BaseAuthenticationContextTest;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.primitive.NonnullSupplier;
import net.shibboleth.shared.testing.ConstantSupplier;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.webflow.execution.Event;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ExtractUsernamePasswordFromBasicAuthTest
extends BaseAuthenticationContextTest {
    private ExtractUsernamePasswordFromBasicAuth action;

    @Override
    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        super.setUp();
        this.action = new ExtractUsernamePasswordFromBasicAuth();
        MockHttpServletRequest request = new MockHttpServletRequest();
        this.action.setHttpServletRequestSupplier((NonnullSupplier)new ConstantSupplier((Object)request));
        this.action.initialize();
        this.action.initialize();
    }

    @Test
    public void testNoServlet() throws ComponentInitializationException {
        this.action = new ExtractUsernamePasswordFromBasicAuth();
        this.action.initialize();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"NoCredentials");
    }

    @Test
    public void testMissingIdentity() {
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"NoCredentials");
    }

    @Test
    public void testMissingIdentity2() {
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addHeader("Authorization", (Object)"foo");
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"NoCredentials");
    }

    @Test
    public void testInvalid() {
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addHeader("Authorization", (Object)"Basic foo:bar");
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidCredentials");
    }

    @Test
    public void testInvalid2() {
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addHeader("Authorization", (Object)"Basic Zm9vOg==");
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidCredentials");
    }

    @Test
    public void testInvalidBase64() {
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addHeader("Authorization", (Object)"Basic AB==");
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidCredentials");
    }

    @Test
    public void testValid() {
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addHeader("Authorization", (Object)"Basic Zm9vOmJhcg==");
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        AuthenticationContext authCtx = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (authCtx != null);
        UsernamePasswordContext upCtx = (UsernamePasswordContext)authCtx.getSubcontext(UsernamePasswordContext.class);
        assert (upCtx != null);
        Assert.assertEquals((String)upCtx.getUsername(), (String)"foo");
        Assert.assertEquals((String)upCtx.getPassword(), (String)"bar");
    }

    @Test
    public void idp1968() {
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addHeader("Authorization", (Object)"Basic Zm9vOuKYr++4j2Jhcg==");
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        AuthenticationContext authCtx = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (authCtx != null);
        UsernamePasswordContext upCtx = (UsernamePasswordContext)authCtx.getSubcontext(UsernamePasswordContext.class);
        assert (upCtx != null);
        Assert.assertEquals((String)upCtx.getUsername(), (String)"foo");
        Assert.assertEquals((String)upCtx.getPassword(), (String)"\u262f\ufe0fbar");
    }
}

