/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import net.shibboleth.idp.authn.AbstractAuthenticationAction;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.UsernamePasswordContext;
import net.shibboleth.idp.authn.impl.ExtractUsernamePasswordFromFormRequest;
import net.shibboleth.idp.authn.impl.testing.BaseAuthenticationContextTest;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.primitive.NonnullSupplier;
import net.shibboleth.shared.testing.ConstantSupplier;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.webflow.execution.Event;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ExtractUsernamePasswordFromFormRequestTest
extends BaseAuthenticationContextTest {
    private ExtractUsernamePasswordFromFormRequest action;

    @Override
    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        super.setUp();
        this.action = new ExtractUsernamePasswordFromFormRequest();
        this.action.setUsernameFieldName("j_username");
        this.action.setPasswordFieldName("j_password");
        MockHttpServletRequest request = new MockHttpServletRequest();
        this.action.setHttpServletRequestSupplier((NonnullSupplier)new ConstantSupplier((Object)request));
        this.action.initialize();
    }

    @Test
    public void testNoServlet() throws ComponentInitializationException {
        this.action = new ExtractUsernamePasswordFromFormRequest();
        this.action.setUsernameFieldName("j_username");
        this.action.setPasswordFieldName("j_password");
        this.action.initialize();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"NoCredentials");
    }

    @Test
    public void testMissingIdentity() {
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"NoCredentials");
    }

    @Test
    public void testMissingIdentity2() {
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("j_username", "foo");
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"NoCredentials");
    }

    @Test
    public void testValid() {
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("j_username", "foo");
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("j_password", "bar");
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        AuthenticationContext authCtx = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (authCtx != null);
        Assert.assertTrue((boolean)authCtx.isResultCacheable());
        UsernamePasswordContext upCtx = (UsernamePasswordContext)authCtx.getSubcontext(UsernamePasswordContext.class);
        assert (upCtx != null);
        Assert.assertEquals((String)upCtx.getUsername(), (String)"foo");
        Assert.assertEquals((String)upCtx.getPassword(), (String)"bar");
    }

    @Test
    public void testSSOBypass() {
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("j_username", "foo");
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("j_password", "bar");
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("donotcache", "1");
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        AuthenticationContext authCtx = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (authCtx != null);
        Assert.assertFalse((boolean)authCtx.isResultCacheable());
        UsernamePasswordContext upCtx = (UsernamePasswordContext)authCtx.getSubcontext(UsernamePasswordContext.class);
        assert (upCtx != null);
        Assert.assertEquals((String)upCtx.getUsername(), (String)"foo");
        Assert.assertEquals((String)upCtx.getPassword(), (String)"bar");
    }
}

