/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import java.time.Duration;
import net.shibboleth.idp.authn.AuthenticationFlowDescriptor;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.impl.FilterFlowsByForcedAuthn;
import net.shibboleth.idp.authn.impl.testing.BaseAuthenticationContextTest;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import org.springframework.webflow.execution.Event;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class FilterFlowsByForceAuthnTest
extends BaseAuthenticationContextTest {
    private FilterFlowsByForcedAuthn action;

    @Override
    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        super.setUp();
        this.action = new FilterFlowsByForcedAuthn();
        this.action.initialize();
    }

    @Test
    public void testNonForced() {
        AuthenticationContext authCtx = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (authCtx != null);
        authCtx.setForceAuthn(false);
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertEquals((int)authCtx.getPotentialFlows().size(), (int)3);
    }

    @Test
    public void testNoFiltering() {
        AuthenticationContext authCtx = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (authCtx != null);
        authCtx.setForceAuthn(true);
        for (AuthenticationFlowDescriptor fd : authCtx.getPotentialFlows().values()) {
            fd.setForcedAuthenticationSupported(true);
        }
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertEquals((int)authCtx.getPotentialFlows().size(), (int)3);
    }

    @Test
    public void testPartialFiltering() {
        AuthenticationContext authCtx = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (authCtx != null);
        authCtx.setMaxAge(Duration.ofHours(1L));
        ((AuthenticationFlowDescriptor)authCtx.getPotentialFlows().get("test2")).setForcedAuthenticationSupported(true);
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertEquals((int)authCtx.getPotentialFlows().size(), (int)1);
        Assert.assertNull(authCtx.getPotentialFlows().get("test1"));
        Assert.assertNotNull(authCtx.getPotentialFlows().get("test2"));
    }
}

