/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import net.shibboleth.idp.authn.AuthenticationFlowDescriptor;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.impl.FilterFlowsByNonBrowserSupport;
import net.shibboleth.idp.authn.impl.testing.BaseAuthenticationContextTest;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import org.springframework.webflow.execution.Event;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class FilterFlowsByNonBrowserSupportTest
extends BaseAuthenticationContextTest {
    private FilterFlowsByNonBrowserSupport action;

    @Override
    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        super.setUp();
        this.action = new FilterFlowsByNonBrowserSupport();
        this.action.initialize();
    }

    @Test
    public void testBrowserProfile() {
        AuthenticationContext authCtx = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (authCtx != null);
        this.prc.setBrowserProfile(true);
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertEquals((int)authCtx.getPotentialFlows().size(), (int)3);
    }

    @Test
    public void testNoFiltering() {
        AuthenticationContext authCtx = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (authCtx != null);
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertEquals((int)authCtx.getPotentialFlows().size(), (int)3);
    }

    @Test
    public void testPartialFiltering() {
        AuthenticationContext authCtx = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (authCtx != null);
        ((AuthenticationFlowDescriptor)authCtx.getPotentialFlows().get("test1")).setNonBrowserSupported(false);
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertEquals((int)authCtx.getPotentialFlows().size(), (int)2);
        Assert.assertNull(authCtx.getPotentialFlows().get("test1"));
        Assert.assertNotNull(authCtx.getPotentialFlows().get("test2"));
    }
}

