/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import java.security.Principal;
import javax.security.auth.Subject;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.idp.authn.context.SubjectCanonicalizationContext;
import net.shibboleth.idp.authn.impl.BaseMultiFactorAuthenticationContextTest;
import net.shibboleth.idp.authn.impl.FinalizeMultiFactorAuthentication;
import net.shibboleth.idp.authn.principal.AuthenticationResultPrincipal;
import net.shibboleth.idp.authn.principal.UsernamePrincipal;
import net.shibboleth.idp.authn.testing.TestPrincipal;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.FunctionSupport;
import org.opensaml.messaging.context.BaseContext;
import org.springframework.webflow.execution.Event;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class FinalizeMultiFactorAuthenticationTest
extends BaseMultiFactorAuthenticationContextTest {
    private FinalizeMultiFactorAuthentication action;

    @Override
    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        super.setUp();
        Subject subject = new Subject();
        subject.getPrincipals().add((Principal)new UsernamePrincipal("foo"));
        subject.getPrincipals().add((Principal)new TestPrincipal("bar"));
        this.mfa.getActiveResults().put("test", new AuthenticationResult("test", subject));
        this.action = new FinalizeMultiFactorAuthentication();
    }

    @Test
    public void testNoContext() throws ComponentInitializationException {
        assert (this.mfa != null);
        this.ac.removeSubcontext((BaseContext)this.mfa);
        this.action.initialize();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidProfileContext");
    }

    @Test
    public void testNullResult() throws ComponentInitializationException {
        this.action.setResultMergingStrategy(FunctionSupport.constant(null));
        this.action.initialize();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidAuthenticationContext");
    }

    @Test
    public void testSingleResult() throws ComponentInitializationException {
        this.action.initialize();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        AuthenticationResult result = this.ac.getAuthenticationResult();
        assert (result != null);
        Assert.assertEquals((String)result.getAuthenticationFlowId(), (String)"authn/MFA");
        Subject merged = result.getSubject();
        Assert.assertEquals((int)merged.getPrincipals().size(), (int)3);
        Assert.assertEquals((int)merged.getPrincipals(AuthenticationResultPrincipal.class).size(), (int)1);
        Assert.assertTrue((boolean)merged.getPrincipals(UsernamePrincipal.class).contains(new UsernamePrincipal("foo")));
        Assert.assertFalse((boolean)merged.getPrincipals(UsernamePrincipal.class).contains(new UsernamePrincipal("foo2")));
        Assert.assertTrue((boolean)merged.getPrincipals(TestPrincipal.class).contains(new TestPrincipal("bar")));
        Assert.assertFalse((boolean)merged.getPrincipals(TestPrincipal.class).contains(new TestPrincipal("baz")));
        SubjectCanonicalizationContext scc = (SubjectCanonicalizationContext)this.prc.getSubcontext(SubjectCanonicalizationContext.class);
        assert (scc != null);
        Assert.assertSame((Object)merged, (Object)scc.getSubject());
    }

    @Test
    public void testMergedResults() throws ComponentInitializationException {
        Subject subject = new Subject();
        subject.getPrincipals().add((Principal)new UsernamePrincipal("foo2"));
        subject.getPrincipals().add((Principal)new TestPrincipal("bar"));
        this.mfa.getActiveResults().put("test2", new AuthenticationResult("test2", subject));
        this.action.initialize();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        AuthenticationResult result = this.ac.getAuthenticationResult();
        assert (result != null);
        Assert.assertEquals((String)result.getAuthenticationFlowId(), (String)"authn/MFA");
        Subject merged = result.getSubject();
        Assert.assertEquals((int)merged.getPrincipals().size(), (int)5);
        Assert.assertEquals((int)merged.getPrincipals(AuthenticationResultPrincipal.class).size(), (int)2);
        Assert.assertTrue((boolean)merged.getPrincipals(UsernamePrincipal.class).contains(new UsernamePrincipal("foo")));
        Assert.assertTrue((boolean)merged.getPrincipals(UsernamePrincipal.class).contains(new UsernamePrincipal("foo2")));
        Assert.assertFalse((boolean)merged.getPrincipals(UsernamePrincipal.class).contains(new UsernamePrincipal("foo3")));
        Assert.assertTrue((boolean)merged.getPrincipals(TestPrincipal.class).contains(new TestPrincipal("bar")));
        Assert.assertFalse((boolean)merged.getPrincipals(TestPrincipal.class).contains(new TestPrincipal("baz")));
        SubjectCanonicalizationContext scc = (SubjectCanonicalizationContext)this.prc.getSubcontext(SubjectCanonicalizationContext.class);
        assert (scc != null);
        Assert.assertSame((Object)merged, (Object)scc.getSubject());
    }
}

