/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import java.util.regex.Pattern;
import javax.security.auth.login.LoginException;
import net.shibboleth.idp.authn.AbstractAuthenticationAction;
import net.shibboleth.idp.authn.AuthenticationFlowDescriptor;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.AuthenticationErrorContext;
import net.shibboleth.idp.authn.context.RequestedPrincipalContext;
import net.shibboleth.idp.authn.context.UsernamePasswordContext;
import net.shibboleth.idp.authn.impl.ExtractUsernamePasswordFromFormRequest;
import net.shibboleth.idp.authn.impl.HTPasswdCredentialValidator;
import net.shibboleth.idp.authn.impl.ValidateCredentials;
import net.shibboleth.idp.authn.impl.testing.BaseAuthenticationContextTest;
import net.shibboleth.idp.authn.principal.PrincipalEvalPredicateFactory;
import net.shibboleth.idp.authn.principal.UsernamePrincipal;
import net.shibboleth.idp.authn.principal.impl.ExactPrincipalEvalPredicateFactory;
import net.shibboleth.idp.authn.testing.TestPrincipal;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.primitive.NonnullSupplier;
import net.shibboleth.shared.spring.resource.ResourceHelper;
import net.shibboleth.shared.testing.ConstantSupplier;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.webflow.execution.Event;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class HTPasswdCredentialValidatorTest
extends BaseAuthenticationContextTest {
    private static final String DATA_PATH = "src/test/resources/net/shibboleth/idp/authn/impl/";
    private HTPasswdCredentialValidator validator;
    private ValidateCredentials action;

    @Override
    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        super.setUp();
        this.validator = new HTPasswdCredentialValidator();
        this.validator.setResource(ResourceHelper.of((Resource)new ClassPathResource("net/shibboleth/idp/authn/impl/htpasswd.txt")));
        this.validator.setId("htpasswdtest");
        this.action = new ValidateCredentials();
        assert (this.validator != null);
        this.action.setValidators(CollectionSupport.singletonList((Object)this.validator));
        HashMap<String, Set> mappings = new HashMap<String, Set>();
        mappings.put("InvalidPassword", CollectionSupport.singleton((Object)"InvalidCredentials"));
        mappings.put("UnknownUsername", CollectionSupport.singleton((Object)"UnknownUsername"));
        this.action.setClassifiedMessages(mappings);
        MockHttpServletRequest request = new MockHttpServletRequest();
        this.action.setHttpServletRequestSupplier((NonnullSupplier)new ConstantSupplier((Object)request));
    }

    @Test
    public void testMissingFlow() throws ComponentInitializationException {
        this.validator.initialize();
        this.action.initialize();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidAuthenticationContext");
    }

    @Test
    public void testMissingUser() throws ComponentInitializationException {
        AuthenticationContext ac = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (ac != null);
        ac.setAttemptedFlow((AuthenticationFlowDescriptor)this.authenticationFlows.get(0));
        this.validator.initialize();
        this.action.initialize();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"NoCredentials");
    }

    @Test
    public void testMissingUser2() throws ComponentInitializationException {
        AuthenticationContext ac = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (ac != null);
        ac.setAttemptedFlow((AuthenticationFlowDescriptor)this.authenticationFlows.get(0));
        ac.getSubcontext(UsernamePasswordContext.class);
        this.validator.initialize();
        this.action.initialize();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"NoCredentials");
    }

    @Test
    public void testUnsupported() throws ComponentInitializationException {
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("username", "foo");
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("password", "bar");
        AuthenticationContext ac = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (ac != null);
        ac.setAttemptedFlow((AuthenticationFlowDescriptor)this.authenticationFlows.get(0));
        RequestedPrincipalContext rpc = (RequestedPrincipalContext)ac.ensureSubcontext(RequestedPrincipalContext.class);
        rpc.getPrincipalEvalPredicateFactoryRegistry().register(TestPrincipal.class, "exact", (PrincipalEvalPredicateFactory)new ExactPrincipalEvalPredicateFactory());
        rpc.setOperator("exact");
        rpc.setRequestedPrincipals(CollectionSupport.singletonList((Object)new TestPrincipal("test1")));
        this.validator.setSupportedPrincipals((Collection)CollectionSupport.singletonList((Object)new TestPrincipal("test2")));
        this.validator.initialize();
        this.action.initialize();
        this.doExtract();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"RequestUnsupported");
    }

    @Test
    public void testUnmatchedUser() throws ComponentInitializationException {
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("username", "foo");
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("password", "bar");
        AuthenticationContext ac = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (ac != null);
        ac.setAttemptedFlow((AuthenticationFlowDescriptor)this.authenticationFlows.get(0));
        ac.getSubcontext(UsernamePasswordContext.class);
        this.validator.setMatchExpression(Pattern.compile("foo.+"));
        this.validator.initialize();
        this.action.initialize();
        this.doExtract();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"RequestUnsupported");
    }

    @Test
    public void testBadUsername() throws ComponentInitializationException {
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("username", "foo");
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("password", "bar");
        AuthenticationContext ac = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (ac != null);
        ac.setAttemptedFlow((AuthenticationFlowDescriptor)this.authenticationFlows.get(0));
        this.validator.initialize();
        this.action.initialize();
        this.doExtract();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"UnknownUsername");
        AuthenticationErrorContext errorCtx = (AuthenticationErrorContext)ac.getSubcontext(AuthenticationErrorContext.class);
        assert (errorCtx != null);
        Assert.assertTrue((boolean)(errorCtx.getExceptions().get(0) instanceof LoginException));
        Assert.assertTrue((boolean)errorCtx.isClassifiedError("UnknownUsername"));
        Assert.assertFalse((boolean)errorCtx.isClassifiedError("InvalidPassword"));
    }

    @Test
    public void testBadPassword() throws ComponentInitializationException {
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("username", "PETER_THE_PRINCIPAL");
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("password", "bar");
        AuthenticationContext ac = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (ac != null);
        ac.setAttemptedFlow((AuthenticationFlowDescriptor)this.authenticationFlows.get(0));
        this.validator.initialize();
        this.action.initialize();
        this.doExtract();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidPassword");
        AuthenticationErrorContext errorCtx = (AuthenticationErrorContext)ac.getSubcontext(AuthenticationErrorContext.class);
        assert (errorCtx != null);
        Assert.assertTrue((boolean)(errorCtx.getExceptions().get(0) instanceof LoginException));
        Assert.assertFalse((boolean)errorCtx.isClassifiedError("UnknownUsername"));
        Assert.assertTrue((boolean)errorCtx.isClassifiedError("InvalidPassword"));
    }

    @Test
    public void testAuthorizedMD5() throws ComponentInitializationException {
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("username", "PETER_THE_PRINCIPAL");
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("password", "changeit");
        AuthenticationContext ac = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (ac != null);
        ac.setAttemptedFlow((AuthenticationFlowDescriptor)this.authenticationFlows.get(0));
        this.validator.initialize();
        this.action.initialize();
        this.doExtract();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        AuthenticationResult result = ac.getAuthenticationResult();
        assert (result != null);
        Assert.assertEquals((String)result.getSubject().getPrincipals(UsernamePrincipal.class).iterator().next().getName(), (String)"PETER_THE_PRINCIPAL");
    }

    @Test
    public void testAuthorizedMD5WithFile() throws ComponentInitializationException {
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("username", "PETER_THE_PRINCIPAL");
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("password", "changeit");
        AuthenticationContext ac = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (ac != null);
        ac.setAttemptedFlow((AuthenticationFlowDescriptor)this.authenticationFlows.get(0));
        this.validator.setResource(ResourceHelper.of((Resource)new FileSystemResource("src/test/resources/net/shibboleth/idp/authn/impl/htpasswd.txt")));
        this.validator.initialize();
        this.action.initialize();
        this.doExtract();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        AuthenticationResult result = ac.getAuthenticationResult();
        assert (result != null);
        Assert.assertEquals((String)result.getSubject().getPrincipals(UsernamePrincipal.class).iterator().next().getName(), (String)"PETER_THE_PRINCIPAL");
    }

    @Test
    public void testAuthorizedSHA() throws ComponentInitializationException {
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("username", "PETER_THE_PRINCIPAL2");
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("password", "changeit");
        AuthenticationContext ac = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (ac != null);
        ac.setAttemptedFlow((AuthenticationFlowDescriptor)this.authenticationFlows.get(0));
        this.validator.initialize();
        this.action.initialize();
        this.doExtract();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        AuthenticationResult result = ac.getAuthenticationResult();
        assert (result != null);
        Assert.assertEquals((String)result.getSubject().getPrincipals(UsernamePrincipal.class).iterator().next().getName(), (String)"PETER_THE_PRINCIPAL2");
    }

    @Test
    public void testAuthorizedCrypt() throws ComponentInitializationException {
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("username", "PETER_THE_PRINCIPAL3");
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("password", "changeit");
        AuthenticationContext ac = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (ac != null);
        ac.setAttemptedFlow((AuthenticationFlowDescriptor)this.authenticationFlows.get(0));
        this.validator.initialize();
        this.action.initialize();
        this.doExtract();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        AuthenticationResult result = ac.getAuthenticationResult();
        assert (result != null);
        Assert.assertEquals((String)result.getSubject().getPrincipals(UsernamePrincipal.class).iterator().next().getName(), (String)"PETER_THE_PRINCIPAL3");
    }

    @Test
    public void testAuthorizedAndKeep() throws ComponentInitializationException {
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("username", "PETER_THE_PRINCIPAL");
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("password", "changeit");
        AuthenticationContext ac = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (ac != null);
        ac.setAttemptedFlow((AuthenticationFlowDescriptor)this.authenticationFlows.get(0));
        this.validator.initialize();
        this.action.initialize();
        this.doExtract();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        AuthenticationResult result = ac.getAuthenticationResult();
        assert (result != null);
        Assert.assertEquals((String)result.getSubject().getPrincipals(UsernamePrincipal.class).iterator().next().getName(), (String)"PETER_THE_PRINCIPAL");
    }

    @Test
    public void testSupported() throws ComponentInitializationException {
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("username", "PETER_THE_PRINCIPAL");
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("password", "changeit");
        AuthenticationContext ac = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (ac != null);
        ac.setAttemptedFlow((AuthenticationFlowDescriptor)this.authenticationFlows.get(0));
        RequestedPrincipalContext rpc = (RequestedPrincipalContext)ac.ensureSubcontext(RequestedPrincipalContext.class);
        rpc.getPrincipalEvalPredicateFactoryRegistry().register(TestPrincipal.class, "exact", (PrincipalEvalPredicateFactory)new ExactPrincipalEvalPredicateFactory());
        rpc.setOperator("exact");
        rpc.setRequestedPrincipals(CollectionSupport.singletonList((Object)new TestPrincipal("test1")));
        this.validator.setSupportedPrincipals((Collection)CollectionSupport.singletonList((Object)new TestPrincipal("test1")));
        this.validator.initialize();
        this.action.initialize();
        this.doExtract();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        AuthenticationResult result = ac.getAuthenticationResult();
        assert (result != null);
        Assert.assertEquals((String)result.getSubject().getPrincipals(UsernamePrincipal.class).iterator().next().getName(), (String)"PETER_THE_PRINCIPAL");
        Assert.assertEquals((String)result.getSubject().getPrincipals(TestPrincipal.class).iterator().next().getName(), (String)"test1");
    }

    private void doExtract() throws ComponentInitializationException {
        ExtractUsernamePasswordFromFormRequest extract = new ExtractUsernamePasswordFromFormRequest();
        extract.setHttpServletRequestSupplier(this.action.getHttpServletRequestSupplier());
        extract.initialize();
        extract.execute(this.src);
    }
}

