/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import java.util.Collection;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.RequestedPrincipalContext;
import net.shibboleth.idp.authn.impl.InitializeRequestedPrincipalContext;
import net.shibboleth.idp.authn.testing.MockAuthenticationProfileConfiguration;
import net.shibboleth.idp.authn.testing.TestPrincipal;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.idp.profile.testing.MockProfileConfiguration;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class InitializeRequestedPrincipalContextTest {
    private RequestContext src;
    private ProfileRequestContext prc;
    private InitializeRequestedPrincipalContext action;

    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        this.src = new RequestContextBuilder().buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(this.src);
        this.action = new InitializeRequestedPrincipalContext();
        this.action.initialize();
    }

    @Test
    public void testNoReplace() throws Exception {
        AuthenticationContext authCtx = (AuthenticationContext)this.prc.ensureSubcontext(AuthenticationContext.class);
        ((RequestedPrincipalContext)authCtx.ensureSubcontext(RequestedPrincipalContext.class)).setOperator("foo");
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        RequestedPrincipalContext rpc = (RequestedPrincipalContext)authCtx.getSubcontext(RequestedPrincipalContext.class);
        assert (rpc != null);
        Assert.assertEquals((String)rpc.getOperator(), (String)"foo");
    }

    @Test
    public void testNoRelyingPartyContext() throws Exception {
        this.prc.removeSubcontext(RelyingPartyContext.class);
        AuthenticationContext authCtx = (AuthenticationContext)this.prc.ensureSubcontext(AuthenticationContext.class);
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidRelyingPartyContext");
        assert (authCtx != null);
        Assert.assertNull((Object)authCtx.getSubcontext(RequestedPrincipalContext.class));
    }

    @Test
    public void testNoProfileConfiguration() throws Exception {
        AuthenticationContext authCtx = (AuthenticationContext)this.prc.ensureSubcontext(AuthenticationContext.class);
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidProfileConfiguration");
        Assert.assertNull((Object)authCtx.getSubcontext(RequestedPrincipalContext.class));
    }

    @Test
    public void testInvalidProfileConfiguration() throws Exception {
        this.src = new RequestContextBuilder().setRelyingPartyProfileConfigurations((Collection)CollectionSupport.singleton((Object)new MockProfileConfiguration("mock"))).buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(this.src);
        AuthenticationContext authCtx = (AuthenticationContext)this.prc.ensureSubcontext(AuthenticationContext.class);
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidProfileConfiguration");
        assert (authCtx != null);
        Assert.assertNull((Object)authCtx.getSubcontext(RequestedPrincipalContext.class));
    }

    @Test
    public void testNoMethods() throws Exception {
        MockAuthenticationProfileConfiguration mock = new MockAuthenticationProfileConfiguration("mock", CollectionSupport.emptyList());
        this.src = new RequestContextBuilder().setRelyingPartyProfileConfigurations((Collection)CollectionSupport.singleton((Object)mock)).buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(this.src);
        AuthenticationContext authCtx = (AuthenticationContext)this.prc.ensureSubcontext(AuthenticationContext.class);
        ((RequestedPrincipalContext)authCtx.ensureSubcontext(RequestedPrincipalContext.class)).setOperator("foo");
        this.action = new InitializeRequestedPrincipalContext();
        this.action.setReplaceExistingContext(true);
        this.action.initialize();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        RequestedPrincipalContext rpc = (RequestedPrincipalContext)authCtx.getSubcontext(RequestedPrincipalContext.class);
        assert (rpc != null);
        Assert.assertEquals((String)rpc.getOperator(), (String)"foo");
    }

    @Test
    public void testWithMethods() throws Exception {
        TestPrincipal method = new TestPrincipal("test");
        MockAuthenticationProfileConfiguration mock = new MockAuthenticationProfileConfiguration("mock", CollectionSupport.singletonList((Object)method));
        this.src = new RequestContextBuilder().setRelyingPartyProfileConfigurations((Collection)CollectionSupport.singleton((Object)mock)).buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(this.src);
        AuthenticationContext authCtx = (AuthenticationContext)this.prc.ensureSubcontext(AuthenticationContext.class);
        ((RequestedPrincipalContext)authCtx.ensureSubcontext(RequestedPrincipalContext.class)).setOperator("foo");
        this.action = new InitializeRequestedPrincipalContext();
        this.action.setReplaceExistingContext(true);
        this.action.initialize();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        RequestedPrincipalContext rpCtx = (RequestedPrincipalContext)authCtx.ensureSubcontext(RequestedPrincipalContext.class);
        assert (rpCtx != null);
        Assert.assertEquals((String)rpCtx.getOperator(), (String)"exact");
        Assert.assertEquals((int)rpCtx.getRequestedPrincipals().size(), (int)1);
        Assert.assertSame((Object)method, rpCtx.getRequestedPrincipals().get(0));
    }
}

