/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import java.util.regex.Pattern;
import javax.security.auth.login.LoginException;
import net.shibboleth.idp.authn.AbstractAuthenticationAction;
import net.shibboleth.idp.authn.AuthenticationFlowDescriptor;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.AuthenticationErrorContext;
import net.shibboleth.idp.authn.context.RequestedPrincipalContext;
import net.shibboleth.idp.authn.context.UsernamePasswordContext;
import net.shibboleth.idp.authn.impl.ExtractUsernamePasswordFromFormRequest;
import net.shibboleth.idp.authn.impl.JAASCredentialValidator;
import net.shibboleth.idp.authn.impl.ValidateCredentials;
import net.shibboleth.idp.authn.impl.testing.BaseAuthenticationContextTest;
import net.shibboleth.idp.authn.principal.PrincipalEvalPredicateFactory;
import net.shibboleth.idp.authn.principal.UsernamePrincipal;
import net.shibboleth.idp.authn.principal.impl.ExactPrincipalEvalPredicateFactory;
import net.shibboleth.idp.authn.testing.TestPrincipal;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.collection.Pair;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.net.URISupport;
import net.shibboleth.shared.primitive.NonnullSupplier;
import net.shibboleth.shared.spring.resource.ResourceHelper;
import net.shibboleth.shared.testing.ConstantSupplier;
import net.shibboleth.shared.testing.InMemoryDirectory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.webflow.execution.Event;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class JAASCredentialValidatorTest
extends BaseAuthenticationContextTest {
    private static final String DATA_PATH = "src/test/resources/net/shibboleth/idp/authn/impl/";
    private static final String DATA_CLASSPATH = "/net/shibboleth/idp/authn/impl/";
    private JAASCredentialValidator validator;
    private ValidateCredentials action;
    private InMemoryDirectory directoryServer;

    @BeforeClass
    public void setupDirectoryServer() {
        this.directoryServer = new InMemoryDirectory(new String[]{"dc=shibboleth,dc=net"}, (Resource)new ClassPathResource("/net/shibboleth/idp/authn/impl/loginLDAPTest.ldif"), 10389);
        this.directoryServer.start();
    }

    @AfterClass
    public void teardownDirectoryServer() throws Exception {
        if (this.directoryServer.openConnectionCount() > 0L) {
            Thread.sleep(100L);
        }
        Assert.assertEquals((long)this.directoryServer.openConnectionCount(), (long)0L);
        this.directoryServer.stop(true);
    }

    @Override
    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        super.setUp();
        this.validator = new JAASCredentialValidator();
        this.validator.setId("jaastest");
        this.action = new ValidateCredentials();
        assert (this.validator != null);
        this.action.setValidators(CollectionSupport.singletonList((Object)this.validator));
        HashMap<String, Set> mappings = new HashMap<String, Set>();
        mappings.put("UnknownUsername", CollectionSupport.singleton((Object)"DN_RESOLUTION_FAILURE"));
        mappings.put("InvalidPassword", CollectionSupport.singleton((Object)"INVALID_CREDENTIALS"));
        this.action.setClassifiedMessages(mappings);
        MockHttpServletRequest request = new MockHttpServletRequest();
        this.action.setHttpServletRequestSupplier((NonnullSupplier)new ConstantSupplier((Object)request));
    }

    @Test
    public void testMissingFlow() throws ComponentInitializationException {
        this.validator.initialize();
        this.action.initialize();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidAuthenticationContext");
    }

    @Test
    public void testMissingUser() throws ComponentInitializationException {
        AuthenticationContext ac = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (ac != null);
        ac.setAttemptedFlow((AuthenticationFlowDescriptor)this.authenticationFlows.get(0));
        this.validator.initialize();
        this.action.initialize();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"NoCredentials");
    }

    @Test
    public void testMissingUser2() throws ComponentInitializationException {
        AuthenticationContext ac = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (ac != null);
        ac.setAttemptedFlow((AuthenticationFlowDescriptor)this.authenticationFlows.get(0));
        ac.ensureSubcontext(UsernamePasswordContext.class);
        this.validator.initialize();
        this.action.initialize();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"NoCredentials");
    }

    @Test
    public void testNoConfig() throws ComponentInitializationException {
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("username", "foo");
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("password", "bar");
        AuthenticationContext ac = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (ac != null);
        ac.setAttemptedFlow((AuthenticationFlowDescriptor)this.authenticationFlows.get(0));
        this.validator.initialize();
        this.action.initialize();
        this.doExtract();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidCredentials");
        AuthenticationErrorContext errorCtx = (AuthenticationErrorContext)ac.getSubcontext(AuthenticationErrorContext.class);
        assert (errorCtx != null);
        Assert.assertEquals((int)errorCtx.getExceptions().size(), (int)1);
        Assert.assertTrue((boolean)(errorCtx.getExceptions().get(0) instanceof LoginException));
    }

    @Test
    public void testBadConfig() throws ComponentInitializationException, URISyntaxException, IOException {
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("username", "foo");
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("password", "bar");
        AuthenticationContext ac = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (ac != null);
        ac.setAttemptedFlow((AuthenticationFlowDescriptor)this.authenticationFlows.get(0));
        this.validator.setLoginConfigNames((Collection)CollectionSupport.singletonList((Object)"ShibBadAuth"));
        this.validator.setLoginConfigType("JavaLoginConfig");
        this.validator.setLoginConfigParameters(URISupport.fileURIFromAbsolutePath((String)(this.getCurrentDir() + "/src/test/resources/net/shibboleth/idp/authn/impl/jaas.config")));
        this.validator.initialize();
        this.action.initialize();
        this.doExtract();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidCredentials");
        AuthenticationErrorContext errorCtx = (AuthenticationErrorContext)ac.getSubcontext(AuthenticationErrorContext.class);
        assert (errorCtx != null);
        Assert.assertEquals((int)errorCtx.getExceptions().size(), (int)1);
        Assert.assertTrue((boolean)(errorCtx.getExceptions().get(0) instanceof LoginException));
    }

    @Test
    public void testUnsupportedConfig() throws ComponentInitializationException, URISyntaxException, IOException {
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("username", "foo");
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("password", "bar");
        AuthenticationContext ac = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (ac != null);
        ac.setAttemptedFlow((AuthenticationFlowDescriptor)this.authenticationFlows.get(0));
        RequestedPrincipalContext rpc = (RequestedPrincipalContext)ac.ensureSubcontext(RequestedPrincipalContext.class);
        assert (rpc != null);
        rpc.getPrincipalEvalPredicateFactoryRegistry().register(TestPrincipal.class, "exact", (PrincipalEvalPredicateFactory)new ExactPrincipalEvalPredicateFactory());
        rpc.setOperator("exact");
        rpc.setRequestedPrincipals(CollectionSupport.singletonList((Object)new TestPrincipal("test1")));
        this.validator.setLoginConfigurations((Collection)CollectionSupport.singletonList((Object)new Pair((Object)"ShibUserPassAuth", (Object)CollectionSupport.singletonList((Object)new TestPrincipal("test2")))));
        this.validator.setLoginConfigType("JavaLoginConfig");
        this.validator.setLoginConfigParameters(URISupport.fileURIFromAbsolutePath((String)(this.getCurrentDir() + "/src/test/resources/net/shibboleth/idp/authn/impl/jaas.config")));
        this.validator.initialize();
        this.action.initialize();
        this.doExtract();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"RequestUnsupported");
    }

    @Test
    public void testUnmatchedUser() throws ComponentInitializationException {
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("username", "foo");
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("password", "bar");
        AuthenticationContext ac = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (ac != null);
        ac.setAttemptedFlow((AuthenticationFlowDescriptor)this.authenticationFlows.get(0));
        ac.ensureSubcontext(UsernamePasswordContext.class);
        this.validator.setMatchExpression(Pattern.compile("foo.+"));
        this.validator.initialize();
        this.action.initialize();
        this.doExtract();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"RequestUnsupported");
    }

    @Test
    public void testBadUsername() throws ComponentInitializationException {
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("username", "foo");
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("password", "bar");
        AuthenticationContext ac = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (ac != null);
        ac.setAttemptedFlow((AuthenticationFlowDescriptor)this.authenticationFlows.get(0));
        this.validator.setLoginConfigType("JavaLoginConfig");
        this.validator.setLoginConfigResource(ResourceHelper.of((Resource)new ClassPathResource("/net/shibboleth/idp/authn/impl/jaas.config")));
        this.validator.initialize();
        this.action.initialize();
        this.doExtract();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"UnknownUsername");
        AuthenticationErrorContext errorCtx = (AuthenticationErrorContext)ac.getSubcontext(AuthenticationErrorContext.class);
        assert (errorCtx != null);
        Assert.assertTrue((boolean)(errorCtx.getExceptions().get(0) instanceof LoginException));
        Assert.assertTrue((boolean)errorCtx.isClassifiedError("UnknownUsername"));
        Assert.assertFalse((boolean)errorCtx.isClassifiedError("InvalidPassword"));
    }

    @Test
    public void testBadPassword() throws ComponentInitializationException {
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("username", "PETER_THE_PRINCIPAL");
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("password", "bar");
        AuthenticationContext ac = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (ac != null);
        ac.setAttemptedFlow((AuthenticationFlowDescriptor)this.authenticationFlows.get(0));
        this.validator.setLoginConfigType("JavaLoginConfig");
        this.validator.setLoginConfigResource(ResourceHelper.of((Resource)new ClassPathResource("/net/shibboleth/idp/authn/impl/jaas.config")));
        this.validator.initialize();
        this.action.initialize();
        this.doExtract();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidPassword");
        AuthenticationErrorContext errorCtx = (AuthenticationErrorContext)ac.getSubcontext(AuthenticationErrorContext.class);
        assert (errorCtx != null);
        Assert.assertTrue((boolean)(errorCtx.getExceptions().get(0) instanceof LoginException));
        Assert.assertFalse((boolean)errorCtx.isClassifiedError("UnknownUsername"));
        Assert.assertTrue((boolean)errorCtx.isClassifiedError("InvalidPassword"));
    }

    @Test
    public void testAuthorized() throws ComponentInitializationException, URISyntaxException, IOException {
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("username", "PETER_THE_PRINCIPAL");
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("password", "changeit");
        AuthenticationContext ac = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (ac != null);
        ac.setAttemptedFlow((AuthenticationFlowDescriptor)this.authenticationFlows.get(0));
        this.validator.setLoginConfigType("JavaLoginConfig");
        this.validator.setLoginConfigParameters(URISupport.fileURIFromAbsolutePath((String)(this.getCurrentDir() + "/src/test/resources/net/shibboleth/idp/authn/impl/jaas.config")));
        this.validator.initialize();
        this.action.initialize();
        this.doExtract();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        AuthenticationResult ar = ac.getAuthenticationResult();
        assert (ar != null);
        Assert.assertEquals((String)ar.getSubject().getPrincipals(UsernamePrincipal.class).iterator().next().getName(), (String)"PETER_THE_PRINCIPAL");
    }

    @Test
    public void testAuthorizedAndKeep() throws ComponentInitializationException {
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("username", "PETER_THE_PRINCIPAL");
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("password", "changeit");
        AuthenticationContext ac = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (ac != null);
        ac.setAttemptedFlow((AuthenticationFlowDescriptor)this.authenticationFlows.get(0));
        this.validator.setLoginConfigType("JavaLoginConfig");
        this.validator.setLoginConfigResource(ResourceHelper.of((Resource)new ClassPathResource("/net/shibboleth/idp/authn/impl/jaas.config")));
        this.validator.initialize();
        this.action.initialize();
        this.doExtract();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        AuthenticationResult ar = ac.getAuthenticationResult();
        assert (ar != null);
        Assert.assertEquals((String)ar.getSubject().getPrincipals(UsernamePrincipal.class).iterator().next().getName(), (String)"PETER_THE_PRINCIPAL");
    }

    @Test
    public void testSupported() throws ComponentInitializationException {
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("username", "PETER_THE_PRINCIPAL");
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("password", "changeit");
        AuthenticationContext ac = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (ac != null);
        ac.setAttemptedFlow((AuthenticationFlowDescriptor)this.authenticationFlows.get(0));
        RequestedPrincipalContext rpc = (RequestedPrincipalContext)ac.ensureSubcontext(RequestedPrincipalContext.class);
        rpc.getPrincipalEvalPredicateFactoryRegistry().register(TestPrincipal.class, "exact", (PrincipalEvalPredicateFactory)new ExactPrincipalEvalPredicateFactory());
        rpc.setOperator("exact");
        rpc.setRequestedPrincipals(CollectionSupport.singletonList((Object)new TestPrincipal("test1")));
        this.validator.setLoginConfigurations((Collection)CollectionSupport.singletonList((Object)new Pair((Object)"ShibUserPassAuth", (Object)CollectionSupport.singletonList((Object)new TestPrincipal("test1")))));
        this.validator.setLoginConfigType("JavaLoginConfig");
        this.validator.setLoginConfigResource(ResourceHelper.of((Resource)new ClassPathResource("/net/shibboleth/idp/authn/impl/jaas.config")));
        this.validator.initialize();
        this.action.initialize();
        this.doExtract();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        AuthenticationResult ar = ac.getAuthenticationResult();
        assert (ar != null);
        Assert.assertEquals((String)ar.getSubject().getPrincipals(UsernamePrincipal.class).iterator().next().getName(), (String)"PETER_THE_PRINCIPAL");
        Assert.assertEquals((String)ar.getSubject().getPrincipals(TestPrincipal.class).iterator().next().getName(), (String)"test1");
    }

    @Test
    public void testMultiConfigAuthorized() throws ComponentInitializationException {
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("username", "PETER_THE_PRINCIPAL");
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("password", "changeit");
        AuthenticationContext ac = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (ac != null);
        ac.setAttemptedFlow((AuthenticationFlowDescriptor)this.authenticationFlows.get(0));
        this.validator.setLoginConfigNames(Arrays.asList("ShibBadAuth", "ShibUserPassAuth"));
        this.validator.setLoginConfigType("JavaLoginConfig");
        this.validator.setLoginConfigResource(ResourceHelper.of((Resource)new ClassPathResource("/net/shibboleth/idp/authn/impl/jaas.config")));
        this.validator.initialize();
        this.action.initialize();
        this.doExtract();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        AuthenticationResult ar = ac.getAuthenticationResult();
        assert (ar != null);
        Assert.assertEquals((String)ar.getSubject().getPrincipals(UsernamePrincipal.class).iterator().next().getName(), (String)"PETER_THE_PRINCIPAL");
    }

    @Test
    public void testMatchAndAuthorized() throws ComponentInitializationException {
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("username", "PETER_THE_PRINCIPAL");
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("password", "changeit");
        AuthenticationContext ac = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (ac != null);
        ac.setAttemptedFlow((AuthenticationFlowDescriptor)this.authenticationFlows.get(0));
        this.validator.setLoginConfigType("JavaLoginConfig");
        this.validator.setLoginConfigResource(ResourceHelper.of((Resource)new ClassPathResource("/net/shibboleth/idp/authn/impl/jaas.config")));
        this.validator.setMatchExpression(Pattern.compile(".+_THE_.+"));
        this.validator.initialize();
        this.action.initialize();
        this.doExtract();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        AuthenticationResult ar = ac.getAuthenticationResult();
        assert (ar != null);
        Assert.assertEquals((String)ar.getSubject().getPrincipals(UsernamePrincipal.class).iterator().next().getName(), (String)"PETER_THE_PRINCIPAL");
    }

    private void doExtract() throws ComponentInitializationException {
        ExtractUsernamePasswordFromFormRequest extract = new ExtractUsernamePasswordFromFormRequest();
        extract.setHttpServletRequestSupplier(this.action.getHttpServletRequestSupplier());
        extract.initialize();
        extract.execute(this.src);
    }

    private String getCurrentDir() throws IOException {
        String currentDir = new File(".").getCanonicalPath();
        return currentDir.replace(File.separatorChar, '/');
    }
}

