/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import java.io.File;
import java.net.URISyntaxException;
import javax.annotation.Nonnull;
import net.shibboleth.idp.authn.impl.KeystoreResourceCredentialConfig;
import net.shibboleth.idp.authn.impl.X509ResourceCredentialConfigTest;
import net.shibboleth.shared.spring.resource.ResourceHelper;
import org.ldaptive.ssl.SSLContextInitializer;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class KeystoreResourceCredentialConfigTest {
    @Nonnull
    private static final String DATAPATH = "/net/shibboleth/idp/authn/impl/";

    @DataProvider(name="resources")
    public Object[][] getResources() throws Exception {
        return new Object[][]{{KeystoreResourceCredentialConfigTest.getFileSystemResource("/net/shibboleth/idp/authn/impl/truststore.jks"), KeystoreResourceCredentialConfigTest.getFileSystemResource("/net/shibboleth/idp/authn/impl/keystore.jks")}, {ResourceHelper.of((Resource)new ClassPathResource("/net/shibboleth/idp/authn/impl/truststore.jks")), ResourceHelper.of((Resource)new ClassPathResource("/net/shibboleth/idp/authn/impl/keystore.jks"))}};
    }

    @Test(dataProvider="resources")
    public void createSSLContextInitializer(@Nonnull net.shibboleth.shared.resource.Resource truststore, @Nonnull net.shibboleth.shared.resource.Resource keystore) throws Exception {
        KeystoreResourceCredentialConfig config = new KeystoreResourceCredentialConfig();
        config.setTruststore(truststore);
        config.setKeystore(keystore);
        config.setKeystorePassword("changeit");
        SSLContextInitializer init = config.createSSLContextInitializer();
        Assert.assertNotNull((Object)init.getTrustManagers()[0]);
        Assert.assertNotNull((Object)init.getKeyManagers()[0]);
    }

    @Nonnull
    private static net.shibboleth.shared.resource.Resource getFileSystemResource(@Nonnull String path) throws URISyntaxException {
        return ResourceHelper.of((Resource)new FileSystemResource(new File(X509ResourceCredentialConfigTest.class.getResource(path).toURI())));
    }
}

