/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.function.Function;
import java.util.regex.Pattern;
import net.shibboleth.idp.authn.AbstractAuthenticationAction;
import net.shibboleth.idp.authn.AuthenticationFlowDescriptor;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.idp.authn.TemplateSearchDnResolver;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.AuthenticationErrorContext;
import net.shibboleth.idp.authn.context.AuthenticationWarningContext;
import net.shibboleth.idp.authn.context.LDAPResponseContext;
import net.shibboleth.idp.authn.context.UsernamePasswordContext;
import net.shibboleth.idp.authn.impl.ExtractUsernamePasswordFromFormRequest;
import net.shibboleth.idp.authn.impl.LDAPCredentialValidator;
import net.shibboleth.idp.authn.impl.ValidateCredentials;
import net.shibboleth.idp.authn.impl.testing.BaseAuthenticationContextTest;
import net.shibboleth.idp.authn.principal.UsernamePrincipal;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.primitive.NonnullSupplier;
import net.shibboleth.shared.testing.ConstantSupplier;
import net.shibboleth.shared.testing.InMemoryDirectory;
import net.shibboleth.shared.testing.VelocityEngine;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.DefaultConnectionFactory;
import org.ldaptive.auth.AccountState;
import org.ldaptive.auth.AuthenticationHandler;
import org.ldaptive.auth.AuthenticationResponse;
import org.ldaptive.auth.AuthenticationResponseHandler;
import org.ldaptive.auth.AuthenticationResultCode;
import org.ldaptive.auth.Authenticator;
import org.ldaptive.auth.DnResolver;
import org.ldaptive.auth.FormatDnResolver;
import org.ldaptive.auth.SearchDnResolver;
import org.ldaptive.auth.SimpleBindAuthenticationHandler;
import org.ldaptive.auth.ext.PasswordPolicyAccountState;
import org.ldaptive.control.PasswordPolicyControl;
import org.ldaptive.jaas.LdapPrincipal;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.webflow.execution.Event;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class LDAPCredentialValidatorTest
extends BaseAuthenticationContextTest {
    private static final String DATA_PATH = "/net/shibboleth/idp/authn/impl/";
    private LDAPCredentialValidator validator;
    private ValidateCredentials action;
    private InMemoryDirectory directoryServer;
    private TemplateSearchDnResolver dnResolver;
    private SimpleBindAuthenticationHandler authHandler;
    private Authenticator authenticator;

    @BeforeClass
    public void setupDirectoryServer() {
        this.directoryServer = new InMemoryDirectory(new String[]{"dc=shibboleth,dc=net"}, (Resource)new ClassPathResource("/net/shibboleth/idp/authn/impl/loginLDAPTest.ldif"), 10389);
        this.directoryServer.start();
    }

    @BeforeClass
    public void setupAuthenticator() {
        this.dnResolver = new TemplateSearchDnResolver((ConnectionFactory)new DefaultConnectionFactory("ldap://localhost:10389"), VelocityEngine.newVelocityEngine(), "(uid=$usernamePasswordContext.username)");
        this.dnResolver.setBaseDn("ou=people,dc=shibboleth,dc=net");
        this.authHandler = new SimpleBindAuthenticationHandler((ConnectionFactory)new DefaultConnectionFactory("ldap://localhost:10389"));
        this.authenticator = new Authenticator((DnResolver)this.dnResolver, (AuthenticationHandler)this.authHandler);
    }

    @AfterClass
    public void teardownDirectoryServer() throws Exception {
        if (this.directoryServer.openConnectionCount() > 0L) {
            Thread.sleep(100L);
        }
        Assert.assertEquals((long)this.directoryServer.openConnectionCount(), (long)0L);
        this.directoryServer.stop(true);
    }

    @Override
    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        super.setUp();
        this.validator = new LDAPCredentialValidator();
        this.validator.setId("ldaptest");
        this.action = new ValidateCredentials();
        assert (this.validator != null);
        this.action.setValidators(CollectionSupport.singletonList((Object)this.validator));
        HashMap mappings = new HashMap();
        mappings.put("UnknownUsername", CollectionSupport.listOf((Object)"DN_RESOLUTION_FAILURE", (Object)"INVALID_DN_SYNTAX"));
        mappings.put("InvalidPassword", CollectionSupport.singleton((Object)"INVALID_CREDENTIALS"));
        mappings.put("ExpiringPassword", CollectionSupport.singleton((Object)"ACCOUNT_WARNING"));
        mappings.put("ExpiredPassword", CollectionSupport.listOf((Object)"PASSWORD_EXPIRED", (Object)"CHANGE_AFTER_RESET"));
        this.action.setClassifiedMessages(mappings);
        MockHttpServletRequest request = new MockHttpServletRequest();
        this.action.setHttpServletRequestSupplier((NonnullSupplier)new ConstantSupplier((Object)request));
    }

    @Test
    public void testMissingFlow() throws ComponentInitializationException {
        this.validator.setAuthenticator(this.authenticator);
        this.validator.initialize();
        this.action.initialize();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidAuthenticationContext");
    }

    @Test
    public void testMissingUser() throws ComponentInitializationException {
        AuthenticationContext ac = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (ac != null);
        ac.setAttemptedFlow((AuthenticationFlowDescriptor)this.authenticationFlows.get(0));
        this.validator.setAuthenticator(this.authenticator);
        this.validator.initialize();
        this.action.initialize();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"NoCredentials");
    }

    @Test
    public void testMissingUser2() throws ComponentInitializationException {
        AuthenticationContext ac = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (ac != null);
        ac.setAttemptedFlow((AuthenticationFlowDescriptor)this.authenticationFlows.get(0));
        ac.ensureSubcontext(UsernamePasswordContext.class);
        this.validator.setAuthenticator(this.authenticator);
        this.validator.initialize();
        this.action.initialize();
        Event event = this.action.execute(this.src);
        Assert.assertNull((Object)ac.getAuthenticationResult());
        Assert.assertNull((Object)ac.getSubcontext(LDAPResponseContext.class));
        ActionTestingSupport.assertEvent((Event)event, (String)"NoCredentials");
        AuthenticationErrorContext aec = (AuthenticationErrorContext)ac.getSubcontext(AuthenticationErrorContext.class);
        assert (aec != null);
        Assert.assertTrue((boolean)aec.isClassifiedError("NoCredentials"));
    }

    @Test
    public void testUnmatchedUser() throws ComponentInitializationException {
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("username", "foo");
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("password", "bar");
        AuthenticationContext ac = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (ac != null);
        ac.setAttemptedFlow((AuthenticationFlowDescriptor)this.authenticationFlows.get(0));
        ac.ensureSubcontext(UsernamePasswordContext.class);
        this.validator.setAuthenticator(this.authenticator);
        this.validator.setMatchExpression(Pattern.compile("foo.+"));
        this.validator.initialize();
        this.action.initialize();
        this.doExtract();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"RequestUnsupported");
    }

    @Test
    public void testBadConfigInvalidDnResolver() throws ComponentInitializationException {
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("username", "foo");
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("password", "changeit");
        AuthenticationContext ac = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (ac != null);
        ac.setAttemptedFlow((AuthenticationFlowDescriptor)this.authenticationFlows.get(0));
        this.validator.setAuthenticator(new Authenticator((DnResolver)new SearchDnResolver(), (AuthenticationHandler)this.authHandler));
        this.validator.initialize();
        this.action.initialize();
        this.doExtract();
        Event event = this.action.execute(this.src);
        Assert.assertNull((Object)ac.getAuthenticationResult());
        LDAPResponseContext lrc = (LDAPResponseContext)ac.getSubcontext(LDAPResponseContext.class);
        assert (lrc != null);
        AuthenticationResponse lar = lrc.getAuthenticationResponse();
        assert (lar != null);
        Assert.assertEquals((Object)lar.getAuthenticationResultCode(), (Object)AuthenticationResultCode.DN_RESOLUTION_FAILURE);
        AuthenticationErrorContext aec = (AuthenticationErrorContext)ac.getSubcontext(AuthenticationErrorContext.class);
        assert (aec != null);
        ActionTestingSupport.assertEvent((Event)event, (String)"UnknownUsername");
        Assert.assertEquals((int)aec.getClassifiedErrors().size(), (int)1);
        Assert.assertTrue((boolean)aec.isClassifiedError("UnknownUsername"));
    }

    @Test
    public void testBadConfigUnknownHost() throws ComponentInitializationException {
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("username", "PETER_THE_PRINCIPAL");
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("password", "bar");
        AuthenticationContext ac = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (ac != null);
        ac.setAttemptedFlow((AuthenticationFlowDescriptor)this.authenticationFlows.get(0));
        this.validator.setAuthenticator(new Authenticator((DnResolver)this.dnResolver, (AuthenticationHandler)new SimpleBindAuthenticationHandler((ConnectionFactory)new DefaultConnectionFactory("ldap://unknown:389"))));
        this.validator.initialize();
        this.action.initialize();
        this.doExtract();
        Event event = this.action.execute(this.src);
        Assert.assertNull((Object)ac.getAuthenticationResult());
        Assert.assertNull((Object)ac.getSubcontext(LDAPResponseContext.class));
        AuthenticationErrorContext aec = (AuthenticationErrorContext)ac.getSubcontext(AuthenticationErrorContext.class);
        assert (aec != null);
        ActionTestingSupport.assertEvent((Event)event, (String)"AuthenticationException");
        Assert.assertEquals((int)aec.getExceptions().size(), (int)1);
        Assert.assertEquals((int)aec.getClassifiedErrors().size(), (int)1);
        Assert.assertTrue((boolean)aec.isClassifiedError("AuthenticationException"));
    }

    @Test
    public void testBadUsername() throws ComponentInitializationException {
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("username", "foo");
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("password", "bar");
        AuthenticationContext ac = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (ac != null);
        ac.setAttemptedFlow((AuthenticationFlowDescriptor)this.authenticationFlows.get(0));
        this.validator.setAuthenticator(this.authenticator);
        this.validator.initialize();
        this.action.initialize();
        this.doExtract();
        Event event = this.action.execute(this.src);
        Assert.assertNull((Object)ac.getAuthenticationResult());
        LDAPResponseContext lrc = (LDAPResponseContext)ac.getSubcontext(LDAPResponseContext.class);
        assert (lrc != null);
        AuthenticationResponse lar = lrc.getAuthenticationResponse();
        assert (lar != null);
        Assert.assertEquals((Object)lar.getAuthenticationResultCode(), (Object)AuthenticationResultCode.DN_RESOLUTION_FAILURE);
        AuthenticationErrorContext aec = (AuthenticationErrorContext)ac.getSubcontext(AuthenticationErrorContext.class);
        assert (aec != null);
        ActionTestingSupport.assertEvent((Event)event, (String)"UnknownUsername");
        Assert.assertEquals((int)aec.getClassifiedErrors().size(), (int)1);
        Assert.assertTrue((boolean)aec.isClassifiedError("UnknownUsername"));
    }

    @Test
    public void testBadUsernameAuthnException() throws ComponentInitializationException {
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("username", "foo");
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("password", "bar");
        AuthenticationContext ac = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (ac != null);
        ac.setAttemptedFlow((AuthenticationFlowDescriptor)this.authenticationFlows.get(0));
        Authenticator directBindAuthenticator = new Authenticator((DnResolver)new FormatDnResolver("cn=%s,ou,dc=shibboleth,dc=net"), (AuthenticationHandler)this.authHandler);
        this.validator.setAuthenticator(directBindAuthenticator);
        this.validator.initialize();
        this.action.initialize();
        this.doExtract();
        Event event = this.action.execute(this.src);
        Assert.assertNull((Object)ac.getAuthenticationResult());
        LDAPResponseContext lrc = (LDAPResponseContext)ac.getSubcontext(LDAPResponseContext.class);
        assert (lrc != null);
        AuthenticationResponse lar = lrc.getAuthenticationResponse();
        assert (lar != null);
        Assert.assertEquals((Object)lar.getAuthenticationResultCode(), (Object)AuthenticationResultCode.AUTHENTICATION_HANDLER_FAILURE);
        AuthenticationErrorContext aec = (AuthenticationErrorContext)ac.getSubcontext(AuthenticationErrorContext.class);
        assert (aec != null);
        ActionTestingSupport.assertEvent((Event)event, (String)"UnknownUsername");
        Assert.assertEquals((int)aec.getClassifiedErrors().size(), (int)1);
        Assert.assertTrue((boolean)aec.isClassifiedError("UnknownUsername"));
    }

    @Test
    public void testEmptyPassword() throws ComponentInitializationException {
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("username", "PETER_THE_PRINCIPAL");
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("password", "");
        AuthenticationContext ac = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (ac != null);
        ac.setAttemptedFlow((AuthenticationFlowDescriptor)this.authenticationFlows.get(0));
        this.validator.setAuthenticator(this.authenticator);
        this.validator.initialize();
        this.action.initialize();
        this.doExtract();
        Event event = this.action.execute(this.src);
        Assert.assertNull((Object)ac.getAuthenticationResult());
        Assert.assertNull((Object)ac.getSubcontext(LDAPResponseContext.class));
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidCredentials");
        AuthenticationErrorContext aec = (AuthenticationErrorContext)ac.getSubcontext(AuthenticationErrorContext.class);
        assert (aec != null);
        Assert.assertTrue((boolean)aec.isClassifiedError("InvalidCredentials"));
    }

    @Test
    public void testBadPassword() throws ComponentInitializationException {
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("username", "PETER_THE_PRINCIPAL");
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("password", "bar");
        AuthenticationContext ac = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (ac != null);
        ac.setAttemptedFlow((AuthenticationFlowDescriptor)this.authenticationFlows.get(0));
        this.validator.setAuthenticator(this.authenticator);
        this.validator.initialize();
        this.action.initialize();
        this.doExtract();
        Event event = this.action.execute(this.src);
        Assert.assertNull((Object)ac.getAuthenticationResult());
        LDAPResponseContext lrc = (LDAPResponseContext)ac.getSubcontext(LDAPResponseContext.class);
        assert (lrc != null);
        AuthenticationResponse lar = lrc.getAuthenticationResponse();
        assert (lar != null);
        Assert.assertEquals((Object)lar.getAuthenticationResultCode(), (Object)AuthenticationResultCode.AUTHENTICATION_HANDLER_FAILURE);
        AuthenticationErrorContext aec = (AuthenticationErrorContext)ac.getSubcontext(AuthenticationErrorContext.class);
        assert (aec != null);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidPassword");
        Assert.assertEquals((int)aec.getClassifiedErrors().size(), (int)1);
        Assert.assertTrue((boolean)aec.isClassifiedError("InvalidPassword"));
    }

    @Test
    public void testExpiredPassword() throws ComponentInitializationException {
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("username", "PETER_THE_PRINCIPAL");
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("password", "bar");
        AuthenticationContext ac = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (ac != null);
        ac.setAttemptedFlow((AuthenticationFlowDescriptor)this.authenticationFlows.get(0));
        Authenticator errorAuthenticator = new Authenticator((DnResolver)this.dnResolver, (AuthenticationHandler)this.authHandler);
        errorAuthenticator.setResponseHandlers(new AuthenticationResponseHandler[]{response -> response.setAccountState((AccountState)new PasswordPolicyAccountState(PasswordPolicyControl.Error.PASSWORD_EXPIRED))});
        this.validator.setAuthenticator(errorAuthenticator);
        this.validator.initialize();
        this.action.initialize();
        this.doExtract();
        Event event = this.action.execute(this.src);
        Assert.assertNull((Object)ac.getAuthenticationResult());
        LDAPResponseContext lrc = (LDAPResponseContext)ac.getSubcontext(LDAPResponseContext.class);
        assert (lrc != null);
        AuthenticationResponse lar = lrc.getAuthenticationResponse();
        assert (lar != null);
        Assert.assertEquals((Object)lar.getAuthenticationResultCode(), (Object)AuthenticationResultCode.AUTHENTICATION_HANDLER_FAILURE);
        AuthenticationErrorContext aec = (AuthenticationErrorContext)ac.getSubcontext(AuthenticationErrorContext.class);
        assert (aec != null);
        ActionTestingSupport.assertEvent((Event)event, (String)"ExpiredPassword");
        Assert.assertEquals((int)aec.getClassifiedErrors().size(), (int)2);
        Assert.assertTrue((boolean)aec.isClassifiedError("ExpiredPassword"));
        Assert.assertTrue((boolean)aec.isClassifiedError("InvalidPassword"));
    }

    @Test
    public void testChangeAfterReset() throws ComponentInitializationException {
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("username", "PETER_THE_PRINCIPAL");
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("password", "changeit");
        AuthenticationContext ac = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (ac != null);
        ac.setAttemptedFlow((AuthenticationFlowDescriptor)this.authenticationFlows.get(0));
        Authenticator errorAuthenticator = new Authenticator((DnResolver)this.dnResolver, (AuthenticationHandler)this.authHandler);
        errorAuthenticator.setResponseHandlers(new AuthenticationResponseHandler[]{response -> response.setAccountState((AccountState)new PasswordPolicyAccountState(PasswordPolicyControl.Error.CHANGE_AFTER_RESET))});
        this.validator.setAuthenticator(errorAuthenticator);
        this.validator.initialize();
        this.action.initialize();
        this.doExtract();
        Event event = this.action.execute(this.src);
        AuthenticationResult result = ac.getAuthenticationResult();
        LDAPResponseContext lrc = (LDAPResponseContext)ac.getSubcontext(LDAPResponseContext.class);
        assert (lrc != null);
        AuthenticationResponse lar = lrc.getAuthenticationResponse();
        assert (lar != null);
        Assert.assertEquals((Object)lar.getAuthenticationResultCode(), (Object)AuthenticationResultCode.AUTHENTICATION_HANDLER_SUCCESS);
        AuthenticationErrorContext aec = (AuthenticationErrorContext)ac.getSubcontext(AuthenticationErrorContext.class);
        Assert.assertNull((Object)aec);
        AuthenticationWarningContext awc = (AuthenticationWarningContext)ac.getSubcontext(AuthenticationWarningContext.class);
        assert (awc != null && result != null);
        ActionTestingSupport.assertEvent((Event)event, (String)"ExpiredPassword");
        Assert.assertEquals((int)awc.getClassifiedWarnings().size(), (int)1);
        Assert.assertTrue((boolean)awc.isClassifiedWarning("ExpiredPassword"));
        UsernamePrincipal up = result.getSubject().getPrincipals(UsernamePrincipal.class).iterator().next();
        Assert.assertNotNull((Object)up);
        Assert.assertEquals((String)up.getName(), (String)"PETER_THE_PRINCIPAL");
        LdapPrincipal lp = result.getSubject().getPrincipals(LdapPrincipal.class).iterator().next();
        Assert.assertNotNull((Object)lp);
        Assert.assertEquals((String)lp.getName(), (String)"PETER_THE_PRINCIPAL");
        Assert.assertNotNull((Object)lp.getLdapEntry());
    }

    @Test
    public void testExpiringPassword() throws ComponentInitializationException {
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("username", "PETER_THE_PRINCIPAL");
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("password", "changeit");
        AuthenticationContext ac = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (ac != null);
        ac.setAttemptedFlow((AuthenticationFlowDescriptor)this.authenticationFlows.get(0));
        Authenticator warningAuthenticator = new Authenticator((DnResolver)this.dnResolver, (AuthenticationHandler)this.authHandler);
        warningAuthenticator.setResponseHandlers(new AuthenticationResponseHandler[]{response -> response.setAccountState(new AccountState(new AccountState.Warning[]{new AccountState.DefaultWarning(ZonedDateTime.now(), 10)}))});
        this.validator.setAuthenticator(warningAuthenticator);
        this.validator.initialize();
        this.action.initialize();
        this.doExtract();
        Event event = this.action.execute(this.src);
        AuthenticationErrorContext aec = (AuthenticationErrorContext)ac.getSubcontext(AuthenticationErrorContext.class);
        Assert.assertNull((Object)aec);
        AuthenticationResult result = ac.getAuthenticationResult();
        Assert.assertNotNull((Object)result);
        LDAPResponseContext lrc = (LDAPResponseContext)ac.getSubcontext(LDAPResponseContext.class);
        assert (lrc != null);
        AuthenticationResponse lar = lrc.getAuthenticationResponse();
        assert (lar != null);
        Assert.assertEquals((Object)lar.getAuthenticationResultCode(), (Object)AuthenticationResultCode.AUTHENTICATION_HANDLER_SUCCESS);
        ActionTestingSupport.assertEvent((Event)event, (String)"ExpiringPassword");
        AuthenticationWarningContext awc = (AuthenticationWarningContext)ac.getSubcontext(AuthenticationWarningContext.class);
        assert (awc != null && result != null);
        Assert.assertEquals((int)awc.getClassifiedWarnings().size(), (int)1);
        Assert.assertTrue((boolean)awc.isClassifiedWarning("ExpiringPassword"));
        UsernamePrincipal up = result.getSubject().getPrincipals(UsernamePrincipal.class).iterator().next();
        Assert.assertNotNull((Object)up);
        Assert.assertEquals((String)up.getName(), (String)"PETER_THE_PRINCIPAL");
        LdapPrincipal lp = result.getSubject().getPrincipals(LdapPrincipal.class).iterator().next();
        Assert.assertNotNull((Object)lp);
        Assert.assertEquals((String)lp.getName(), (String)"PETER_THE_PRINCIPAL");
        Assert.assertNotNull((Object)lp.getLdapEntry());
    }

    @Test
    public void testAuthorized() throws ComponentInitializationException {
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("username", "PETER_THE_PRINCIPAL");
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("password", "changeit");
        AuthenticationContext ac = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (ac != null);
        ac.setAttemptedFlow((AuthenticationFlowDescriptor)this.authenticationFlows.get(0));
        this.validator.setAuthenticator(this.authenticator);
        this.validator.initialize();
        this.action.initialize();
        this.doExtract();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        AuthenticationErrorContext aec = (AuthenticationErrorContext)ac.getSubcontext(AuthenticationErrorContext.class);
        Assert.assertNull((Object)aec);
        AuthenticationResult result = ac.getAuthenticationResult();
        assert (result != null);
        LDAPResponseContext lrc = (LDAPResponseContext)ac.getSubcontext(LDAPResponseContext.class);
        assert (lrc != null);
        AuthenticationResponse lar = lrc.getAuthenticationResponse();
        assert (lar != null);
        Assert.assertEquals((Object)lar.getAuthenticationResultCode(), (Object)AuthenticationResultCode.AUTHENTICATION_HANDLER_SUCCESS);
        UsernamePrincipal up = result.getSubject().getPrincipals(UsernamePrincipal.class).iterator().next();
        Assert.assertNotNull((Object)up);
        Assert.assertEquals((String)up.getName(), (String)"PETER_THE_PRINCIPAL");
        LdapPrincipal lp = result.getSubject().getPrincipals(LdapPrincipal.class).iterator().next();
        Assert.assertNotNull((Object)lp);
        Assert.assertEquals((String)lp.getName(), (String)"PETER_THE_PRINCIPAL");
        Assert.assertNotNull((Object)lp.getLdapEntry());
    }

    @Test
    public void testComputedAndAuthorized() throws ComponentInitializationException {
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("username", "PETER_THE_PRINCIPAL");
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("password", "change");
        AuthenticationContext ac = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (ac != null);
        ac.setAttemptedFlow((AuthenticationFlowDescriptor)this.authenticationFlows.get(0));
        this.validator.setAuthenticator(this.authenticator);
        this.validator.setPasswordLookupStrategy((Function)new Function<ProfileRequestContext, char[]>(){

            @Override
            public char[] apply(ProfileRequestContext input) {
                AuthenticationContext ac = (AuthenticationContext)input.getSubcontext(AuthenticationContext.class);
                assert (ac != null);
                UsernamePasswordContext uc = (UsernamePasswordContext)ac.getSubcontext(UsernamePasswordContext.class);
                assert (uc != null);
                return (uc.getPassword() + "it").toCharArray();
            }
        });
        this.validator.initialize();
        this.action.initialize();
        this.doExtract();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        AuthenticationErrorContext aec = (AuthenticationErrorContext)ac.getSubcontext(AuthenticationErrorContext.class);
        Assert.assertNull((Object)aec);
        AuthenticationResult result = ac.getAuthenticationResult();
        assert (result != null);
        LDAPResponseContext lrc = (LDAPResponseContext)ac.getSubcontext(LDAPResponseContext.class);
        assert (lrc != null);
        AuthenticationResponse lar = lrc.getAuthenticationResponse();
        assert (lar != null);
        Assert.assertEquals((Object)lar.getAuthenticationResultCode(), (Object)AuthenticationResultCode.AUTHENTICATION_HANDLER_SUCCESS);
        UsernamePrincipal up = result.getSubject().getPrincipals(UsernamePrincipal.class).iterator().next();
        Assert.assertNotNull((Object)up);
        Assert.assertEquals((String)up.getName(), (String)"PETER_THE_PRINCIPAL");
        LdapPrincipal lp = result.getSubject().getPrincipals(LdapPrincipal.class).iterator().next();
        Assert.assertNotNull((Object)lp);
        Assert.assertEquals((String)lp.getName(), (String)"PETER_THE_PRINCIPAL");
        Assert.assertNotNull((Object)lp.getLdapEntry());
    }

    @Test
    public void testDefaultFilterSyntax() throws ComponentInitializationException {
        TemplateSearchDnResolver testResolver = new TemplateSearchDnResolver((ConnectionFactory)new DefaultConnectionFactory("ldap://localhost:10389"), VelocityEngine.newVelocityEngine(), "(uid={user})");
        testResolver.setBaseDn("ou=people,dc=shibboleth,dc=net");
        Authenticator defaultFilterAuthenticator = new Authenticator((DnResolver)testResolver, (AuthenticationHandler)this.authHandler);
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("username", "PETER_THE_PRINCIPAL");
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("password", "changeit");
        AuthenticationContext ac = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (ac != null);
        ac.setAttemptedFlow((AuthenticationFlowDescriptor)this.authenticationFlows.get(0));
        this.validator.setAuthenticator(defaultFilterAuthenticator);
        this.validator.initialize();
        this.action.initialize();
        this.doExtract();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        AuthenticationErrorContext aec = (AuthenticationErrorContext)ac.getSubcontext(AuthenticationErrorContext.class);
        Assert.assertNull((Object)aec);
        AuthenticationResult result = ac.getAuthenticationResult();
        assert (result != null);
        LDAPResponseContext lrc = (LDAPResponseContext)ac.getSubcontext(LDAPResponseContext.class);
        assert (lrc != null);
        AuthenticationResponse lar = lrc.getAuthenticationResponse();
        assert (lar != null);
        Assert.assertEquals((Object)lar.getAuthenticationResultCode(), (Object)AuthenticationResultCode.AUTHENTICATION_HANDLER_SUCCESS);
        UsernamePrincipal up = result.getSubject().getPrincipals(UsernamePrincipal.class).iterator().next();
        Assert.assertNotNull((Object)up);
        Assert.assertEquals((String)up.getName(), (String)"PETER_THE_PRINCIPAL");
        LdapPrincipal lp = result.getSubject().getPrincipals(LdapPrincipal.class).iterator().next();
        Assert.assertNotNull((Object)lp);
        Assert.assertEquals((String)lp.getName(), (String)"PETER_THE_PRINCIPAL");
        Assert.assertNotNull((Object)lp.getLdapEntry());
    }

    @Test
    public void testCombinedFilterSyntax() throws ComponentInitializationException {
        TemplateSearchDnResolver testResolver = new TemplateSearchDnResolver((ConnectionFactory)new DefaultConnectionFactory("ldap://localhost:10389"), VelocityEngine.newVelocityEngine(), "(|(mail=$usernamePasswordContext.username)(uid={user}))");
        testResolver.setBaseDn("ou=people,dc=shibboleth,dc=net");
        Authenticator defaultFilterAuthenticator = new Authenticator((DnResolver)testResolver, (AuthenticationHandler)this.authHandler);
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("username", "PETER_THE_PRINCIPAL");
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("password", "changeit");
        AuthenticationContext ac = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (ac != null);
        ac.setAttemptedFlow((AuthenticationFlowDescriptor)this.authenticationFlows.get(0));
        this.validator.setAuthenticator(defaultFilterAuthenticator);
        this.validator.initialize();
        this.action.initialize();
        this.doExtract();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        AuthenticationErrorContext aec = (AuthenticationErrorContext)ac.getSubcontext(AuthenticationErrorContext.class);
        Assert.assertNull((Object)aec);
        AuthenticationResult result = ac.getAuthenticationResult();
        assert (result != null);
        LDAPResponseContext lrc = (LDAPResponseContext)ac.getSubcontext(LDAPResponseContext.class);
        assert (lrc != null);
        AuthenticationResponse lar = lrc.getAuthenticationResponse();
        assert (lar != null);
        Assert.assertEquals((Object)lar.getAuthenticationResultCode(), (Object)AuthenticationResultCode.AUTHENTICATION_HANDLER_SUCCESS);
        UsernamePrincipal up = result.getSubject().getPrincipals(UsernamePrincipal.class).iterator().next();
        Assert.assertNotNull((Object)up);
        Assert.assertEquals((String)up.getName(), (String)"PETER_THE_PRINCIPAL");
        LdapPrincipal lp = result.getSubject().getPrincipals(LdapPrincipal.class).iterator().next();
        Assert.assertNotNull((Object)lp);
        Assert.assertEquals((String)lp.getName(), (String)"PETER_THE_PRINCIPAL");
        Assert.assertNotNull((Object)lp.getLdapEntry());
    }

    @Test
    public void testMatchAndAuthorized() throws ComponentInitializationException {
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("username", "PETER_THE_PRINCIPAL");
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("password", "changeit");
        AuthenticationContext ac = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (ac != null);
        ac.setAttemptedFlow((AuthenticationFlowDescriptor)this.authenticationFlows.get(0));
        this.validator.setAuthenticator(this.authenticator);
        this.validator.setMatchExpression(Pattern.compile(".+_THE_.+"));
        this.validator.initialize();
        this.action.initialize();
        this.doExtract();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        AuthenticationErrorContext aec = (AuthenticationErrorContext)ac.getSubcontext(AuthenticationErrorContext.class);
        Assert.assertNull((Object)aec);
        AuthenticationResult result = ac.getAuthenticationResult();
        assert (result != null);
        LDAPResponseContext lrc = (LDAPResponseContext)ac.getSubcontext(LDAPResponseContext.class);
        assert (lrc != null);
        AuthenticationResponse lar = lrc.getAuthenticationResponse();
        assert (lar != null);
        Assert.assertEquals((Object)lar.getAuthenticationResultCode(), (Object)AuthenticationResultCode.AUTHENTICATION_HANDLER_SUCCESS);
        UsernamePrincipal up = result.getSubject().getPrincipals(UsernamePrincipal.class).iterator().next();
        Assert.assertNotNull((Object)up);
        Assert.assertEquals((String)up.getName(), (String)"PETER_THE_PRINCIPAL");
        LdapPrincipal lp = result.getSubject().getPrincipals(LdapPrincipal.class).iterator().next();
        Assert.assertNotNull((Object)lp);
        Assert.assertEquals((String)lp.getName(), (String)"PETER_THE_PRINCIPAL");
        Assert.assertNotNull((Object)lp.getLdapEntry());
    }

    @Test
    public void testAuthorizedAndKeepContext() throws ComponentInitializationException {
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("username", "PETER_THE_PRINCIPAL");
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("password", "changeit");
        AuthenticationContext ac = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (ac != null);
        ac.setAttemptedFlow((AuthenticationFlowDescriptor)this.authenticationFlows.get(0));
        this.validator.setAuthenticator(this.authenticator);
        this.validator.initialize();
        this.action.initialize();
        this.doExtract();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
    }

    private void doExtract() throws ComponentInitializationException {
        ExtractUsernamePasswordFromFormRequest extract = new ExtractUsernamePasswordFromFormRequest();
        extract.setHttpServletRequestSupplier(this.action.getHttpServletRequestSupplier());
        extract.initialize();
        extract.execute(this.src);
    }
}

