/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.shibboleth.idp.authn.AuthenticationFlowDescriptor;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.impl.PopulateAuthenticationContext;
import net.shibboleth.idp.authn.impl.testing.BaseAuthenticationContextTest;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.FunctionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.testing.ActionTestingSupport;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public final class PopulateAuthenticationContextTest
extends BaseAuthenticationContextTest {
    @Override
    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        this.initializeMembers();
    }

    @Test
    public void testIdentical() throws ComponentInitializationException {
        PopulateAuthenticationContext action = new PopulateAuthenticationContext();
        action.setAvailableFlows((Collection)this.authenticationFlows);
        action.setPotentialFlowsLookupStrategy(FunctionSupport.constant((Object)this.authenticationFlows));
        action.initialize();
        action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
        AuthenticationContext authCtx = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (authCtx != null);
        Assert.assertEquals((int)authCtx.getAvailableFlows().size(), (int)3);
        Assert.assertNotNull(authCtx.getAvailableFlows().get("test1"));
        Assert.assertNotNull(authCtx.getAvailableFlows().get("test2"));
        Assert.assertNotNull(authCtx.getAvailableFlows().get("test3"));
        Assert.assertEquals((Map)authCtx.getPotentialFlows(), (Map)authCtx.getAvailableFlows());
    }

    @Test
    public void testNonIdentical() throws ComponentInitializationException {
        PopulateAuthenticationContext action = new PopulateAuthenticationContext();
        action.setAvailableFlows((Collection)this.authenticationFlows);
        AuthenticationFlowDescriptor unavailableFlow = new AuthenticationFlowDescriptor();
        unavailableFlow.setId("test4");
        action.setPotentialFlowsLookupStrategy(FunctionSupport.constant(List.of((AuthenticationFlowDescriptor)this.authenticationFlows.get(0), unavailableFlow)));
        action.initialize();
        action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
        AuthenticationContext authCtx = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (authCtx != null);
        Assert.assertEquals((int)authCtx.getAvailableFlows().size(), (int)3);
        Assert.assertNotNull(authCtx.getAvailableFlows().get("test1"));
        Assert.assertNotNull(authCtx.getAvailableFlows().get("test2"));
        Assert.assertNotNull(authCtx.getAvailableFlows().get("test3"));
        Assert.assertEquals((int)authCtx.getPotentialFlows().size(), (int)1);
        Assert.assertNotNull(authCtx.getPotentialFlows().get("test1"));
        Assert.assertNull(authCtx.getPotentialFlows().get("test2"));
        Assert.assertNull(authCtx.getPotentialFlows().get("test3"));
        Assert.assertNull(authCtx.getPotentialFlows().get("test4"));
    }

    @Test
    public void testFiltered() throws ComponentInitializationException {
        PopulateAuthenticationContext action = new PopulateAuthenticationContext();
        action.setAvailableFlows((Collection)this.authenticationFlows);
        action.setPotentialFlowsLookupStrategy(FunctionSupport.constant((Object)this.authenticationFlows));
        action.setActiveFlowsLookupStrategy(FunctionSupport.constant((Object)CollectionSupport.singletonList((Object)"test2")));
        action.initialize();
        action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
        AuthenticationContext authCtx = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (authCtx != null);
        Assert.assertEquals((int)authCtx.getAvailableFlows().size(), (int)3);
        Assert.assertNotNull(authCtx.getAvailableFlows().get("test1"));
        Assert.assertNotNull(authCtx.getAvailableFlows().get("test2"));
        Assert.assertNotNull(authCtx.getAvailableFlows().get("test3"));
        Assert.assertEquals((int)authCtx.getPotentialFlows().size(), (int)1);
        Assert.assertNull(authCtx.getPotentialFlows().get("test1"));
        Assert.assertNotNull(authCtx.getPotentialFlows().get("test2"));
        Assert.assertNull(authCtx.getPotentialFlows().get("test3"));
    }
}

